/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import java.io.File;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

class ExecutablesViewerComparator
extends ViewerComparator {
    private int sortType;
    private int columnOrder;

    public ExecutablesViewerComparator(int sortType, int columnOrder) {
        this.sortType = sortType;
        this.columnOrder = columnOrder;
    }

    public int category(Object element) {
        if (element instanceof ITranslationUnit || element instanceof Executable) {
            return 1;
        }
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (this.category(e1) == 1 && this.category(e2) == 1) {
            if (this.sortType == 0) {
                String s1 = ((ColumnLabelProvider)((TreeViewer)viewer).getLabelProvider()).getText(e1);
                String s2 = ((ColumnLabelProvider)((TreeViewer)viewer).getLabelProvider()).getText(e2);
                return this.getComparator().compare(s1, s2) * this.columnOrder;
            }
            if (this.sortType == 3) {
                long file1 = this.getFileSize(e1);
                long file2 = this.getFileSize(e2);
                return Long.valueOf(file1).compareTo(file2) * this.columnOrder;
            }
            if (this.sortType == 2) {
                return this.getComparator().compare(this.getPath(e1).toOSString(), this.getPath(e2).toOSString()) * this.columnOrder;
            }
            if (this.sortType == 4) {
                long file1 = this.getPath(e1).toFile().lastModified();
                long file2 = this.getPath(e2).toFile().lastModified();
                return Long.valueOf(file1).compareTo(file2) * this.columnOrder;
            }
            if (this.sortType == 5) {
                String ext1 = this.getPath(e1).getFileExtension();
                String s1 = ext1 != null ? ext1.toUpperCase() : "";
                String ext2 = this.getPath(e2).getFileExtension();
                String s2 = ext2 != null ? ext2.toUpperCase() : "";
                return this.getComparator().compare(s1, s2) * this.columnOrder;
            }
        }
        return super.compare(viewer, e1, e2);
    }

    private long getFileSize(Object element) {
        File file1 = this.getPath(element).toFile();
        if (file1.exists()) {
            return file1.length();
        }
        return 0L;
    }

    private IPath getPath(Object element) {
        if (element instanceof ITranslationUnit) {
            return ((ITranslationUnit)element).getPath();
        }
        if (element instanceof Executable) {
            return ((Executable)element).getPath();
        }
        return null;
    }
}

