/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IResource;

public class CStyleCastChecker
extends AbstractIndexAstChecker {
    public static final String ERR_ID = "org.eclipse.cdt.codan.internal.checkers.CStyleCastProblem";
    public static final String PARAM_MACRO = "checkMacro";
    private boolean checkMacro = true;

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_MACRO, CheckersMessages.CStyleCastCheck_checkInMacro, true);
    }

    private boolean enclosedInMacroExpansion(IASTExpression statement) {
        IASTNodeLocation[] locations = statement.getNodeLocations();
        return locations.length == 1 && locations[0] instanceof IASTMacroExpansionLocation;
    }

    public void processAst(IASTTranslationUnit ast) {
        IProblem pt = this.getProblemById(ERR_ID, (IResource)this.getFile());
        this.checkMacro = (Boolean)this.getPreference(pt, PARAM_MACRO);
        if (ast.getLinkage().getLinkageID() == 1) {
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitExpressions = true;
                }

                public int visit(IASTExpression expression) {
                    if (expression instanceof IASTCastExpression && (CStyleCastChecker.this.checkMacro || !CStyleCastChecker.this.enclosedInMacroExpansion(expression)) && ((IASTCastExpression)expression).getOperator() == 0) {
                        CStyleCastChecker.this.reportProblem(CStyleCastChecker.ERR_ID, (IASTNode)expression, new Object[0]);
                    }
                    return 3;
                }
            });
        }
    }
}

