/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.meson.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.CBuilder;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.meson.core.Activator;
import org.eclipse.cdt.meson.core.MesonNature;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.tools.templates.freemarker.FMProjectGenerator;
import org.eclipse.tools.templates.freemarker.SourceRoot;
import org.eclipse.tools.templates.freemarker.TemplateManifest;
import org.osgi.framework.Bundle;

public class MesonProjectGenerator
extends FMProjectGenerator {
    public MesonProjectGenerator(String manifestFile) {
        super(manifestFile);
    }

    protected void initProjectDescription(IProjectDescription description) {
        description.setNatureIds(new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature", MesonNature.ID});
        ICommand command = description.newCommand();
        CBuilder.setupBuilder((ICommand)command);
        description.setBuildSpec(new ICommand[]{command});
    }

    public Bundle getSourceBundle() {
        return Activator.getDefault().getBundle();
    }

    public void generate(Map<String, Object> model, IProgressMonitor monitor) throws CoreException {
        super.generate(model, monitor);
        ArrayList<Object> entries = new ArrayList<Object>();
        IProject project = this.getProject();
        IFolder buildFolder = this.getProject().getFolder("build");
        TemplateManifest manifest = this.getManifest();
        if (manifest != null) {
            List srcRoots = this.getManifest().getSrcRoots();
            if (srcRoots != null && !srcRoots.isEmpty()) {
                for (SourceRoot srcRoot : srcRoots) {
                    IFolder sourceFolder = project.getFolder(srcRoot.getDir());
                    if (!sourceFolder.exists()) {
                        sourceFolder.create(true, true, monitor);
                    }
                    entries.add(CoreModel.newSourceEntry((IPath)sourceFolder.getFullPath(), (IPath[])new IPath[]{buildFolder.getFullPath()}));
                }
            } else {
                entries.add(CoreModel.newSourceEntry((IPath)this.getProject().getFullPath()));
            }
        }
        entries.add(CoreModel.newOutputEntry((IPath)buildFolder.getFullPath(), (IPath[])new IPath[]{new Path("**/meson-private/**")}));
        CoreModel.getDefault().create(project).setRawPathEntries(entries.toArray(new IPathEntry[entries.size()]), monitor);
    }
}

