/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.textcanvas;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.terminal.control.ITerminalMouseListener;
import org.eclipse.terminal.internal.textcanvas.GridCanvas;
import org.eclipse.terminal.internal.textcanvas.ILinelRenderer;
import org.eclipse.terminal.internal.textcanvas.ITextCanvasModel;
import org.eclipse.terminal.internal.textcanvas.ITextCanvasModelListener;
import org.eclipse.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.terminal.model.TerminalColor;

public class TextCanvas
extends GridCanvas {
    protected final ITextCanvasModel fCellCanvasModel;
    private final ILinelRenderer fCellRenderer;
    private boolean fScrollLock;
    private Point fDraggingStart;
    private Point fDraggingEnd;
    private boolean fHasSelection;
    private ResizeListener fResizeListener;
    private final List<ITerminalMouseListener> fMouseListeners;
    private SelectionMode fSelMode = SelectionMode.NONE;
    private int fMinColumns = 80;
    private int fMinLines = 4;
    private boolean fCursorEnabled;
    private boolean fResizing;

    public TextCanvas(Composite parent, ITextCanvasModel model, int style, ILinelRenderer cellRenderer) {
        super(parent, style | 0x100 | 0x200);
        this.fCellRenderer = cellRenderer;
        this.setCellWidth(this.fCellRenderer.getCellWidth());
        this.setCellHeight(this.fCellRenderer.getCellHeight());
        this.fCellCanvasModel = model;
        this.fCellCanvasModel.addCellCanvasModelListener(new ITextCanvasModelListener(){

            @Override
            public void rangeChanged(int col, int line, int width, int height) {
                if (TextCanvas.this.isDisposed()) {
                    return;
                }
                TextCanvas.this.repaintRange(col, line, width, height);
            }

            @Override
            public void dimensionsChanged(int cols, int rows) {
                if (TextCanvas.this.isDisposed()) {
                    return;
                }
                TextCanvas.this.calculateGrid();
            }

            @Override
            public void terminalDataChanged() {
                if (TextCanvas.this.isDisposed()) {
                    return;
                }
                if (!TextCanvas.this.fResizing) {
                    TextCanvas.this.calculateGrid();
                    TextCanvas.this.scrollToEnd();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TextCanvas.this.fCellCanvasModel.setCursorEnabled(TextCanvas.this.fCursorEnabled);
            }

            public void focusLost(FocusEvent e) {
                TextCanvas.this.fCellCanvasModel.setCursorEnabled(false);
            }
        });
        this.fMouseListeners = new ArrayList<ITerminalMouseListener>();
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Point pt;
                if (TextCanvas.this.fMouseListeners.size() > 0 && (pt = TextCanvas.this.screenPointToCell(e.x, e.y)) != null) {
                    for (ITerminalMouseListener l : TextCanvas.this.fMouseListeners) {
                        l.mouseDoubleClick(TextCanvas.this.fCellCanvasModel.getTerminalText(), pt.y, pt.x, e.button, e.stateMask);
                    }
                    this.selectWord(pt);
                }
            }

            private void selectWord(Point pt) {
                TextCanvas.this.fSelMode = SelectionMode.WORD;
                TextCanvas.this.fCellCanvasModel.expandHoverSelectionAt(pt.y, pt.x);
                Point start = TextCanvas.this.fCellCanvasModel.getHoverSelectionStart();
                Point end = TextCanvas.this.fCellCanvasModel.getHoverSelectionEnd();
                if (start != null && end != null) {
                    TextCanvas.this.fHasSelection = true;
                    TextCanvas.this.fDraggingStart = start;
                    TextCanvas.this.fCellCanvasModel.setSelectionAnchor(start);
                    TextCanvas.this.fCellCanvasModel.setSelection(start.y, end.y, start.x, end.x);
                } else {
                    TextCanvas.this.fHasSelection = true;
                    TextCanvas.this.fDraggingStart = pt;
                    TextCanvas.this.fCellCanvasModel.setSelectionAnchor(pt);
                    TextCanvas.this.fCellCanvasModel.setSelection(pt.y, pt.y, pt.x, pt.x);
                }
                TextCanvas.this.fCellCanvasModel.expandHoverSelectionAt(-1, -1);
            }

            public void mouseDown(MouseEvent e) {
                Point pt;
                if (e.button == 1) {
                    TextCanvas.this.fSelMode = SelectionMode.DRAG;
                    TextCanvas.this.fDraggingStart = TextCanvas.this.screenPointToCell(e.x, e.y);
                    TextCanvas.this.fHasSelection = false;
                    if ((e.stateMask & 0x20000) != 0) {
                        Point anchor = TextCanvas.this.fCellCanvasModel.getSelectionAnchor();
                        if (anchor != null) {
                            TextCanvas.this.fDraggingStart = anchor;
                        }
                    } else {
                        TextCanvas.this.fCellCanvasModel.setSelectionAnchor(TextCanvas.this.fDraggingStart);
                    }
                    TextCanvas.this.fDraggingEnd = null;
                }
                if (TextCanvas.this.fMouseListeners.size() > 0 && (pt = TextCanvas.this.screenPointToCell(e.x, e.y)) != null) {
                    for (ITerminalMouseListener l : TextCanvas.this.fMouseListeners) {
                        l.mouseDown(TextCanvas.this.fCellCanvasModel.getTerminalText(), pt.y, pt.x, e.button, e.stateMask);
                    }
                }
                if (e.count == 3) {
                    this.selectLine(e);
                }
            }

            private void selectLine(MouseEvent e) {
                TextCanvas.this.fSelMode = SelectionMode.LINE;
                Point pt = TextCanvas.this.screenPointToCell(e.x, e.y);
                if (pt != null) {
                    ITerminalTextDataReadOnly term = TextCanvas.this.fCellCanvasModel.getTerminalText();
                    int row = Math.max(0, Math.min(pt.y, term.getHeight() - 1));
                    int startCol = 0;
                    int endCol = Math.max(0, term.getWidth() - 1);
                    Point start = new Point(startCol, row);
                    Point end = new Point(endCol, row);
                    TextCanvas.this.fHasSelection = true;
                    TextCanvas.this.fDraggingStart = start;
                    TextCanvas.this.fCellCanvasModel.setSelectionAnchor(start);
                    TextCanvas.this.fCellCanvasModel.setSelection(start.y, end.y, start.x, end.x);
                    if (TextCanvas.this.fMouseListeners.size() > 0) {
                        for (ITerminalMouseListener l : TextCanvas.this.fMouseListeners) {
                            l.mouseDown(term, pt.y, pt.x, e.button, e.stateMask);
                        }
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                Point pt;
                if (e.button == 1) {
                    if (TextCanvas.this.fSelMode == SelectionMode.DRAG) {
                        TextCanvas.this.updateHasSelection(e);
                        if (TextCanvas.this.fHasSelection) {
                            TextCanvas.this.setSelection(TextCanvas.this.screenPointToCell(e.x, e.y));
                        } else {
                            TextCanvas.this.fCellCanvasModel.setSelection(-1, -1, -1, -1);
                        }
                    }
                    TextCanvas.this.fDraggingStart = null;
                    TextCanvas.this.fSelMode = SelectionMode.NONE;
                }
                if (TextCanvas.this.fMouseListeners.size() > 0 && (pt = TextCanvas.this.screenPointToCell(e.x, e.y)) != null) {
                    for (ITerminalMouseListener l : TextCanvas.this.fMouseListeners) {
                        l.mouseUp(TextCanvas.this.fCellCanvasModel.getTerminalText(), pt.y, pt.x, e.button, e.stateMask);
                    }
                }
            }
        });
        this.addMouseMoveListener(e -> {
            if (this.fDraggingStart != null) {
                Point curr = this.screenPointToCell(e.x, e.y);
                this.updateHasSelection(e);
                switch (this.fSelMode) {
                    case WORD: {
                        this.updateWordSelection(curr);
                        break;
                    }
                    case LINE: {
                        this.updateLineSelection(curr);
                        break;
                    }
                    default: {
                        this.setSelection(curr);
                    }
                }
                this.fCellCanvasModel.expandHoverSelectionAt(-1, -1);
            } else if ((e.stateMask & SWT.MODIFIER_MASK) == SWT.MOD1) {
                Point pt = this.screenPointToCell(e.x, e.y);
                this.fCellCanvasModel.expandHoverSelectionAt(pt.y, pt.x);
            } else {
                this.fCellCanvasModel.expandHoverSelectionAt(-1, -1);
            }
            this.redraw();
        });
        this.setVerticalBarVisible(true);
        this.setHorizontalBarVisible(false);
    }

    private Range wordRangeAt(Point pt) {
        this.fCellCanvasModel.expandHoverSelectionAt(pt.y, pt.x);
        return new Range(this.fCellCanvasModel.getHoverSelectionStart(), this.fCellCanvasModel.getHoverSelectionEnd());
    }

    private void setNormalizedSelection(Point start, Point end) {
        if (start == null || end == null) {
            return;
        }
        Point e = end;
        Point s = start;
        if (this.compare(e, s) < 0) {
            s = end;
            e = start;
        }
        int sCol = Math.max(0, s.x);
        int sRow = Math.max(0, s.y);
        this.fCellCanvasModel.setSelection(sRow, e.y, sCol, e.x);
    }

    private void updateWordSelection(Point curr) {
        if (this.fDraggingStart == null || curr == null) {
            return;
        }
        Range anchor = this.wordRangeAt(this.fDraggingStart);
        Range current = this.wordRangeAt(curr);
        if (!anchor.isValid() || !current.isValid()) {
            return;
        }
        if (this.compare(current.start, anchor.start) < 0) {
            this.setNormalizedSelection(current.start, anchor.end);
        } else {
            this.setNormalizedSelection(anchor.start, current.end);
        }
        this.fHasSelection = true;
        this.fCellCanvasModel.expandHoverSelectionAt(-1, -1);
    }

    private void updateLineSelection(Point curr) {
        if (this.fDraggingStart == null || curr == null) {
            return;
        }
        ITerminalTextDataReadOnly term = this.fCellCanvasModel.getTerminalText();
        int startRow = Math.max(0, Math.min(this.fDraggingStart.y, curr.y));
        int endRow = Math.max(0, Math.max(this.fDraggingStart.y, curr.y));
        int endCol = Math.max(0, term.getWidth() - 1);
        this.setNormalizedSelection(new Point(0, startRow), new Point(endCol, endRow));
        this.fCellCanvasModel.setSelectionAnchor(new Point(0, this.fDraggingStart.y));
        this.fHasSelection = true;
    }

    private void updateHasSelection(MouseEvent e) {
        if (this.fDraggingStart != null) {
            Point p = this.screenPointToCell(e.x, e.y);
            if (this.fDraggingStart.x != p.x || this.fDraggingStart.y != p.y) {
                this.fHasSelection = true;
            }
        }
    }

    void setSelection(Point p) {
        if (this.fDraggingStart != null && !p.equals((Object)this.fDraggingEnd)) {
            this.fDraggingEnd = p;
            if (this.compare(p, this.fDraggingStart) < 0) {
                int startColumn = Math.max(0, p.x);
                int startRow = Math.max(p.y, 0);
                this.fCellCanvasModel.setSelection(startRow, this.fDraggingStart.y, startColumn, this.fDraggingStart.x);
            } else {
                this.fCellCanvasModel.setSelection(this.fDraggingStart.y, p.y, this.fDraggingStart.x, p.x);
            }
        }
    }

    int compare(Point p1, Point p2) {
        if (p1.equals((Object)p2)) {
            return 0;
        }
        if (p1.y == p2.y) {
            if (p1.x > p2.x) {
                return 1;
            }
            return -1;
        }
        if (p1.y > p2.y) {
            return 1;
        }
        return -1;
    }

    public ILinelRenderer getCellRenderer() {
        return this.fCellRenderer;
    }

    public int getMinColumns() {
        return this.fMinColumns;
    }

    public void setMinColumns(int minColumns) {
        this.fMinColumns = minColumns;
    }

    public int getMinLines() {
        return this.fMinLines;
    }

    public void setMinLines(int minLines) {
        this.fMinLines = minLines;
    }

    protected void onResize(boolean init) {
        if (this.fResizeListener != null) {
            Rectangle bonds = this.getClientArea();
            int cellHeight = this.getCellHeight();
            int cellWidth = this.getCellWidth();
            int lines = bonds.height / cellHeight;
            int columns = bonds.width / cellWidth;
            if (lines > 0 && columns > 0 || init) {
                if (columns < this.fMinColumns) {
                    if (!this.isHorizontalBarVisble()) {
                        this.setHorizontalBarVisible(true);
                        bonds = this.getClientArea();
                        lines = bonds.height / cellHeight;
                    }
                    columns = this.fMinColumns;
                } else if (columns >= this.fMinColumns && this.isHorizontalBarVisble()) {
                    this.setHorizontalBarVisible(false);
                    bonds = this.getClientArea();
                    lines = bonds.height / cellHeight;
                    columns = bonds.width / cellWidth;
                }
                if (lines < this.fMinLines) {
                    lines = this.fMinLines;
                }
                this.fResizeListener.sizeChanged(lines, columns);
            }
        }
        super.onResize();
        this.calculateGrid();
    }

    @Override
    protected void onResize() {
        this.fResizing = true;
        try {
            this.onResize(false);
        }
        finally {
            this.fResizing = false;
        }
    }

    private void calculateGrid() {
        Rectangle virtualBounds = this.getVirtualBounds();
        this.setRedraw(false);
        try {
            this.setVirtualExtend(this.getCols() * this.getCellWidth(), this.getRows() * this.getCellHeight());
            this.getParent().layout();
            if (this.fResizing) {
                Rectangle viewRect = this.getViewRectangle();
                if (virtualBounds.height - (viewRect.y + viewRect.height) < this.getCellHeight() * 2) {
                    this.scrollToEnd();
                }
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    void scrollToEnd() {
        if (!this.fScrollLock) {
            int y = -(this.getRows() * this.getCellHeight() - this.getClientArea().height);
            if (y > 0) {
                y = 0;
            }
            Rectangle v = this.getViewRectangle();
            if (v.y != -y) {
                this.setVirtualOrigin(v.x, y);
            }
            this.scrollY(this.getVerticalBar());
            this.scrollX(this.getHorizontalBar());
        }
    }

    public boolean isScrollLock() {
        return this.fScrollLock;
    }

    public void setScrollLock(boolean scrollLock) {
        this.fScrollLock = scrollLock;
    }

    protected void repaintRange(int col, int line, int width, int height) {
        Point origin = this.cellToOriginOnScreen(col, line);
        Rectangle r = new Rectangle(origin.x, origin.y, width * this.getCellWidth(), height * this.getCellHeight());
        this.repaint(r);
    }

    @Override
    protected void drawLine(GC gc, int line, int x, int y, int colFirst, int colLast) {
        this.fCellRenderer.drawLine(this.fCellCanvasModel, gc, line, x, y, colFirst, colLast);
    }

    @Override
    protected Color getTerminalBackgroundColor(Device device) {
        return this.fCellRenderer.getDefaultBackgroundColor();
    }

    @Override
    protected void visibleCellRectangleChanged(int x, int y, int width, int height) {
        this.fCellCanvasModel.setVisibleRectangle(y, x, height, width);
        this.update();
    }

    @Override
    protected int getCols() {
        return this.fCellCanvasModel.getTerminalText().getWidth();
    }

    @Override
    protected int getRows() {
        return this.fCellCanvasModel.getTerminalText().getHeight();
    }

    public String getSelectionText() {
        return this.fCellCanvasModel.getSelectedText();
    }

    public void copy() {
        String selectionText = this.getSelectionText();
        if (selectionText != null && selectionText.length() > 0) {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            clipboard.setContents(new Object[]{selectionText}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public void selectAll() {
        this.fCellCanvasModel.setSelection(0, this.fCellCanvasModel.getTerminalText().getHeight(), 0, this.fCellCanvasModel.getTerminalText().getWidth());
        this.fCellCanvasModel.setSelectionAnchor(new Point(0, 0));
    }

    public void clearSelection() {
        this.fCellCanvasModel.setSelection(-1, -1, -1, -1);
    }

    public String getAllText() {
        return this.fCellCanvasModel.getAllText();
    }

    public boolean isEmpty() {
        return false;
    }

    public void addResizeHandler(ResizeListener listener) {
        if (this.fResizeListener != null) {
            throw new IllegalArgumentException("There can be at most one listener at the moment!");
        }
        this.fResizeListener = listener;
        Rectangle bonds = this.getClientArea();
        if (bonds.height < this.getCellHeight() || bonds.width < this.getCellWidth()) {
            this.fResizeListener.sizeChanged(this.getMinLines(), this.getMinColumns());
        } else {
            this.onResize(true);
        }
    }

    public void updateFont(String fontName) {
        this.fCellRenderer.updateFont(fontName);
        this.setCellWidth(this.fCellRenderer.getCellWidth());
        this.setCellHeight(this.fCellRenderer.getCellHeight());
        this.calculateGrid();
    }

    public void updateColors(Map<TerminalColor, RGB> map) {
        this.fCellRenderer.updateColors(map);
        this.redraw();
    }

    public void setInvertedColors(boolean invert) {
        this.fCellRenderer.setInvertedColors(invert);
        this.redraw();
    }

    public boolean isInvertedColors() {
        return this.fCellRenderer.isInvertedColors();
    }

    public boolean isCursorEnabled() {
        return this.fCursorEnabled;
    }

    public void setCursorEnabled(boolean enabled) {
        if (enabled != this.fCursorEnabled) {
            this.fCursorEnabled = enabled;
            this.fCellCanvasModel.setCursorEnabled(this.fCursorEnabled);
        }
    }

    public void addTerminalMouseListener(ITerminalMouseListener listener) {
        this.fMouseListeners.add(listener);
    }

    public void removeTerminalMouseListener(ITerminalMouseListener listener) {
        this.fMouseListeners.remove(listener);
    }

    public String getHoverSelection() {
        return this.fCellCanvasModel.getHoverSelectionText();
    }

    private static class Range {
        final Point start;
        final Point end;

        Range(Point start, Point end) {
            this.start = start;
            this.end = end;
        }

        boolean isValid() {
            return this.start != null && this.end != null;
        }
    }

    public static interface ResizeListener {
        public void sizeChanged(int var1, int var2);
    }

    private static enum SelectionMode {
        NONE,
        DRAG,
        WORD,
        LINE;

    }
}

