/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ShowCapabilitiesPreferenceAction
implements ILiveHelpAction {
    private boolean narrow;

    public void setInitializationString(String data) {
        if (data != null && data.equals("narrow")) {
            this.narrow = true;
        }
    }

    public void run() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(() -> {
            Shell windowShell = null;
            if (!this.narrow) {
                Shell[] shells = display.getShells();
                int i = 0;
                while (i < shells.length) {
                    Object data = shells[i].getData();
                    if (data != null && data instanceof IWorkbenchWindow) {
                        windowShell = shells[i];
                        break;
                    }
                    ++i;
                }
            }
            if (windowShell != null) {
                windowShell.forceActive();
                if (Platform.getWS().equals("win32")) {
                    windowShell.setVisible(false);
                    windowShell.setMinimized(true);
                    windowShell.setVisible(true);
                    windowShell.setMinimized(false);
                }
            }
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(windowShell, (String)this.getCapabilityPageId(), null, null);
            dialog.open();
        });
    }

    private String getCapabilityPageId() {
        return "org.eclipse.sdk.capabilities";
    }
}

