/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GistRepositoryQueryPage
extends AbstractRepositoryQueryPage {
    private Text titleText;
    private Text userText;

    public GistRepositoryQueryPage(TaskRepository taskRepository, IRepositoryQuery query) {
        this("gistQueryPage", taskRepository, query);
    }

    public GistRepositoryQueryPage(String pageName, TaskRepository taskRepository, IRepositoryQuery query) {
        super(pageName, taskRepository, query);
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        this.initializeDialogUnits((Control)displayArea);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(displayArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)displayArea);
        ModifyListener completeListener = e -> this.setPageComplete(this.isPageComplete());
        if (!this.inSearchContainer()) {
            new Label(displayArea, 0).setText(Messages.GistRepositoryQueryPage_LabelTitle);
            this.titleText = new Text(displayArea, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.titleText);
            this.titleText.addModifyListener(completeListener);
            this.titleText.setFocus();
        }
        new Label(displayArea, 0).setText(Messages.GistRepositoryQueryPage_LabelUser);
        this.userText = new Text(displayArea, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.userText);
        this.userText.addModifyListener(completeListener);
        IRepositoryQuery query = this.getQuery();
        if (query != null) {
            if (this.titleText != null && query.getSummary() != null) {
                this.titleText.setText(query.getSummary());
            }
            if (query.getAttribute("user") != null) {
                this.userText.setText(query.getAttribute("user"));
            }
        } else if (!this.inSearchContainer() && !this.hasQueries()) {
            this.titleText.setText(Messages.GistRepositoryQueryPage_TitleDefault);
            AuthenticationCredentials credentials = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
            if (credentials != null) {
                this.userText.setText(credentials.getUserName());
            }
        }
        Dialog.applyDialogFont((Control)displayArea);
        this.setControl((Control)displayArea);
        this.setPageComplete(this.isPageComplete());
    }

    protected boolean hasQueries() {
        String url = this.getTaskRepository().getRepositoryUrl();
        return !TasksUiPlugin.getTaskList().getRepositoryQueries(url).isEmpty();
    }

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : null;
    }

    public boolean isPageComplete() {
        boolean complete;
        boolean bl = complete = this.inSearchContainer() ? true : super.isPageComplete();
        if (complete) {
            complete = this.userText.getText().trim().length() > 0;
        }
        return complete;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        query.setAttribute("user", this.userText.getText().trim());
    }
}

