/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.internal.handler;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.terminal.view.core.TerminalContextPropertiesProviderFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalContextPropertiesProvider;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.ILauncherDelegate;
import org.eclipse.tm.terminal.view.ui.internal.dialogs.LaunchTerminalSettingsDialog;
import org.eclipse.tm.terminal.view.ui.launcher.LauncherDelegateManager;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchTerminalCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        long start = System.currentTimeMillis();
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(start));
            UIPlugin.getTraceHandler().trace("Started at " + date + " (" + start + ")", "trace/launchTerminalCommandHandler", (Object)this);
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (commandId.equals("org.eclipse.tm.terminal.view.ui.command.launchToolbar")) {
            Map<String, Object> properties;
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("(a) Attempt to open launch terminal settings dialog after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell, start);
            if (this.isValidSelection(selection)) {
                dialog.setSelection(selection);
            }
            if (dialog.open() == 0 && (properties = dialog.getSettings()) != null) {
                String delegateId = (String)properties.get("delegateId");
                Assert.isNotNull((Object)delegateId);
                ILauncherDelegate delegate = LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false);
                Assert.isNotNull((Object)delegateId);
                delegate.execute(properties, null);
            }
        } else {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Getting applicable launcher delegates after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            ILauncherDelegate[] delegates = LauncherDelegateManager.getInstance().getApplicableLauncherDelegates(selection);
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Got applicable launcher delegates after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            if (delegates.length > 1 || delegates.length == 1 && delegates[0].needsUserConfiguration()) {
                Map<String, Object> properties;
                if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                    UIPlugin.getTraceHandler().trace("(b) Attempt to open launch terminal settings dialog after " + (System.currentTimeMillis() - start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
                }
                LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell, start);
                if (this.isValidSelection(selection)) {
                    dialog.setSelection(selection);
                }
                if (dialog.open() == 0 && (properties = dialog.getSettings()) != null) {
                    String delegateId = (String)properties.get("delegateId");
                    Assert.isNotNull((Object)delegateId);
                    ILauncherDelegate delegate = LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false);
                    Assert.isNotNull((Object)delegateId);
                    delegate.execute(properties, null);
                }
            } else if (delegates.length == 1) {
                ILauncherDelegate delegate = delegates[0];
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("delegateId", delegate.getId());
                properties.put("selection", selection);
                delegate.execute(properties, null);
            }
        }
        return null;
    }

    private boolean isValidSelection(ISelection selection) {
        Map props;
        Object element;
        ITerminalContextPropertiesProvider provider;
        return selection instanceof IStructuredSelection && !selection.isEmpty() && (provider = TerminalContextPropertiesProviderFactory.getProvider((Object)(element = ((IStructuredSelection)selection).getFirstElement()))) != null && (props = provider.getTargetAddress(element)) != null && props.containsKey("address");
    }
}

