/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.AvgMipmapFeature;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.ITmfMipmapFeature;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.MaxMipmapFeature;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.MinMipmapFeature;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.TmfMipmapFeature;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfMipmapStateProvider
extends AbstractTmfStateProvider {
    public static final int MAX = 2;
    public static final int MIN = 4;
    public static final int AVG = 8;
    public static final String MAX_STRING = "max";
    public static final String MIN_STRING = "min";
    public static final String AVG_STRING = "avg";
    private Map<Integer, Set<ITmfMipmapFeature>> featureMap = new HashMap<Integer, Set<ITmfMipmapFeature>>();

    public AbstractTmfMipmapStateProvider(@NonNull ITmfTrace trace, @NonNull String id) {
        super(trace, id);
    }

    @Override
    public void dispose() {
        this.waitForEmptyQueue();
        for (Set<ITmfMipmapFeature> features : this.featureMap.values()) {
            for (ITmfMipmapFeature feature : features) {
                feature.updateAndCloseMipmap();
            }
        }
        super.dispose();
    }

    public void modifyMipmapAttribute(long ts, ITmfStateValue value, int baseQuark, int mipmapFeatureBits, int resolution) throws TimeRangeException, StateValueTypeException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        ss.modifyAttribute(ts, value.unboxValue(), baseQuark);
        if (value.getType() == ITmfStateValue.Type.LONG || value.getType() == ITmfStateValue.Type.INTEGER || value.getType() == ITmfStateValue.Type.DOUBLE || value.isNull()) {
            Set<ITmfMipmapFeature> features = this.getFeatureSet(baseQuark, ts, value, mipmapFeatureBits, resolution);
            for (ITmfMipmapFeature mf : features) {
                mf.updateMipmap(value, ts);
            }
        }
    }

    private Set<ITmfMipmapFeature> getFeatureSet(int baseQuark, long ts, ITmfStateValue value, int mipmapFeatureBits, int resolution) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        Set<ITmfMipmapFeature> features = this.featureMap.get(baseQuark);
        if (features != null) {
            return features;
        }
        features = new LinkedHashSet<ITmfMipmapFeature>();
        if (value.isNull()) {
            return features;
        }
        this.featureMap.put(baseQuark, features);
        if (resolution > 1) {
            try {
                TmfMipmapFeature mf;
                int featureQuark;
                if ((mipmapFeatureBits & 2) != 0) {
                    featureQuark = ss.getQuarkRelativeAndAdd(baseQuark, new String[]{MAX_STRING});
                    ss.modifyAttribute(ts, (Object)0, featureQuark);
                    mf = new MaxMipmapFeature(baseQuark, featureQuark, resolution, ss);
                    features.add(mf);
                }
                if ((mipmapFeatureBits & 4) != 0) {
                    featureQuark = ss.getQuarkRelativeAndAdd(baseQuark, new String[]{MIN_STRING});
                    ss.modifyAttribute(ts, (Object)0, featureQuark);
                    mf = new MinMipmapFeature(baseQuark, featureQuark, resolution, ss);
                    features.add(mf);
                }
                if ((mipmapFeatureBits & 8) != 0) {
                    featureQuark = ss.getQuarkRelativeAndAdd(baseQuark, new String[]{AVG_STRING});
                    ss.modifyAttribute(ts, (Object)0, featureQuark);
                    mf = new AvgMipmapFeature(baseQuark, featureQuark, resolution, ss);
                    features.add(mf);
                }
            }
            catch (TimeRangeException e) {
                Activator.logError("MipMapProvider : Time stamp outside of time range of state system", e);
            }
            catch (StateValueTypeException e) {
                Activator.logError("MipMapProvider : Wrong state value type", e);
            }
        }
        return features;
    }
}

