/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.jobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.Utils;
import org.eclipse.embedcdt.packs.core.data.DataManager;
import org.eclipse.embedcdt.packs.core.data.DataUtils;
import org.eclipse.embedcdt.packs.core.data.FileNotFoundException;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class InstallJob
extends Job {
    private static boolean fgRunning = false;
    private IConsoleStream fOut = Activator.getInstance().getConsoleOutput();
    private List<Node> fSelection;
    private IProgressMonitor fMonitor;
    private DataManager fDataManager;

    public InstallJob(String name, List<Node> selection) {
        super(name);
        this.fSelection = selection;
        this.fDataManager = DataManager.getInstance();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        if (fgRunning) {
            return Status.CANCEL_STATUS;
        }
        fgRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(Utils.getCurrentDateTime());
        this.fOut.println("Installing packs...");
        ArrayList<Node> packsToInstall = new ArrayList<Node>();
        for (Node node : this.fSelection) {
            if (node.isBooleanProperty("installed")) continue;
            String type = node.getType();
            if ("package".equals(type)) {
                packsToInstall.add((Node)node.getFirstChild());
                continue;
            }
            if (!"version".equals(type)) continue;
            packsToInstall.add(node);
        }
        int workUnits = 0;
        int i = 0;
        while (i < packsToInstall.size()) {
            workUnits += this.computeWorkUnits((Node)packsToInstall.get(i), this.fOut);
            ++i;
        }
        monitor.beginTask("Install packs", ++workUnits);
        Boolean notifyUpdate = false;
        LinkedList<Leaf> installedPacksList = new LinkedList<Leaf>();
        for (Node versionNode : packsToInstall) {
            if (monitor.isCanceled()) break;
            String packFullName = versionNode.getProperty("archive.name");
            monitor.subTask(packFullName);
            this.fOut.println("Installing \"" + packFullName + "\"...");
            try {
                if (this.installPack(versionNode)) {
                    installedPacksList.add(versionNode);
                    versionNode.setBooleanProperty("installed", true);
                } else {
                    versionNode.putProperty("archive.size", "-1");
                }
                notifyUpdate = true;
            }
            catch (IOException e) {
                this.fOut.println(DataUtils.reportError(e.toString()));
            }
        }
        if (notifyUpdate.booleanValue()) {
            this.fDataManager.notifyUpdateView("update.versions", installedPacksList);
            this.fDataManager.notifyInstallRemove();
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            int n;
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            if ((n = installedPacksList.size()) == 0) {
                this.fOut.print("No packs");
            } else if (n == 1) {
                this.fOut.print("1 pack");
            } else {
                this.fOut.print(String.valueOf(installedPacksList.size()) + " packs");
            }
            this.fOut.println(" installed.");
            this.fOut.print("Install completed in ");
            if (duration < 1500L) {
                this.fOut.println(String.valueOf(duration) + "ms.");
            } else {
                this.fOut.println(String.valueOf((duration + 500L) / 1000L) + "s.");
            }
            status = Status.OK_STATUS;
        }
        fgRunning = false;
        return status;
    }

    private int computeWorkUnits(Node versionNode, IConsoleStream out) {
        int workUnits = 0;
        String size = versionNode.getProperty("archive.size", "0");
        try {
            workUnits += Integer.valueOf(size).intValue();
        }
        catch (NumberFormatException e) {
            Activator.log((Throwable)e);
        }
        Node packNode = versionNode.getParent();
        String pdscUrl = packNode.getProperty("archive.url");
        if (pdscUrl.length() > 0) {
            try {
                int sz = PacksStorage.getRemoteFileSize(new URL(pdscUrl), out);
                if (sz > 0) {
                    workUnits += sz;
                }
            }
            catch (IOException e) {
                Activator.log((Throwable)e);
            }
        }
        return workUnits;
    }

    private boolean installPack(Node versionNode) throws IOException {
        File archiveFile;
        String archiveName;
        block8: {
            URL packUrl = new URL(versionNode.getProperty("archive.url"));
            archiveName = versionNode.getProperty("archive.name");
            archiveFile = PacksStorage.getCachedFileObject(archiveName);
            if (archiveFile == null || !archiveFile.exists()) {
                File archiveFileDownload = PacksStorage.getCachedFileObject(String.valueOf(archiveName) + ".download");
                try {
                    if (this.copyFile(packUrl, archiveFileDownload)) {
                        archiveFileDownload.renameTo(archiveFile);
                        DataUtils.reportInfo("CMSIS Pack " + archiveName + " downloaded.");
                        break block8;
                    }
                    return false;
                }
                catch (FileNotFoundException e) {
                    String msg = e.getMessage();
                    DataUtils.reportError(msg);
                    this.fOut.println(msg);
                    return false;
                }
            }
            this.fMonitor.worked((int)archiveFile.length());
        }
        String dest = versionNode.getProperty("dest.folder");
        Path destRelPath = new Path(dest);
        File destFolder = PacksStorage.getFileObject(dest);
        if (destFolder.exists()) {
            this.fOut.println("Remove existing \"" + destRelPath + "\".");
            DataUtils.deleteFolderRecursive(destFolder);
        }
        boolean flag = false;
        try {
            flag = this.unzip(archiveFile, (IPath)destRelPath);
        }
        catch (IOException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + archiveFile.getName();
            this.fOut.println("Error: " + msg);
            DataUtils.reportError(msg);
        }
        if (!flag) {
            this.fOut.println("Install cancelled due to errors.");
            DataUtils.deleteFolderRecursive(destFolder);
            archiveFile.delete();
            return false;
        }
        DataUtils.makeFolderReadOnlyRecursive(destRelPath.toFile());
        DataUtils.reportInfo("CMSIS Pack " + archiveName + " installed.");
        this.fOut.println("All files set to read only.");
        return true;
    }

    private boolean copyFile(URL sourceUrl, File destinationFile) throws IOException {
        DataUtils.copyFile(sourceUrl, destinationFile, this.fOut, this.fMonitor);
        return true;
    }

    private boolean unzip(File archiveFile, IPath destRelativePath) throws IOException {
        this.fOut.println("Unzipping \"" + archiveFile + "\"...");
        boolean result = true;
        ZipInputStream zipInput = new ZipInputStream(new FileInputStream(archiveFile));
        ZipEntry zipEntry = zipInput.getNextEntry();
        int countFiles = 0;
        int countBytes = 0;
        while (zipEntry != null && result) {
            if (!zipEntry.isDirectory()) {
                String msg;
                int bytesRead;
                String fileName = zipEntry.getName();
                IPath path = destRelativePath.append(fileName);
                File outFile = PacksStorage.getFileObject(path.toString());
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                this.fOut.println("Writing \"" + outFile + "\"...");
                FileOutputStream output = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((bytesRead = zipInput.read(buf)) > 0) {
                    try {
                        ((OutputStream)output).write(buf, 0, bytesRead);
                    }
                    catch (IOException e) {
                        msg = String.valueOf(e.getMessage()) + ", file: " + outFile.getName();
                        this.fOut.println("Error: " + msg);
                        DataUtils.reportError(msg);
                        result = false;
                        break;
                    }
                    countBytes += bytesRead;
                }
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    msg = String.valueOf(e.getMessage()) + ", file: " + outFile.getName();
                    this.fOut.println("Error: " + msg);
                    DataUtils.reportError(msg);
                    result = false;
                }
                outFile.setReadOnly();
                ++countFiles;
            }
            zipEntry = zipInput.getNextEntry();
        }
        this.fMonitor.worked(1);
        zipInput.closeEntry();
        zipInput.close();
        if (countBytes > 0) {
            this.fOut.println(String.valueOf(countFiles) + " files written, " + StringUtils.convertSizeToString((int)countBytes) + ".");
        } else {
            this.fOut.println("No files written.");
            result = false;
        }
        return result;
    }
}

