/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class CompressedReader {
    private final DataInputStream in;
    private char[] lastName;
    private final ArrayList<String> lastWords;

    public CompressedReader(DataInputStream in) {
        this.in = in;
        this.lastName = new char[0];
        this.lastWords = new ArrayList();
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public char[] readChars() throws IOException {
        return this.in.readUTF().toCharArray();
    }

    public String readStringUsingLast() throws IOException {
        return new String(this.readCharsUsingLast());
    }

    public String readStringUsingDictionary() throws IOException {
        String v;
        int size = this.lastWords.size();
        int index = this.readIntInRange(size + 1);
        if (index == 0) {
            v = this.in.readUTF();
            this.lastWords.add(v);
        } else {
            v = this.lastWords.get(index - 1);
        }
        return v;
    }

    public int readIntWithHint(int[] typical) throws IOException {
        int i = this.readIntInRange(typical.length + 1);
        if (i == typical.length) {
            return this.readInt();
        }
        return typical[i];
    }

    public int readIntInRange(int range) throws IOException {
        if (range < 0 || range > 0xFFFFFF) {
            return this.in.readInt();
        }
        if (range <= 255) {
            return Byte.toUnsignedInt(this.in.readByte());
        }
        if (range <= 65535) {
            return Short.toUnsignedInt(this.in.readShort());
        }
        byte b = this.in.readByte();
        short s = this.in.readShort();
        return (s << 8 | b & 0xFF) & 0xFFFFFF;
    }

    public char[] readCharsUsingLast() throws IOException {
        int commonLength = this.in.readByte() & 0xFF;
        char[] suffix = this.readStringUsingDictionary().toCharArray();
        char[] name = new char[commonLength + suffix.length];
        System.arraycopy(this.lastName, 0, name, 0, commonLength);
        System.arraycopy(suffix, 0, name, commonLength, suffix.length);
        this.lastName = name;
        return name;
    }
}

