/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.eventdensity;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.tmf.core.histogram.Messages;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class EventDensityTreeViewer
extends AbstractSelectTreeViewer2 {
    public EventDensityTreeViewer(Composite parent) {
        super(parent, 1, "org.eclipse.tracecompass.internal.tmf.core.histogram.HistogramDataProvider");
        this.setLabelProvider((IBaseLabelProvider)new HistogramLabelProvider());
    }

    @Override
    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> ImmutableList.of((Object)EventDensityTreeViewer.createColumn(Messages.NewHistogramTree_ColumnName, Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)new TmfTreeColumnData(Messages.NewHistogramTree_Legend));
    }

    private class HistogramLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        private HistogramLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof TmfGenericTreeEntry) {
                TmfGenericTreeEntry genericEntry = (TmfGenericTreeEntry)element;
                return genericEntry.getName();
            }
            return null;
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            TmfGenericTreeEntry genericEntry;
            if (columnIndex == 1 && element instanceof TmfGenericTreeEntry && EventDensityTreeViewer.this.isChecked(element) && !(genericEntry = (TmfGenericTreeEntry)element).hasChildren()) {
                return EventDensityTreeViewer.this.getLegendImage(((TmfTreeDataModel)genericEntry.getModel()).getId());
            }
            return null;
        }
    }
}

