/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import com.google.common.collect.ImmutableList;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

abstract class TimeDraw {
    protected static final long MICROSEC_IN_NS = 1000L;
    protected static final long MILLISEC_IN_NS = 1000000L;
    protected static final long MILLISEC_IN_US = 1000L;
    protected static final long SEC_IN_NS = 1000000000L;
    protected static final long SEC_IN_MS = 1000L;
    private static final String S = "";
    private static final String S0 = "0";
    private static final String S00 = "00";
    protected static final long PAD_1000 = 1000L;
    protected static final SimpleDateFormat SEC_FORMAT_HEADER = new SimpleDateFormat("yyyy MMM dd");
    protected static final SimpleDateFormat SEC_FORMAT = new SimpleDateFormat("HH:mm:ss");
    protected static final SimpleDateFormat MIN_FORMAT_HEADER = new SimpleDateFormat("yyyy MMM dd");
    protected static final SimpleDateFormat MIN_FORMAT = new SimpleDateFormat("HH:mm");
    protected static final SimpleDateFormat HOURS_FORMAT_HEADER = new SimpleDateFormat("yyyy");
    protected static final SimpleDateFormat HOURS_FORMAT = new SimpleDateFormat("MMM dd HH:mm");
    protected static final SimpleDateFormat DAY_FORMAT_HEADER = new SimpleDateFormat("yyyy");
    protected static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("MMM dd");
    protected static final SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("yyyy MMM");
    protected static final SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");
    protected static final List<SimpleDateFormat> formats;

    static {
        ImmutableList.Builder formatArrayBuilder = ImmutableList.builder();
        formatArrayBuilder.add((Object)SEC_FORMAT);
        formatArrayBuilder.add((Object)SEC_FORMAT_HEADER);
        formatArrayBuilder.add((Object)MIN_FORMAT);
        formatArrayBuilder.add((Object)MIN_FORMAT_HEADER);
        formatArrayBuilder.add((Object)HOURS_FORMAT);
        formatArrayBuilder.add((Object)HOURS_FORMAT_HEADER);
        formatArrayBuilder.add((Object)DAY_FORMAT);
        formatArrayBuilder.add((Object)DAY_FORMAT_HEADER);
        formatArrayBuilder.add((Object)MONTH_FORMAT);
        formatArrayBuilder.add((Object)YEAR_FORMAT);
        formats = formatArrayBuilder.build();
    }

    TimeDraw() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTimeZone() {
        TimeZone timeZone = TmfTimePreferences.getTimeZone();
        Iterator<SimpleDateFormat> iterator = formats.iterator();
        while (iterator.hasNext()) {
            SimpleDateFormat sdf;
            SimpleDateFormat simpleDateFormat = sdf = iterator.next();
            synchronized (simpleDateFormat) {
                sdf.setTimeZone(timeZone);
            }
        }
    }

    static String sep(long n) {
        StringBuilder retVal = new StringBuilder();
        String s = Long.toString(n);
        int i = 0;
        while (i < s.length()) {
            int pos = s.length() - i - 1;
            retVal.append(s.charAt(i));
            if (pos % 3 == 0 && pos != 0) {
                retVal.append(' ');
            }
            ++i;
        }
        return retVal.toString();
    }

    static String pad(long n) {
        String s = n < 10L ? S00 : (n < 100L ? S0 : S);
        return s + n;
    }

    public abstract int draw(GC var1, long var2, Rectangle var4);

    public void drawAbsHeader(GC gc, long nanosec, Rectangle absHeaderRect) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawAbsHeader(GC gc, long nanosec, Rectangle rect, SimpleDateFormat dateFormat) {
        String header;
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            header = dateFormat.format(new Date(nanosec / 1000000L));
        }
        int headerwidth = gc.stringExtent((String)header).x + 4;
        if (headerwidth <= rect.width) {
            rect.x += rect.width - headerwidth;
            Utils.drawText(gc, header, rect, true);
        }
    }
}

