/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.memory;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.IMemoryBlockAddressInfoRetrieval;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRegisters2;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.memory.MemoryBlockAddressInfoItem;
import org.eclipse.cdt.dsf.gdb.memory.IGdbMemoryAddressInfoTypeRetrieval;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IMemoryBlock;

public class GdbMemoryAddressInfoRegistersRetrieval
implements IGdbMemoryAddressInfoTypeRetrieval {
    private static final String REGISTERS_INFO_TYPE = "Registers";
    private final DsfSession fSession;

    public GdbMemoryAddressInfoRegistersRetrieval(DsfSession session) {
        this.fSession = session;
    }

    @Override
    public void itemsRequest(IDMContext context, final IMemoryBlock memBlock, final DataRequestMonitor<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[]> rm) {
        if (this.fSession == null || this.fSession.getExecutor() == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Initialization problem, invalid session"));
            return;
        }
        DsfExecutor executor = this.fSession.getExecutor();
        IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)context, IStack.IFrameDMContext.class);
        final IRegisters2 service = this.resolveService(IRegisters2.class);
        if (frameCtx != null && service != null) {
            service.getRegisters((IDMContext)frameCtx, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)executor, rm){

                protected void handleSuccess() {
                    final IRegisters.IRegisterDMContext[] registers = (IRegisters.IRegisterDMContext[])this.getData();
                    if (registers != null && registers.length != 0) {
                        GdbMemoryAddressInfoRegistersRetrieval.this.getRegistersData(service, registers, new DataRequestMonitor<IRegisters.IRegisterDMData[]>((Executor)GdbMemoryAddressInfoRegistersRetrieval.this.fSession.getExecutor(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                final IRegisters.IRegisterDMData[] regBaseData = (IRegisters.IRegisterDMData[])this.getData();
                                GdbMemoryAddressInfoRegistersRetrieval.this.getRegisterValues(service, registers, new DataRequestMonitor<IFormattedValues.FormattedValueDMData[]>((Executor)(this).GdbMemoryAddressInfoRegistersRetrieval.this.fSession.getExecutor(), (RequestMonitor)rm){

                                    protected void handleSuccess() {
                                        IFormattedValues.FormattedValueDMData[] regFormattedData = (IFormattedValues.FormattedValueDMData[])this.getData();
                                        String[] regNames = GdbMemoryAddressInfoRegistersRetrieval.this.extractRegNames(regBaseData);
                                        String[] regValues = GdbMemoryAddressInfoRegistersRetrieval.this.extractValues(regFormattedData);
                                        IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] regDataContainers = GdbMemoryAddressInfoRegistersRetrieval.this.createRegisterDataContainers(registers, regNames, regValues);
                                        regDataContainers = GdbMemoryAddressInfoRegistersRetrieval.this.normalizeRegisterData(regDataContainers, memBlock);
                                        rm.setData((Object)regDataContainers);
                                        rm.done();
                                    }
                                });
                            }
                        });
                    } else {
                        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Successful request of register contexts but no registers received"));
                    }
                }
            });
        } else {
            rm.done((IStatus)new Status(1, "org.eclipse.cdt.dsf.gdb", "Unable to resolve registers for the currently selected context"));
        }
    }

    protected IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] normalizeRegisterData(IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] regDataContainers, IMemoryBlock memBlock) {
        ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem> items = new ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>();
        IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] iMemoryBlockAddressInfoItemArray = regDataContainers;
        int n = regDataContainers.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem item = iMemoryBlockAddressInfoItemArray[n2];
            if (item.getAddress().intValue() != 0) {
                items.add(item);
            }
            ++n2;
        }
        return items.toArray(new IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[items.size()]);
    }

    @Override
    public String getInfoType() {
        return REGISTERS_INFO_TYPE;
    }

    private IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] createRegisterDataContainers(IRegisters.IRegisterDMContext[] regContext, String[] names, String[] values) {
        assert (regContext.length > 0 && regContext.length == names.length && regContext.length == values.length);
        IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] regContainers = new IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[regContext.length];
        int i = 0;
        while (i < regContext.length) {
            regContainers[i] = new MemoryBlockAddressRegisterItem(names[i], values[i]);
            ++i;
        }
        return regContainers;
    }

    private String[] extractRegNames(IRegisters.IRegisterDMData[] regData) {
        String[] names = new String[regData.length];
        int i = 0;
        while (i < regData.length) {
            names[i] = regData[i].getName();
            ++i;
        }
        return names;
    }

    private String[] extractValues(IFormattedValues.FormattedValueDMData[] regValues) {
        String[] values = new String[regValues.length];
        int i = 0;
        while (i < regValues.length) {
            values[i] = regValues[i].getEditableValue();
            ++i;
        }
        return values;
    }

    private <V> V resolveService(Class<V> type) {
        Object service = null;
        if (this.fSession != null) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getDefault().getBundle().getBundleContext(), this.fSession.getId());
            service = tracker.getService(type);
            tracker.dispose();
        }
        return (V)service;
    }

    private void getRegistersData(IRegisters2 service, IRegisters.IRegisterDMContext[] regDMCs, DataRequestMonitor<IRegisters.IRegisterDMData[]> rm) {
        final IRegisters.IRegisterDMData[] datas = new IRegisters.IRegisterDMData[regDMCs.length];
        rm.setData((Object)datas);
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.fSession.getExecutor(), rm);
        int i = 0;
        while (i < regDMCs.length) {
            final int index = i++;
            service.getRegisterData(regDMCs[index], (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)this.fSession.getExecutor(), (RequestMonitor)countingRm){

                protected void handleCompleted() {
                    datas[index] = (IRegisters.IRegisterDMData)this.getData();
                    if (!this.isSuccess()) {
                        countingRm.setStatus(this.getStatus());
                    }
                    countingRm.done();
                }
            });
        }
        countingRm.setDoneCount(regDMCs.length);
    }

    private IFormattedValues.FormattedValueDMContext[] getFormatContexts(IRegisters2 service, IRegisters.IRegisterDMContext[] regDMCs) {
        IFormattedValues.FormattedValueDMContext[] datas = new IFormattedValues.FormattedValueDMContext[regDMCs.length];
        int i = 0;
        while (i < regDMCs.length) {
            datas[i] = service.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)regDMCs[i], "HEX.Format");
            ++i;
        }
        return datas;
    }

    private void getRegisterValues(IRegisters2 service, IRegisters.IRegisterDMContext[] regDMCs, DataRequestMonitor<IFormattedValues.FormattedValueDMData[]> rm) {
        IFormattedValues.FormattedValueDMContext[] fmtContexts = this.getFormatContexts(service, regDMCs);
        final IFormattedValues.FormattedValueDMData[] datas = new IFormattedValues.FormattedValueDMData[regDMCs.length];
        rm.setData((Object)datas);
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.fSession.getExecutor(), rm);
        int i = 0;
        while (i < regDMCs.length) {
            final int index = i++;
            service.getFormattedExpressionValue(fmtContexts[index], (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.fSession.getExecutor(), (RequestMonitor)countingRm){

                protected void handleCompleted() {
                    datas[index] = (IFormattedValues.FormattedValueDMData)this.getData();
                    if (!this.isSuccess()) {
                        countingRm.setStatus(this.getStatus());
                    }
                    countingRm.done();
                }
            });
        }
        countingRm.setDoneCount(regDMCs.length);
    }

    private class MemoryBlockAddressRegisterItem
    extends MemoryBlockAddressInfoItem {
        public MemoryBlockAddressRegisterItem(String name, String value) {
            super(name, value);
        }

        public String getInfoType() {
            return GdbMemoryAddressInfoRegistersRetrieval.REGISTERS_INFO_TYPE;
        }
    }
}

