/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.sourcelookup.IMappingSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbSourceLookupParticipant;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;

public class GdbSourceLookupDirector
extends DsfSourceLookupDirector {
    private final DsfSession fSession;

    public GdbSourceLookupDirector(DsfSession session) {
        super(session);
        this.fSession = session;
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new GdbSourceLookupParticipant(this.fSession)});
    }

    public Map<String, String> getSubstitutionsPaths() {
        Map<String, String> entries = new HashMap<String, String>();
        try {
            this.collectSubstitutionsPaths(this.getSourceContainers(), entries);
        }
        catch (NullPointerException npe) {
            GdbPlugin.log((IStatus)new Status(4, GdbPlugin.getUniqueIdentifier(), 4, "NullPointerException while trying to calculated source lookup path. This can be ignored if it occurs while terminating a debug session. See Bug 500988.", (Throwable)npe));
            entries = Collections.emptyMap();
        }
        return entries;
    }

    protected void collectSubstitutionsPaths(ISourceContainer[] containers, Map<String, String> entries) {
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            if (container instanceof MapEntrySourceContainer) {
                MapEntrySourceContainer sourceSubContainer = (MapEntrySourceContainer)container;
                String from = sourceSubContainer.getBackendPathStr();
                IPath to = sourceSubContainer.getLocalPath();
                if (from != null && to != null) {
                    entries.put(from, to.toOSString());
                }
            } else if (container.isComposite()) {
                ISourceContainer[] childContainers;
                try {
                    childContainers = container.getSourceContainers();
                }
                catch (CoreException e) {
                    childContainers = new ISourceContainer[]{};
                }
                if (container instanceof MappingSourceContainer) {
                    MappingSourceContainer mappingSourceContainer = (MappingSourceContainer)container;
                    if (mappingSourceContainer.isMappingWithBackendEnabled()) {
                        this.collectSubstitutionsPaths(childContainers, entries);
                    }
                } else if (container instanceof DefaultSourceContainer) {
                    this.collectSubstitutionsPaths(childContainers, entries);
                }
            }
            ++n2;
        }
    }

    public IPath getCompilationPath(String sourceName) {
        return this.getCompilationPath(this.getSourceContainers(), sourceName);
    }

    protected IPath getCompilationPath(ISourceContainer[] containers, String sourceName) {
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            if (container instanceof IMappingSourceContainer) {
                IPath mappedPath = ((IMappingSourceContainer)container).getCompilationPath(sourceName);
                if (mappedPath != null) {
                    if (container instanceof MappingSourceContainer && ((MappingSourceContainer)container).isMappingWithBackendEnabled()) {
                        return new Path(sourceName);
                    }
                    return mappedPath;
                }
            } else if (container.isComposite()) {
                IPath path;
                ISourceContainer[] childContainers = null;
                try {
                    childContainers = container.getSourceContainers();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (childContainers != null && (path = this.getCompilationPath(childContainers, sourceName)) != null) {
                    return path;
                }
            }
            ++n2;
        }
        return null;
    }
}

