/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;

public class MIGDBVersionInfo
extends MIInfo {
    private String fVersion;
    private String fFullOutput;

    public MIGDBVersionInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] records = out.getMIOOBRecords();
            StringBuilder builder = new StringBuilder();
            MIOOBRecord[] mIOOBRecordArray = records;
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord rec = mIOOBRecordArray[n2];
                if (rec instanceof MIConsoleStreamOutput) {
                    MIStreamRecord o = (MIStreamRecord)rec;
                    builder.append(o.getString());
                }
                ++n2;
            }
            this.fFullOutput = builder.toString();
            this.fVersion = this.parseVersion(this.fFullOutput);
        }
    }

    protected String parseVersion(String output) {
        return LaunchUtils.getGDBVersionFromText(output);
    }

    public String getFullOutput() {
        return this.fFullOutput;
    }

    public String getVersion() {
        return this.fVersion;
    }
}

