/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.webapp.data.WebappPreferences;

public class LiveHelpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        if (BaseHelpSystem.getMode() == 1) {
            throw new ServletException();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String token;
        if (BaseHelpSystem.getMode() == 1) {
            return;
        }
        if (!new WebappPreferences().isActiveHelp()) {
            return;
        }
        req.setCharacterEncoding("UTF-8");
        String sessionid = req.getSession().getId();
        Cookie[] cookies = req.getCookies();
        boolean jsessOK = false;
        boolean xsessOK = false;
        boolean lsessOK = false;
        int port = req.getLocalPort();
        String xsessname = "XSESSION-" + port;
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals("JSESSIONID") && sessionid.length() >= 30 && cookie.getValue().startsWith(sessionid)) {
                    jsessOK = true;
                }
                if (cookie.getName().equals(xsessname) && cookie.getValue().equals(req.getSession().getAttribute("XSESSION"))) {
                    xsessOK = true;
                }
                ++n2;
            }
        }
        if ((token = req.getParameter("token")) != null && token.equals(req.getSession().getAttribute("LSESSION"))) {
            lsessOK = true;
        }
        if (!jsessOK) {
            resp.sendError(403, "JSESSIONID");
            return;
        }
        if (!lsessOK) {
            resp.sendError(403, "token");
            return;
        }
        if (!xsessOK) {
            resp.sendError(403, xsessname);
            return;
        }
        String pluginID = req.getParameter("pluginID");
        if (pluginID == null) {
            return;
        }
        String className = req.getParameter("class");
        if (className == null) {
            return;
        }
        String arg = req.getParameter("arg");
        BaseHelpSystem.runLiveHelp((String)pluginID, (String)className, (String)arg);
        resp.setStatus(202);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

