/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.core.util.ContributorBlackList;
import org.eclipse.mylyn.internal.tasks.core.util.RepositoryConnectorExtensionReader;
import org.eclipse.mylyn.internal.tasks.core.util.RepositoryTemplateExtensionReader;
import org.eclipse.mylyn.tasks.core.spi.RepositoryConnectorDescriptor;

public class RepositoryConnectorLoader {
    private static final String EXTENSION_REPOSITORIES = "org.eclipse.mylyn.tasks.ui.repositories";
    private final ContributorBlackList blackList = new ContributorBlackList();
    private final Set<RepositoryConnectorDescriptor> descriptors = new HashSet<RepositoryConnectorDescriptor>();

    public ContributorBlackList getBlackList() {
        return this.blackList;
    }

    public void registerConnectors(TaskRepositoryManager repositoryManager, TaskListExternalizer taskListExternalizer) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        RepositoryConnectorExtensionReader reader = new RepositoryConnectorExtensionReader(taskListExternalizer, repositoryManager);
        reader.loadConnectorsFromRepositoriesExtension();
        reader.loadConnectors(registry.getExtensionPoint(EXTENSION_REPOSITORIES));
        reader.loadConnectorsFromContributors();
        reader.registerConnectors();
        this.descriptors.addAll(reader.getDescriptors());
        this.blackList.merge(reader.getBlackList());
    }

    public void registerTemplates(TaskRepositoryManager repositoryManager, RepositoryTemplateManager repositoryTemplateManager) {
        RepositoryTemplateExtensionReader templateExtensionReader = new RepositoryTemplateExtensionReader(repositoryManager, repositoryTemplateManager);
        templateExtensionReader.loadExtensions(this.blackList);
    }
}

