/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.Messages;
import org.eclipse.mylyn.tasks.core.IAttributeContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;

public interface ITask
extends IRepositoryElement,
IAttributeContainer {
    public Date getCompletionDate();

    public String getConnectorKind();

    public Date getCreationDate();

    public Date getDueDate();

    @Override
    public String getHandleIdentifier();

    public Date getModificationDate();

    public String getOwner();

    public String getOwnerId();

    public String getPriority();

    public String getRepositoryUrl();

    @Override
    public String getSummary();

    public SynchronizationState getSynchronizationState();

    public String getTaskId();

    public String getTaskKey();

    public String getTaskKind();

    public boolean isActive();

    public boolean isCompleted();

    public void setCompletionDate(Date var1);

    public void setCreationDate(Date var1);

    public void setDueDate(Date var1);

    public void setModificationDate(Date var1);

    public void setOwner(String var1);

    public void setOwnerId(String var1);

    public void setPriority(String var1);

    public void setSummary(String var1);

    public void setTaskKind(String var1);

    public void setUrl(String var1);

    public void setTaskKey(String var1);

    public static interface IPriorityValue {
        public int getPriorityValue();
    }

    public static enum PriorityLevel {
        P1,
        P2,
        P3,
        P4,
        P5;

        private static final int LEVEL_COUNT;

        static {
            LEVEL_COUNT = PriorityLevel.values().length;
        }

        public String toString() {
            return switch (this) {
                case P1 -> "P1";
                case P2 -> "P2";
                case P3 -> "P3";
                case P4 -> "P4";
                case P5 -> "P5";
                default -> "P3";
            };
        }

        public String getDescription() {
            return switch (this) {
                case P1 -> Messages.PriorityLevel_Very_High;
                case P2 -> Messages.PriorityLevel_High;
                case P3 -> Messages.PriorityLevel_Normal;
                case P4 -> Messages.PriorityLevel_Low;
                case P5 -> Messages.PriorityLevel_Very_Low;
                default -> "";
            };
        }

        public static PriorityLevel fromLevel(int level) {
            if (level <= 1) {
                return P1;
            }
            if (level == 2) {
                return P2;
            }
            if (level == 3) {
                return P3;
            }
            if (level == 4) {
                return P4;
            }
            if (level >= 5) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel fromString(String string) {
            if ("P1".equals(string)) {
                return P1;
            }
            if ("P2".equals(string)) {
                return P2;
            }
            if ("P3".equals(string)) {
                return P3;
            }
            if ("P4".equals(string)) {
                return P4;
            }
            if ("P5".equals(string)) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel fromDescription(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals(Messages.PriorityLevel_Very_High)) {
                return P1;
            }
            if (string.equals(Messages.PriorityLevel_High)) {
                return P2;
            }
            if (string.equals(Messages.PriorityLevel_Normal)) {
                return P3;
            }
            if (string.equals(Messages.PriorityLevel_Low)) {
                return P4;
            }
            if (string.equals(Messages.PriorityLevel_Very_Low)) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static boolean isValidPriority(String string) {
            try {
                PriorityLevel.valueOf(string);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public static PriorityLevel fromValue(IPriorityValue[] priorities, IPriorityValue value) {
            Assert.isNotNull((Object)priorities);
            if (value != null) {
                int minValue = priorities[0].getPriorityValue();
                int range = priorities[priorities.length - 1].getPriorityValue() - minValue;
                IPriorityValue[] iPriorityValueArray = priorities;
                int n = priorities.length;
                int n2 = 0;
                while (n2 < n) {
                    IPriorityValue priority = iPriorityValueArray[n2];
                    if (value.equals(priority)) {
                        float relativeValue = (float)(priority.getPriorityValue() - minValue) / (float)range;
                        int level = (int)(relativeValue * (float)LEVEL_COUNT) + 1;
                        return PriorityLevel.fromLevel(level);
                    }
                    ++n2;
                }
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel getDefault() {
            return P3;
        }
    }

    public static enum SynchronizationState {
        CONFLICT,
        INCOMING,
        INCOMING_NEW,
        OUTGOING,
        OUTGOING_NEW,
        SYNCHRONIZED;


        public boolean isIncoming() {
            return switch (this) {
                case CONFLICT, INCOMING, INCOMING_NEW -> true;
                default -> false;
            };
        }

        public boolean isOutgoing() {
            return switch (this) {
                case CONFLICT, OUTGOING, OUTGOING_NEW -> true;
                default -> false;
            };
        }

        public boolean isSynchronized() {
            return switch (this) {
                case SYNCHRONIZED -> true;
                default -> false;
            };
        }
    }
}

