/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedIsToolChainSupported;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.HoldsOptions;
import org.eclipse.cdt.managedbuilder.internal.core.IMatchKeyProvider;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.MatchKey;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.SupportedProperties;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class ToolChain
extends HoldsOptions
implements IToolChain,
IMatchKeyProvider<ToolChain>,
IRealBuildObjectAssociation {
    private static final String EMPTY_STRING = "";
    private static final String REBUILD_STATE = "rebuildState";
    private static final boolean resolvedDefault = true;
    private String superClassId;
    private IConfiguration config;
    private List<Tool> toolList;
    private Map<String, Tool> toolMap;
    private TargetPlatform targetPlatform;
    private Builder builder;
    private String unusedChildren;
    private String errorParserIds;
    private List<String> osList;
    private List<String> archList;
    private String targetToolIds;
    private String secondaryOutputIds;
    private Boolean isAbstract;
    private String defaultLanguageSettingsProviderIds;
    private String scannerConfigDiscoveryProfileId;
    private String versionsSupported;
    private String convertToId;
    private IConfigurationElement managedIsToolChainSupportedElement = null;
    private IManagedIsToolChainSupported managedIsToolChainSupported = null;
    private IConfigurationElement environmentVariableSupplierElement = null;
    private IConfigurationEnvironmentVariableSupplier environmentVariableSupplier = null;
    private IConfigurationElement buildMacroSupplierElement = null;
    private IConfigurationBuildMacroSupplier buildMacroSupplier = null;
    private IConfigurationElement pathconverterElement = null;
    private IOptionPathConverter optionPathConverter = null;
    private Boolean supportsManagedBuild;
    private boolean isTest;
    private SupportedProperties supportedProperties;
    private String nonInternalBuilderId;
    private boolean isExtensionToolChain = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private StorableCdtVariables userDefinedMacros;
    private IConfigurationElement previousMbsVersionConversionElement = null;
    private IConfigurationElement currentMbsVersionConversionElement = null;
    private boolean rebuildState;
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private List<ToolChain> identicalList;
    private Set<String> unusedChildrenSet;
    private IFolderInfo parentFolderInfo;
    private CfgDiscoveredPathManager.PathInfoCache discoveredInfo;
    private Boolean isRcTypeBasedDiscovery;

    public ToolChain(IFolderInfo parentFldInfo, IManagedConfigElement element, String managedBuildRevision) {
        super(false);
        IManagedConfigElement[] builders;
        this.resolved = false;
        if (parentFldInfo != null) {
            this.config = parentFldInfo.getParent();
            this.parentFolderInfo = parentFldInfo;
        }
        this.isExtensionToolChain = true;
        this.setManagedBuildRevision(managedBuildRevision);
        IManagedConfigElement[] enablements = element.getChildren("enablement");
        if (enablements.length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionToolChain(this);
        IManagedConfigElement[] targetPlatforms = element.getChildren("targetPlatform");
        if (targetPlatforms.length >= 1) {
            int cfr_ignored_0 = targetPlatforms.length;
        }
        if (targetPlatforms.length > 0) {
            this.targetPlatform = new TargetPlatform((IToolChain)this, targetPlatforms[0], managedBuildRevision);
        }
        if ((builders = element.getChildren("builder")).length >= 1) {
            int cfr_ignored_1 = builders.length;
        }
        if (builders.length > 0) {
            this.builder = new Builder((IToolChain)this, builders[0], managedBuildRevision);
        }
        IManagedConfigElement[] toolChainElements = element.getChildren();
        int l = 0;
        while (l < toolChainElements.length) {
            IManagedConfigElement toolChainElement = toolChainElements[l];
            if (!this.loadChild(toolChainElement)) {
                if (toolChainElement.getName().equals("tool")) {
                    Tool toolChild = new Tool((IBuildObject)this, toolChainElement, managedBuildRevision);
                    this.addTool(toolChild);
                } else if (toolChainElement.getName().equals("supportedProperties")) {
                    this.loadProperties(toolChainElement);
                }
            }
            ++l;
        }
    }

    public ToolChain(IFolderInfo parentFldInfo, IToolChain superClass, String Id, String name, boolean isExtensionElement) {
        super(true);
        this.config = parentFldInfo.getParent();
        this.parentFolderInfo = parentFldInfo;
        this.setSuperClassInternal(superClass);
        this.setManagedBuildRevision(this.config.getManagedBuildRevision());
        if (this.getSuperClass() != null) {
            this.superClassId = this.getSuperClass().getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionToolChain = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionToolChain(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public ToolChain(IFolderInfo parentFldInfo, ICStorageElement element, String managedBuildRevision) {
        super(true);
        this.config = parentFldInfo.getParent();
        this.parentFolderInfo = parentFldInfo;
        this.isExtensionToolChain = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        ICStorageElement[] configElements = element.getChildren();
        int i = 0;
        while (i < configElements.length) {
            ICStorageElement configElement = configElements[i];
            if (!this.loadChild(configElement)) {
                if (configElement.getName().equals("tool")) {
                    Tool tool = new Tool((IBuildObject)this, configElement, managedBuildRevision);
                    this.addTool(tool);
                } else if (configElement.getName().equals("targetPlatform")) {
                    this.targetPlatform = new TargetPlatform((IToolChain)this, configElement, managedBuildRevision);
                } else if (configElement.getName().equals("builder")) {
                    this.builder = new Builder((IToolChain)this, configElement, managedBuildRevision);
                } else if (configElement.getName().equals("macros")) {
                    this.userDefinedMacros = new StorableCdtVariables(configElement, false);
                }
            }
            ++i;
        }
        String rebuild = PropertyManager.getInstance().getProperty(this, REBUILD_STATE);
        if (rebuild == null || Boolean.valueOf(rebuild).booleanValue()) {
            this.rebuildState = true;
        }
    }

    public ToolChain(IFolderInfo parentFldInfo, String Id, String name, Map<IPath, Map<String, String>> superIdMap, ToolChain toolChain) {
        super(true);
        ITargetPlatform tpBase;
        this.config = parentFldInfo.getParent();
        this.parentFolderInfo = parentFldInfo;
        this.setSuperClassInternal(toolChain.getSuperClass());
        if (this.getSuperClass() != null && toolChain.superClassId != null) {
            this.superClassId = toolChain.superClassId;
        }
        this.setId(Id);
        this.setName(name);
        this.setManagedBuildRevision(toolChain.getManagedBuildRevision());
        this.setVersion(this.getVersionFromId());
        this.isExtensionToolChain = false;
        if (toolChain.versionsSupported != null) {
            this.versionsSupported = toolChain.versionsSupported;
        }
        if (toolChain.convertToId != null) {
            this.convertToId = toolChain.convertToId;
        }
        if (toolChain.unusedChildren != null) {
            this.unusedChildren = toolChain.unusedChildren;
        }
        if (toolChain.errorParserIds != null) {
            this.errorParserIds = toolChain.errorParserIds;
        }
        if (toolChain.osList != null) {
            this.osList = new ArrayList<String>(toolChain.osList);
        }
        if (toolChain.archList != null) {
            this.archList = new ArrayList<String>(toolChain.archList);
        }
        if (toolChain.targetToolIds != null) {
            this.targetToolIds = toolChain.targetToolIds;
        }
        if (toolChain.secondaryOutputIds != null) {
            this.secondaryOutputIds = toolChain.secondaryOutputIds;
        }
        if (toolChain.isAbstract != null) {
            this.isAbstract = toolChain.isAbstract;
        }
        if (toolChain.scannerConfigDiscoveryProfileId != null) {
            this.scannerConfigDiscoveryProfileId = toolChain.scannerConfigDiscoveryProfileId;
        }
        this.isRcTypeBasedDiscovery = toolChain.isRcTypeBasedDiscovery;
        this.supportsManagedBuild = toolChain.supportsManagedBuild;
        this.managedIsToolChainSupportedElement = toolChain.managedIsToolChainSupportedElement;
        this.managedIsToolChainSupported = toolChain.managedIsToolChainSupported;
        this.environmentVariableSupplierElement = toolChain.environmentVariableSupplierElement;
        this.environmentVariableSupplier = toolChain.environmentVariableSupplier;
        this.buildMacroSupplierElement = toolChain.buildMacroSupplierElement;
        this.buildMacroSupplier = toolChain.buildMacroSupplier;
        this.pathconverterElement = toolChain.pathconverterElement;
        this.optionPathConverter = toolChain.optionPathConverter;
        this.nonInternalBuilderId = toolChain.nonInternalBuilderId;
        this.discoveredInfo = toolChain.discoveredInfo;
        this.userDefinedMacros = toolChain.userDefinedMacros;
        boolean copyIds = toolChain.getId().equals(this.id);
        super.copyChildren(toolChain);
        if (toolChain.builder != null) {
            String subName;
            String subId;
            if (toolChain.builder.getSuperClass() != null) {
                subId = copyIds ? toolChain.builder.getId() : ManagedBuildManager.calculateChildId(toolChain.builder.getSuperClass().getId(), null);
                subName = toolChain.builder.getSuperClass().getName();
            } else {
                subId = copyIds ? toolChain.builder.getId() : ManagedBuildManager.calculateChildId(toolChain.builder.getId(), null);
                subName = toolChain.builder.getName();
            }
            this.builder = new Builder(this, subId, subName, toolChain.builder);
        }
        if ((tpBase = toolChain.getTargetPlatform()) != null) {
            ITargetPlatform extTp = tpBase;
            while (extTp != null && !extTp.isExtensionElement()) {
                extTp = extTp.getSuperClass();
            }
            String subId = copyIds ? tpBase.getId() : (extTp != null ? ManagedBuildManager.calculateChildId(extTp.getId(), null) : ManagedBuildManager.calculateChildId(this.getId(), null));
            String subName = tpBase.getName();
            this.targetPlatform = new TargetPlatform(this, subId, subName, (TargetPlatform)tpBase);
        }
        IConfiguration cfg = this.parentFolderInfo.getParent();
        if (toolChain.toolList != null) {
            for (Tool toolChild : toolChain.getToolList()) {
                String subId = null;
                ITool extTool = ManagedBuildManager.getExtensionTool(toolChild);
                Map<String, String> curIdMap = superIdMap.get(parentFldInfo.getPath());
                if (curIdMap != null && extTool != null) {
                    subId = curIdMap.get(extTool.getId());
                }
                String subName = toolChild.getName();
                if (subId == null) {
                    subId = extTool != null ? (copyIds ? toolChild.getId() : ManagedBuildManager.calculateChildId(extTool.getId(), null)) : (copyIds ? toolChild.getId() : ManagedBuildManager.calculateChildId(toolChild.getId(), null));
                }
                ITool toolSuperClass = null;
                String superId = null;
                ITool otherSuperTool = toolChild.getSuperClass();
                if (otherSuperTool != null) {
                    if (otherSuperTool.isExtensionElement()) {
                        toolSuperClass = otherSuperTool;
                    } else {
                        IResourceInfo otherRcInfo = otherSuperTool.getParentResourceInfo();
                        IResourceInfo thisRcInfo = cfg.getResourceInfo(otherRcInfo.getPath(), true);
                        ITool otherExtTool = ManagedBuildManager.getExtensionTool(otherSuperTool);
                        if (otherExtTool != null) {
                            if (thisRcInfo != null) {
                                ITool[] tools = thisRcInfo.getTools();
                                int i = 0;
                                while (i < tools.length) {
                                    ITool thisExtTool = ManagedBuildManager.getExtensionTool(tools[i]);
                                    if (otherExtTool.equals(thisExtTool)) {
                                        toolSuperClass = tools[i];
                                        superId = toolSuperClass.getId();
                                        break;
                                    }
                                    ++i;
                                }
                            } else {
                                superId = copyIds ? otherSuperTool.getId() : ManagedBuildManager.calculateChildId(otherExtTool.getId(), null);
                                Map<String, String> idMap = superIdMap.get(otherRcInfo.getPath());
                                if (idMap == null) {
                                    idMap = new HashMap<String, String>();
                                    superIdMap.put(otherRcInfo.getPath(), idMap);
                                }
                                idMap.put(otherExtTool.getId(), superId);
                            }
                        }
                    }
                }
                Tool newTool = null;
                if (toolSuperClass != null) {
                    newTool = new Tool((IBuildObject)this, toolSuperClass, subId, subName, toolChild);
                } else if (superId != null) {
                    newTool = new Tool((IBuildObject)this, superId, subId, subName, toolChild);
                }
                if (newTool == null) continue;
                this.addTool(newTool);
            }
        }
        if (copyIds) {
            this.rebuildState = toolChain.rebuildState;
            this.isDirty = toolChain.isDirty;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String pathconverterTypeName;
        String buildMacroSupplier;
        String environmentVariableSupplier;
        String managedIsToolChainSupported;
        String arch;
        String os;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        this.setVersion(this.getVersionFromId());
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = Boolean.parseBoolean(isAbs);
        }
        this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        this.secondaryOutputIds = SafeStringInterner.safeIntern((String)element.getAttribute("secondaryOutputs"));
        this.targetToolIds = SafeStringInterner.safeIntern((String)element.getAttribute("targetTool"));
        this.defaultLanguageSettingsProviderIds = element.getAttribute("languageSettingsProviders");
        this.scannerConfigDiscoveryProfileId = SafeStringInterner.safeIntern((String)element.getAttribute("scannerConfigDiscoveryProfileId"));
        String tmp = element.getAttribute("resourceTypeBasedDiscovery");
        if (tmp != null) {
            this.isRcTypeBasedDiscovery = Boolean.valueOf(tmp);
        }
        this.versionsSupported = SafeStringInterner.safeIntern((String)element.getAttribute("versionsSupported"));
        this.convertToId = SafeStringInterner.safeIntern((String)element.getAttribute("convertToId"));
        tmp = element.getAttribute("supportsManagedBuild");
        if (tmp != null) {
            this.supportsManagedBuild = Boolean.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("isSystem")) != null) {
            this.isTest = Boolean.valueOf(tmp);
        }
        if ((os = element.getAttribute("osList")) != null) {
            this.osList = new ArrayList<String>();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(SafeStringInterner.safeIntern((String)osTokens[i].trim()));
                ++i;
            }
        }
        if ((arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList<String>();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.archList.add(SafeStringInterner.safeIntern((String)archTokens[j].trim()));
                ++j;
            }
        }
        if ((managedIsToolChainSupported = element.getAttribute("isToolChainSupported")) != null && element instanceof DefaultManagedConfigElement) {
            this.managedIsToolChainSupportedElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((environmentVariableSupplier = element.getAttribute("configurationEnvironmentSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.environmentVariableSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((buildMacroSupplier = element.getAttribute("configurationMacroSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.buildMacroSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((pathconverterTypeName = element.getAttribute("optionPathConverter")) != null && element instanceof DefaultManagedConfigElement) {
            this.pathconverterElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.nonInternalBuilderId = SafeStringInterner.safeIntern((String)element.getAttribute("nonInternalBuilderId"));
    }

    protected void loadFromProject(ICStorageElement element) {
        String arch;
        String os;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        this.setVersion(this.getVersionFromId());
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.setSuperClassInternal(ManagedBuildManager.getExtensionToolChain(this.superClassId));
            this.checkForMigrationSupport();
        }
        if (element.getAttribute("unusedChildren") != null) {
            this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        }
        if (element.getAttribute("isAbstract") != null && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = Boolean.parseBoolean(isAbs);
        }
        if (element.getAttribute("errorParsers") != null) {
            this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        }
        if (element.getAttribute("secondaryOutputs") != null) {
            this.secondaryOutputIds = SafeStringInterner.safeIntern((String)element.getAttribute("secondaryOutputs"));
        }
        if (element.getAttribute("targetTool") != null) {
            this.targetToolIds = SafeStringInterner.safeIntern((String)element.getAttribute("targetTool"));
        }
        if (element.getAttribute("scannerConfigDiscoveryProfileId") != null) {
            this.scannerConfigDiscoveryProfileId = SafeStringInterner.safeIntern((String)element.getAttribute("scannerConfigDiscoveryProfileId"));
        }
        if (element.getAttribute("versionsSupported") != null) {
            this.versionsSupported = SafeStringInterner.safeIntern((String)element.getAttribute("versionsSupported"));
        }
        if (element.getAttribute("convertToId") != null) {
            this.convertToId = SafeStringInterner.safeIntern((String)element.getAttribute("convertToId"));
        }
        if (element.getAttribute("osList") != null && (os = element.getAttribute("osList")) != null) {
            this.osList = new ArrayList<String>();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(SafeStringInterner.safeIntern((String)osTokens[i].trim()));
                ++i;
            }
        }
        if (element.getAttribute("archList") != null && (arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList<String>();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.archList.add(SafeStringInterner.safeIntern((String)archTokens[j].trim()));
                ++j;
            }
        }
        this.scannerConfigDiscoveryProfileId = element.getAttribute("scannerConfigDiscoveryProfileId");
        String tmp = element.getAttribute("resourceTypeBasedDiscovery");
        if (tmp != null) {
            this.isRcTypeBasedDiscovery = Boolean.valueOf(tmp);
        }
        this.nonInternalBuilderId = SafeStringInterner.safeIntern((String)element.getAttribute("nonInternalBuilderId"));
    }

    @Override
    public void serialize(ICStorageElement element) {
        try {
            String current;
            Object listValue;
            if (this.getSuperClass() != null) {
                element.setAttribute("superClass", this.getSuperClass().getId());
            }
            element.setAttribute("id", this.id);
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.unusedChildren != null) {
                element.setAttribute("unusedChildren", this.unusedChildren);
            }
            if (this.isAbstract != null) {
                element.setAttribute("isAbstract", this.isAbstract.toString());
            }
            if (this.errorParserIds != null) {
                element.setAttribute("errorParsers", this.errorParserIds);
            }
            if (this.secondaryOutputIds != null) {
                element.setAttribute("secondaryOutputs", this.secondaryOutputIds);
            }
            if (this.targetToolIds != null) {
                element.setAttribute("targetTool", this.targetToolIds);
            }
            if (this.scannerConfigDiscoveryProfileId != null) {
                element.setAttribute("scannerConfigDiscoveryProfileId", this.scannerConfigDiscoveryProfileId);
            }
            if (this.versionsSupported != null) {
                element.setAttribute("versionsSupported", this.versionsSupported);
            }
            if (this.convertToId != null) {
                element.setAttribute("convertToId", this.convertToId);
            }
            if (this.osList != null) {
                ListIterator<String> osIter = this.osList.listIterator();
                listValue = EMPTY_STRING;
                while (osIter.hasNext()) {
                    current = (String)osIter.next();
                    listValue = (String)listValue + current;
                    if (!osIter.hasNext()) continue;
                    listValue = (String)listValue + ",";
                }
                element.setAttribute("osList", (String)listValue);
            }
            if (this.archList != null) {
                ListIterator<String> archIter = this.archList.listIterator();
                listValue = EMPTY_STRING;
                while (archIter.hasNext()) {
                    current = (String)archIter.next();
                    listValue = (String)listValue + current;
                    if (!archIter.hasNext()) continue;
                    listValue = (String)listValue + ",";
                }
                element.setAttribute("archList", (String)listValue);
            }
            super.serialize(element);
            if (this.targetPlatform != null) {
                ICStorageElement targetPlatformElement = element.createChild("targetPlatform");
                this.targetPlatform.serialize(targetPlatformElement);
            }
            if (this.builder != null) {
                ICStorageElement builderElement = element.createChild("builder");
                this.builder.serialize(builderElement);
            }
            for (Tool tool : this.getToolList()) {
                ICStorageElement toolElement = element.createChild("tool");
                tool.serialize(toolElement);
            }
            if (this.nonInternalBuilderId != null) {
                element.setAttribute("nonInternalBuilderId", this.nonInternalBuilderId);
            }
            if (this.scannerConfigDiscoveryProfileId != null) {
                element.setAttribute("scannerConfigDiscoveryProfileId", this.scannerConfigDiscoveryProfileId);
            }
            if (this.isRcTypeBasedDiscovery != null) {
                element.setAttribute("resourceTypeBasedDiscovery", this.isRcTypeBasedDiscovery.toString());
            }
            this.saveRebuildState();
            this.isDirty = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public IConfiguration getParent() {
        return this.config;
    }

    @Override
    public ITargetPlatform createTargetPlatform(ITargetPlatform superClass, String id, String name, boolean isExtensionElement) {
        this.targetPlatform = new TargetPlatform(this, superClass, id, name, isExtensionElement);
        this.setDirty(true);
        return this.targetPlatform;
    }

    @Override
    public ITargetPlatform getTargetPlatform() {
        if (this.targetPlatform == null && this.getSuperClass() != null) {
            return this.getSuperClass().getTargetPlatform();
        }
        return this.targetPlatform;
    }

    @Override
    public void removeLocalTargetPlatform() {
        if (this.targetPlatform == null) {
            return;
        }
        this.targetPlatform = null;
        this.setDirty(true);
    }

    @Override
    public IBuilder createBuilder(IBuilder superClass, String id, String name, boolean isExtensionElement) {
        this.builder = new Builder(this, superClass, id, name, isExtensionElement);
        this.setDirty(true);
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    @Override
    public IBuilder getBuilder() {
        if (this.builder == null && this.getSuperClass() != null) {
            return this.getSuperClass().getBuilder();
        }
        return this.builder;
    }

    @Override
    public void removeLocalBuilder() {
        if (this.builder == null) {
            return;
        }
        this.builder = null;
        this.setDirty(true);
    }

    @Override
    public ITool createTool(ITool superClass, String id, String name, boolean isExtensionElement) {
        Tool tool = new Tool(this, superClass, id, name, isExtensionElement);
        this.addTool(tool);
        this.setDirty(true);
        return tool;
    }

    @Override
    public ITool[] getTools() {
        ITool[] tools = this.getAllTools(false);
        if (!this.isExtensionToolChain) {
            int i = 0;
            while (i < tools.length) {
                if (tools[i].isExtensionElement()) {
                    String subId = ManagedBuildManager.calculateChildId(tools[i].getId(), null);
                    tools[i] = this.createTool(tools[i], subId, tools[i].getName(), false);
                }
                ++i;
            }
        }
        return tools;
    }

    public Tool[] getAllTools(boolean includeCurrentUnused) {
        Tool[] tools = null;
        if (this.getSuperClass() != null) {
            tools = ((ToolChain)this.getSuperClass()).getAllTools(false);
        }
        if (tools != null) {
            for (Tool tool : this.getToolList()) {
                int j = 0;
                while (j < tools.length) {
                    ITool superTool = tool.getSuperClass();
                    if (superTool != null && (superTool = ManagedBuildManager.getExtensionTool(superTool)) != null && superTool.getId().equals(tools[j].getId())) {
                        tools[j] = tool;
                        break;
                    }
                    ++j;
                }
                if (j != tools.length) continue;
                Tool[] newTools = new Tool[tools.length + 1];
                int k = 0;
                while (k < tools.length) {
                    newTools[k] = tools[k];
                    ++k;
                }
                newTools[j] = tool;
                tools = newTools;
            }
        } else {
            tools = new Tool[this.getToolList().size()];
            int i = 0;
            for (Tool tool : this.getToolList()) {
                tools[i++] = tool;
            }
        }
        if (includeCurrentUnused) {
            return tools;
        }
        return this.filterUsedTools(tools, true);
    }

    private Tool[] filterUsedTools(Tool[] tools, boolean used) {
        Set<String> set = this.getUnusedChilrenSet();
        if (set.size() == 0) {
            return used ? tools : new Tool[]{};
        }
        ArrayList<Tool> list = new ArrayList<Tool>(tools.length);
        Tool[] toolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            Tool t = toolArray[n2];
            if (set.contains(t.getId()) != used) {
                list.add(t);
            }
            ++n2;
        }
        return list.toArray(new Tool[list.size()]);
    }

    public Tool[] getUnusedTools() {
        Tool[] all = this.getAllTools(true);
        return this.filterUsedTools(all, false);
    }

    @Override
    public ITool getTool(String id) {
        Tool tool = this.getToolMap().get(id);
        return tool;
    }

    @Override
    public ITool[] getToolsBySuperClassId(String id) {
        ArrayList<ITool> retTools = new ArrayList<ITool>();
        if (id != null) {
            ITool[] tools;
            ITool[] iToolArray = tools = this.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool targetTool;
                ITool tool = targetTool = iToolArray[n2];
                do {
                    if (!id.equals(tool.getId())) continue;
                    retTools.add(targetTool);
                    break;
                } while ((tool = tool.getSuperClass()) != null);
                ++n2;
            }
        }
        return retTools.toArray(new ITool[retTools.size()]);
    }

    public List<Tool> getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList<Tool>();
        }
        return this.toolList;
    }

    private Map<String, Tool> getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap<String, Tool>();
        }
        return this.toolMap;
    }

    public void addTool(Tool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    void setToolsInternal(ITool[] tools) {
        List<Tool> list = this.getToolList();
        Map<String, Tool> map = this.getToolMap();
        list.clear();
        map.clear();
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool t = iToolArray[n2];
            list.add((Tool)t);
            map.put(t.getId(), (Tool)t);
            ++n2;
        }
    }

    public void removeTool(Tool tool) {
        this.getToolList().remove(tool);
        this.getToolMap().remove(tool.getId());
        ITool extTool = ManagedBuildManager.getExtensionTool(tool);
        if (extTool.getParent() == this.getSuperClass()) {
            this.addUnusedChild(extTool);
        }
    }

    @Override
    public IToolChain getSuperClass() {
        return (IToolChain)this.superClass;
    }

    private void setSuperClassInternal(IToolChain superClass) {
        this.superClass = superClass;
    }

    public void setSuperClass(IToolChain superClass) {
        if (this.superClass != superClass) {
            this.superClass = superClass;
            this.superClassId = this.superClass == null ? null : this.superClass.getId();
            if (!this.isExtensionElement()) {
                this.setDirty(true);
            }
        }
    }

    @Override
    public String getName() {
        return this.name == null && this.getSuperClass() != null ? this.getSuperClass().getName() : this.name;
    }

    @Override
    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    @Override
    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    @Override
    public String getErrorParserIds() {
        Object ids = this.errorParserIds;
        if (ids == null && this.getSuperClass() != null) {
            ids = this.getSuperClass().getErrorParserIds();
        }
        if (ids == null) {
            ids = this.builder.getErrorParserIds();
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String toolIds = tool.getErrorParserIds();
                if (toolIds != null && toolIds.length() > 0) {
                    if (ids != null) {
                        ids = (String)ids + ";";
                        ids = (String)ids + toolIds;
                    } else {
                        ids = toolIds;
                    }
                }
                ++i;
            }
        }
        return ids;
    }

    public String getErrorParserIdsAttribute() {
        String ids = this.errorParserIds;
        if (ids == null && this.getSuperClass() != null) {
            ids = ((ToolChain)this.getSuperClass()).getErrorParserIdsAttribute();
        }
        return ids;
    }

    @Override
    public IOutputType[] getSecondaryOutputs() {
        IOutputType[] types = null;
        String ids = this.secondaryOutputIds;
        if (ids == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getSecondaryOutputs();
            }
            return new IOutputType[0];
        }
        StringTokenizer tok = new StringTokenizer(ids, ";");
        types = new IOutputType[tok.countTokens()];
        ITool[] tools = this.getTools();
        int i = 0;
        block0: while (tok.hasMoreElements()) {
            String id = tok.nextToken();
            int j = 0;
            while (j < tools.length) {
                IOutputType type = tools[j].getOutputTypeById(id);
                if (type != null) {
                    types[i++] = type;
                    continue block0;
                }
                ++j;
            }
        }
        return types;
    }

    @Override
    public String getTargetToolIds() {
        if (this.targetToolIds == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getTargetToolIds();
            }
            return null;
        }
        return this.targetToolIds;
    }

    @Override
    public String[] getTargetToolList() {
        String[] targetTools;
        String IDs = this.getTargetToolIds();
        if (IDs != null) {
            if (IDs.length() == 0) {
                targetTools = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(IDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{EMPTY_STRING};
                targetTools = list.toArray(strArr);
            }
        } else {
            targetTools = new String[]{};
        }
        return targetTools;
    }

    @Override
    public String getErrorParserIds(IConfiguration config) {
        Object ids = this.errorParserIds;
        if (ids == null && this.getSuperClass() != null) {
            ids = this.getSuperClass().getErrorParserIds(config);
        }
        if (ids == null) {
            if (this.builder != null) {
                ids = this.builder.getErrorParserIds();
            }
            ITool[] tools = config.getFilteredTools();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String toolIds = tool.getErrorParserIds();
                if (toolIds != null && toolIds.length() > 0) {
                    if (ids != null) {
                        ids = (String)ids + ";";
                        ids = (String)ids + toolIds;
                    } else {
                        ids = toolIds;
                    }
                }
                ++i;
            }
        }
        return ids;
    }

    @Override
    public String[] getErrorParserList() {
        String[] errorParsers;
        String parserIDs = this.getErrorParserIds();
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{EMPTY_STRING};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public Set<String> contributeErrorParsers(FolderInfo info, Set<String> set, boolean includeChildren) {
        String parserIDs = this.getErrorParserIdsAttribute();
        if (parserIDs != null) {
            if (set == null) {
                set = new HashSet<String>();
            }
            if (parserIDs.length() != 0) {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                while (tok.hasMoreElements()) {
                    set.add(tok.nextToken());
                }
            }
        }
        if (includeChildren) {
            ITool[] tools = info.getFilteredTools();
            set = info.contributeErrorParsers(tools, set);
            if (info.isRoot()) {
                Builder builder = (Builder)this.getBuilder();
                set = builder.contributeErrorParsers(set);
            }
        }
        return set;
    }

    @Override
    public String[] getArchList() {
        if (this.archList == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getArchList();
            }
            return new String[]{"all"};
        }
        return this.archList.toArray(new String[this.archList.size()]);
    }

    @Override
    public String[] getOSList() {
        if (this.osList == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOSList();
            }
            return new String[]{"all"};
        }
        return this.osList.toArray(new String[this.osList.size()]);
    }

    @Override
    public void setIsAbstract(boolean b) {
        this.isAbstract = b;
        this.setDirty(true);
    }

    @Override
    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    @Override
    public void setSecondaryOutputs(String newIds) {
        if (this.secondaryOutputIds == null && newIds == null) {
            return;
        }
        if (this.secondaryOutputIds == null || newIds == null || !newIds.equals(this.secondaryOutputIds)) {
            this.secondaryOutputIds = newIds;
            this.isDirty = true;
        }
    }

    @Override
    public void setTargetToolIds(String newIds) {
        if (this.targetToolIds == null && newIds == null) {
            return;
        }
        if (this.targetToolIds == null || newIds == null || !newIds.equals(this.targetToolIds)) {
            this.targetToolIds = newIds;
            this.isDirty = true;
        }
    }

    @Override
    public void setOSList(String[] OSs) {
        if (this.osList == null) {
            this.osList = new ArrayList<String>();
        } else {
            this.osList.clear();
        }
        int i = 0;
        while (i < OSs.length) {
            this.osList.add(OSs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    @Override
    public void setArchList(String[] archs) {
        if (this.archList == null) {
            this.archList = new ArrayList<String>();
        } else {
            this.archList.clear();
        }
        int i = 0;
        while (i < archs.length) {
            this.archList.add(archs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    @Override
    public String getDefaultLanguageSettingsProviderIds() {
        if (this.defaultLanguageSettingsProviderIds == null && this.superClass instanceof IToolChain) {
            this.defaultLanguageSettingsProviderIds = ((IToolChain)this.superClass).getDefaultLanguageSettingsProviderIds();
        }
        return this.defaultLanguageSettingsProviderIds;
    }

    private boolean useLegacyScannerDiscoveryProfiles() {
        IResource rc;
        IConfiguration cfg;
        boolean useLegacy = true;
        if (this.getDefaultLanguageSettingsProviderIds() != null && (cfg = this.getParent()) != null && cfg.getDefaultLanguageSettingsProviderIds() != null && (rc = cfg.getOwner()) != null) {
            IProject project = rc.getProject();
            useLegacy = !ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled((IProject)project);
        }
        return useLegacy;
    }

    public String getLegacyScannerConfigDiscoveryProfileId() {
        IToolChain superClass;
        String profileId = this.scannerConfigDiscoveryProfileId;
        if (profileId == null && (profileId = ScannerDiscoveryLegacySupport.getDeprecatedLegacyProfiles((String)this.id)) == null && (superClass = this.getSuperClass()) instanceof ToolChain) {
            profileId = ((ToolChain)superClass).getLegacyScannerConfigDiscoveryProfileId();
        }
        return profileId;
    }

    @Override
    public String getScannerConfigDiscoveryProfileId() {
        String discoveryProfileId = this.getScannerConfigDiscoveryProfileIdInternal();
        if (discoveryProfileId == null && this.useLegacyScannerDiscoveryProfiles()) {
            discoveryProfileId = this.getLegacyScannerConfigDiscoveryProfileId();
        }
        return discoveryProfileId;
    }

    private String getScannerConfigDiscoveryProfileIdInternal() {
        if (this.scannerConfigDiscoveryProfileId == null && this.superClass instanceof ToolChain) {
            return ((ToolChain)this.getSuperClass()).getScannerConfigDiscoveryProfileIdInternal();
        }
        return this.scannerConfigDiscoveryProfileId;
    }

    @Override
    public void setScannerConfigDiscoveryProfileId(String profileId) {
        if (this.scannerConfigDiscoveryProfileId == null && profileId == null) {
            return;
        }
        if (this.scannerConfigDiscoveryProfileId == null || !this.scannerConfigDiscoveryProfileId.equals(profileId)) {
            this.scannerConfigDiscoveryProfileId = profileId;
            this.setDirty(true);
        }
    }

    public IConfigurationElement getPathconverterElement() {
        return this.pathconverterElement;
    }

    @Override
    public IOptionPathConverter getOptionPathConverter() {
        if (this.optionPathConverter != null) {
            return this.optionPathConverter;
        }
        IConfigurationElement element = this.getPathconverterElement();
        if (element != null) {
            try {
                if (element.getAttribute("optionPathConverter") != null) {
                    this.optionPathConverter = (IOptionPathConverter)element.createExecutableExtension("optionPathConverter");
                    return this.optionPathConverter;
                }
            }
            catch (CoreException coreException) {}
        } else if (this.getSuperClass() != null) {
            IToolChain superTool = this.getSuperClass();
            return superTool.getOptionPathConverter();
        }
        return null;
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionToolChain;
    }

    @Override
    public boolean isDirty() {
        if (this.isExtensionToolChain) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        if (this.builder != null && this.builder.isDirty()) {
            return true;
        }
        for (Tool toolChild : this.getToolList()) {
            if (!toolChild.isDirty()) continue;
            return true;
        }
        if (super.isDirty()) {
            return true;
        }
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        super.setDirty(isDirty);
        if (!isDirty) {
            for (Tool toolChild : this.getToolList()) {
                toolChild.setDirty(false);
            }
        }
    }

    @Override
    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.setSuperClassInternal(ManagedBuildManager.getExtensionToolChain(this.superClassId));
                if (this.getSuperClass() == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "toolChain", this.getId());
                } else {
                    ((ToolChain)this.getSuperClass()).resolveReferences();
                }
            }
            super.resolveReferences();
            if (this.targetPlatform != null) {
                this.targetPlatform.resolveReferences();
            }
            if (this.builder != null) {
                this.builder.resolveReferences();
            }
            for (Tool toolChild : this.getToolList()) {
                toolChild.resolveReferences();
            }
        }
    }

    public void normalizeOutputExtensions() {
        ITool[] tools = this.getTools();
        if (tools != null) {
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String[] extensions = tool.getOutputsAttribute();
                if (extensions == null) {
                    tool.setOutputsAttribute(EMPTY_STRING);
                } else if (extensions.length == 0) {
                    tool.setOutputsAttribute(EMPTY_STRING);
                }
                ++i;
            }
        }
    }

    @Override
    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    @Override
    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    @Override
    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getVersionsSupported();
            }
            return EMPTY_STRING;
        }
        return this.versionsSupported;
    }

    @Override
    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    private IConfigurationElement getIsToolChainSupportedElement() {
        if (this.managedIsToolChainSupportedElement == null && this.superClass != null && this.superClass instanceof ToolChain) {
            return ((ToolChain)this.superClass).getIsToolChainSupportedElement();
        }
        return this.managedIsToolChainSupportedElement;
    }

    @Override
    public boolean isSupported() {
        IConfigurationElement element;
        if (this.managedIsToolChainSupported == null && (element = this.getIsToolChainSupportedElement()) != null) {
            try {
                if (element.getAttribute("isToolChainSupported") != null) {
                    this.managedIsToolChainSupported = (IManagedIsToolChainSupported)element.createExecutableExtension("isToolChainSupported");
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (this.managedIsToolChainSupported != null) {
            try {
                return this.managedIsToolChainSupported.isSupported(this, null, null);
            }
            catch (Throwable e) {
                ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "Exception in toolchain [" + this.getName() + "], id=" + this.getId(), e));
                return false;
            }
        }
        return true;
    }

    public IConfigurationElement getEnvironmentVariableSupplierElement() {
        if (this.environmentVariableSupplierElement == null && this.getSuperClass() != null && this.getSuperClass() instanceof ToolChain) {
            return ((ToolChain)this.getSuperClass()).getEnvironmentVariableSupplierElement();
        }
        return this.environmentVariableSupplierElement;
    }

    @Override
    public IConfigurationEnvironmentVariableSupplier getEnvironmentVariableSupplier() {
        if (this.environmentVariableSupplier != null) {
            return this.environmentVariableSupplier;
        }
        IConfigurationElement element = this.getEnvironmentVariableSupplierElement();
        if (element != null) {
            try {
                if (element.getAttribute("configurationEnvironmentSupplier") != null) {
                    this.environmentVariableSupplier = (IConfigurationEnvironmentVariableSupplier)element.createExecutableExtension("configurationEnvironmentSupplier");
                    return this.environmentVariableSupplier;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public IConfigurationElement getBuildMacroSupplierElement() {
        if (this.buildMacroSupplierElement == null && this.superClass != null && this.superClass instanceof ToolChain) {
            return ((ToolChain)this.superClass).getBuildMacroSupplierElement();
        }
        return this.buildMacroSupplierElement;
    }

    @Override
    public IConfigurationBuildMacroSupplier getBuildMacroSupplier() {
        if (this.buildMacroSupplier != null) {
            return this.buildMacroSupplier;
        }
        IConfigurationElement element = this.getBuildMacroSupplierElement();
        if (element != null) {
            try {
                if (element.getAttribute("configurationMacroSupplier") != null) {
                    this.buildMacroSupplier = (IConfigurationBuildMacroSupplier)element.createExecutableExtension("configurationMacroSupplier");
                    return this.buildMacroSupplier;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public void checkForMigrationSupport() {
        boolean isExists = false;
        if (this.getSuperClass() == null) {
            String high = ManagedBuildManager.getExtensionToolChainMap().lastKey();
            SortedMap<String, ? extends IToolChain> subMap = null;
            if (this.superClassId.compareTo(high) > 0) {
                IConfiguration parentConfig = this.getParent();
                IManagedProject managedProject = parentConfig.getManagedProject();
                if (managedProject != null) {
                    managedProject.setValid(false);
                }
                return;
            }
            subMap = ManagedBuildManager.getExtensionToolChainMap().subMap(this.superClassId, high + "\u0000");
            String baseId = ManagedBuildManager.getIdFromIdAndVersion(this.superClassId);
            String version = this.getVersionFromId().toString();
            Collection<? extends IToolChain> c = subMap.values();
            IToolChain[] toolChainElements = c.toArray(new IToolChain[c.size()]);
            int i = 0;
            while (i < toolChainElements.length) {
                String versionsSupported;
                IToolChain toolChainElement = toolChainElements[i];
                if (ManagedBuildManager.getIdFromIdAndVersion(toolChainElement.getId()).compareTo(baseId) > 0) break;
                if (ManagedBuildManager.getIdFromIdAndVersion(toolChainElement.getId()).equals(baseId) && (versionsSupported = toolChainElement.getVersionsSupported()) != null && !versionsSupported.isEmpty()) {
                    String[] tmpVersions = versionsSupported.split(",");
                    int j = 0;
                    while (j < tmpVersions.length) {
                        if (new Version(version).equals((Object)new Version(tmpVersions[j]))) {
                            String supportedVersion = ManagedBuildManager.getVersionFromIdAndVersion(toolChainElement.getId());
                            this.setId(ManagedBuildManager.getIdFromIdAndVersion(this.getId()) + "_" + supportedVersion);
                            this.setSuperClassInternal(toolChainElement);
                            this.superClassId = this.getSuperClass().getId();
                            isExists = true;
                            break;
                        }
                        ++j;
                    }
                    if (isExists) break;
                }
                ++i;
            }
        }
        if (this.getSuperClass() != null) {
            String convertToId = this.getSuperClass().getConvertToId();
            if (convertToId == null || convertToId.isEmpty()) {
                return;
            }
            this.getConverter(convertToId);
        } else {
            IConfiguration parentConfig = this.getParent();
            IManagedProject managedProject = parentConfig.getManagedProject();
            if (managedProject != null) {
                managedProject.setValid(false);
            }
        }
    }

    private void getConverter(String convertToId) {
        IConfiguration parentConfig;
        IManagedProject managedProject;
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getSuperClass().getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            Version currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.compareTo(new Version(mbsVersion)) > 0) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((managedProject = (parentConfig = this.getParent()).getManagedProject()) != null) {
            managedProject.setValid(false);
        }
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }

    @Override
    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        for (Tool t : this.getToolList()) {
            t.updateManagedBuildRevision(revision);
        }
        if (this.builder != null) {
            this.builder.updateManagedBuildRevision(revision);
        }
    }

    @Override
    public boolean needsRebuild() {
        if (this.rebuildState) {
            return true;
        }
        ITool[] tools = this.getTools();
        int i = 0;
        while (i < tools.length) {
            if (tools[i].needsRebuild()) {
                return true;
            }
            ++i;
        }
        return super.needsRebuild();
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        if (this.rebuildState != rebuild) {
            this.rebuildState = rebuild;
            this.saveRebuildState();
        }
        if (!rebuild) {
            super.setRebuildState(false);
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                tools[i].setRebuildState(false);
                ++i;
            }
        }
    }

    private void saveRebuildState() {
        if (((Configuration)this.config).isPreference()) {
            return;
        }
        PropertyManager.getInstance().setProperty(this, REBUILD_STATE, Boolean.toString(this.needsRebuild()));
    }

    @Override
    public IFolderInfo getParentFolderInfo() {
        return this.parentFolderInfo;
    }

    void setTargetPlatform(TargetPlatform tp) {
        this.targetPlatform = tp;
    }

    @Override
    public CTargetPlatformData getTargetPlatformData() {
        if (this.isExtensionToolChain) {
            return null;
        }
        if (this.targetPlatform == null) {
            ITargetPlatform platform = this.getTargetPlatform();
            if (platform != null) {
                ITargetPlatform extPlatform = platform;
                while (extPlatform != null && !extPlatform.isExtensionElement()) {
                    extPlatform = extPlatform.getSuperClass();
                }
                String subId = extPlatform != null ? ManagedBuildManager.calculateChildId(extPlatform.getId(), null) : ManagedBuildManager.calculateChildId(this.getId(), null);
                this.targetPlatform = new TargetPlatform(this, subId, platform.getName(), (TargetPlatform)extPlatform);
            } else {
                String subId = ManagedBuildManager.calculateChildId(this.getId(), null);
                this.targetPlatform = new TargetPlatform(this, null, subId, EMPTY_STRING, false);
            }
        }
        return this.targetPlatform.getTargetPlatformData();
    }

    public boolean supportsType(String type, boolean checkTools) {
        SupportedProperties props = this.findSupportedProperties();
        boolean supports = false;
        if (props != null) {
            supports = props.supportsType(type);
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            if (calc != null) {
                supports = calc.referesProperty(type);
            }
            if (!supports) {
                supports = super.supportsType(type);
            }
        }
        if (!supports && checkTools) {
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                if (((Tool)tools[i]).supportsType(type)) {
                    supports = true;
                    break;
                }
                ++i;
            }
        }
        return supports;
    }

    @Override
    public boolean supportsType(String type) {
        return this.supportsType(type, true);
    }

    @Override
    public boolean supportsType(IBuildPropertyType type) {
        return this.supportsType(type.getId());
    }

    @Override
    public boolean supportsValue(String type, String value) {
        return this.supportsValue(type, value, true);
    }

    public boolean supportsValue(String type, String value, boolean checkTools) {
        SupportedProperties props = this.findSupportedProperties();
        boolean supports = false;
        if (props != null) {
            supports = props.supportsValue(type, value);
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            if (calc != null) {
                supports = calc.referesPropertyValue(type, value);
            }
            if (!supports) {
                supports = super.supportsValue(type, value);
            }
        }
        if (!supports && checkTools) {
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                if (((Tool)tools[i]).supportsValue(type, value)) {
                    supports = true;
                    break;
                }
                ++i;
            }
        }
        return supports;
    }

    @Override
    public boolean supportsValue(IBuildPropertyType type, IBuildPropertyValue value) {
        return this.supportsValue(type.getId(), value.getId());
    }

    @Override
    public void propertiesChanged() {
        if (this.isExtensionToolChain) {
            return;
        }
        BooleanExpressionApplicabilityCalculator calculator = this.getBooleanExpressionCalculator();
        if (calculator != null) {
            calculator.adjustToolChain(this.getParentFolderInfo(), this, false);
        }
        super.propertiesChanged();
        ITool[] iToolArray = this.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool t = iToolArray[n2];
            ((Tool)t).propertiesChanged();
            ++n2;
        }
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator() {
        if (this.booleanExpressionCalculator == null && this.superClass != null) {
            return ((ToolChain)this.superClass).getBooleanExpressionCalculator();
        }
        return this.booleanExpressionCalculator;
    }

    @Override
    protected IResourceInfo getParentResourceInfo() {
        return this.getParentFolderInfo();
    }

    @Override
    public boolean matches(IToolChain tc) {
        if (tc == this) {
            return true;
        }
        IToolChain rTc = ManagedBuildManager.getRealToolChain(this);
        if (rTc == null) {
            return false;
        }
        return rTc == ManagedBuildManager.getRealToolChain(tc);
    }

    @Override
    public List<ToolChain> getIdenticalList() {
        return this.identicalList;
    }

    @Override
    public boolean supportsBuild(boolean managed) {
        if (!this.getSupportsManagedBuildAttribute()) {
            return !managed;
        }
        IBuilder builder = this.getBuilder();
        if (builder != null && !builder.supportsBuild(managed)) {
            return false;
        }
        ITool[] tools = this.getTools();
        int i = 0;
        while (i < tools.length) {
            if (!tools[i].supportsBuild(managed)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean getSupportsManagedBuildAttribute() {
        if (this.supportsManagedBuild == null) {
            if (this.superClass != null) {
                return ((ToolChain)this.superClass).getSupportsManagedBuildAttribute();
            }
            return true;
        }
        return this.supportsManagedBuild;
    }

    @Override
    public boolean isSystemObject() {
        if (this.isTest) {
            return true;
        }
        if (this.getConvertToId().length() != 0) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().isSystemObject();
        }
        return false;
    }

    @Override
    public MatchKey<ToolChain> getMatchKey() {
        if (this.isAbstract()) {
            return null;
        }
        if (!this.isExtensionToolChain) {
            return null;
        }
        return new MatchKey<ToolChain>(this);
    }

    @Override
    public void setIdenticalList(List<ToolChain> list) {
        this.identicalList = list;
    }

    public String getNameAndVersion() {
        String name = this.getName();
        String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
        if (version != null && version.length() != 0) {
            return name + " (" + version + EMPTY_STRING;
        }
        return name;
    }

    public IConfigurationElement getConverterModificationElement(IToolChain tc) {
        Map<String, IConfigurationElement> map = ManagedBuildManager.getConversionElements(this);
        IConfigurationElement element = null;
        if (!map.isEmpty()) {
            for (IConfigurationElement el : map.values()) {
                String toId = el.getAttribute("toId");
                IToolChain toTc = tc;
                if (toId != null) {
                    while (toTc != null) {
                        if (toId.equals(toTc.getId())) break;
                        toTc = toTc.getSuperClass();
                    }
                }
                if (toTc == null) continue;
                element = el;
                break;
            }
        }
        return element;
    }

    public IConfigurationElement getConverterModificationElement(ITool fromTool, ITool toTool) {
        return ((Tool)fromTool).getConverterModificationElement(toTool);
    }

    void updateParentFolderInfo(FolderInfo info) {
        this.parentFolderInfo = info;
        this.config = this.parentFolderInfo.getParent();
    }

    @Override
    public String[] getRequiredTypeIds() {
        return this.getRequiredTypeIds(true);
    }

    public String[] getRequiredTypeIds(boolean checkTools) {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (props != null) {
            result.addAll(Arrays.asList(props.getRequiredTypeIds()));
        } else {
            result.addAll(Arrays.asList(super.getRequiredTypeIds()));
        }
        if (checkTools) {
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                result.addAll(Arrays.asList(((Tool)tools[i]).getRequiredTypeIds()));
                ++i;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getSupportedTypeIds() {
        return this.getSupportedTypeIds(true);
    }

    public String[] getSupportedTypeIds(boolean checkTools) {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (props != null) {
            result.addAll(Arrays.asList(props.getSupportedTypeIds()));
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            if (calc != null) {
                result.addAll(Arrays.asList(calc.getReferencedPropertyIds()));
            }
            result.addAll(Arrays.asList(super.getSupportedTypeIds()));
        }
        if (checkTools) {
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                result.addAll(Arrays.asList(((Tool)tools[i]).getSupportedTypeIds()));
                ++i;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getSupportedValueIds(String typeId) {
        return this.getSupportedValueIds(typeId, true);
    }

    public String[] getSupportedValueIds(String typeId, boolean checkTools) {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (props != null) {
            result.addAll(Arrays.asList(props.getSupportedValueIds(typeId)));
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            if (calc != null) {
                result.addAll(Arrays.asList(calc.getReferencedValueIds(typeId)));
            }
            result.addAll(Arrays.asList(super.getSupportedValueIds(typeId)));
        }
        if (checkTools) {
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                result.addAll(Arrays.asList(((Tool)tools[i]).getSupportedValueIds(typeId)));
                ++i;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean requiresType(String typeId) {
        return this.requiresType(typeId, true);
    }

    public boolean requiresType(String typeId, boolean checkTools) {
        SupportedProperties props = this.findSupportedProperties();
        boolean required = false;
        required = props != null ? props.requiresType(typeId) : super.requiresType(typeId);
        if (!required && checkTools) {
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                if (((Tool)tools[i]).requiresType(typeId)) {
                    required = true;
                    break;
                }
                ++i;
            }
        }
        return required;
    }

    private SupportedProperties findSupportedProperties() {
        if (this.supportedProperties == null && this.superClass != null) {
            return ((ToolChain)this.superClass).findSupportedProperties();
        }
        return this.supportedProperties;
    }

    private void loadProperties(IManagedConfigElement el) {
        this.supportedProperties = new SupportedProperties(el);
    }

    void setNonInternalBuilderId(String id) {
        this.nonInternalBuilderId = id;
    }

    String getNonInternalBuilderId() {
        if (this.nonInternalBuilderId == null) {
            if (this.superClass != null) {
                return ((ToolChain)this.superClass).getNonInternalBuilderId();
            }
            return null;
        }
        return this.nonInternalBuilderId;
    }

    public void resetErrorParsers(FolderInfo info) {
        this.errorParserIds = null;
        info.resetErrorParsers(info.getFilteredTools());
        if (info.isRoot() && this.builder != null) {
            this.builder.resetErrorParsers();
        }
    }

    void removeErrorParsers(FolderInfo info, Set<String> set) {
        if (set != null && !set.isEmpty()) {
            Set<String> oldSet = this.contributeErrorParsers(info, null, false);
            if (oldSet == null) {
                oldSet = new HashSet<String>();
            }
            oldSet.removeAll(set);
            this.setErrorParserList(oldSet.toArray(new String[oldSet.size()]));
            info.removeErrorParsers(info.getFilteredTools(), set);
            if (info.isRoot()) {
                Builder builder = (Builder)info.getParent().getEditableBuilder();
                builder.removeErrorParsers(set);
            }
        }
    }

    public void setErrorParserList(String[] ids) {
        if (ids == null) {
            this.errorParserIds = null;
        } else if (ids.length == 0) {
            this.errorParserIds = EMPTY_STRING;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(ids[0]);
            int i = 1;
            while (i < ids.length) {
                buf.append(";").append(ids[i]);
                ++i;
            }
            this.errorParserIds = buf.toString();
        }
    }

    @Override
    public String getUniqueRealName() {
        String name = this.getName();
        if (name == null) {
            name = this.getId();
        } else {
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
            if (version != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(name);
                buf.append(" (v").append(version).append(")");
                name = buf.toString();
            }
        }
        return name;
    }

    void resolveProjectReferences(boolean onLoad) {
        for (Tool tool : this.getToolList()) {
            tool.resolveProjectReferences(onLoad);
        }
    }

    public boolean hasScannerConfigSettings() {
        return this.getScannerConfigDiscoveryProfileId() != null;
    }

    public boolean isPerRcTypeDiscovery() {
        if (this.isRcTypeBasedDiscovery == null) {
            if (this.superClass != null) {
                return ((ToolChain)this.superClass).isPerRcTypeDiscovery();
            }
            return true;
        }
        return this.isRcTypeBasedDiscovery;
    }

    public void setPerRcTypeDiscovery(boolean on) {
        this.isRcTypeBasedDiscovery = on;
    }

    public CfgDiscoveredPathManager.PathInfoCache setDiscoveredPathInfo(CfgDiscoveredPathManager.PathInfoCache info) {
        CfgDiscoveredPathManager.PathInfoCache oldInfo = this.discoveredInfo;
        this.discoveredInfo = info;
        return oldInfo;
    }

    public CfgDiscoveredPathManager.PathInfoCache getDiscoveredPathInfo() {
        return this.discoveredInfo;
    }

    public CfgDiscoveredPathManager.PathInfoCache clearDiscoveredPathInfo() {
        CfgDiscoveredPathManager.PathInfoCache oldInfo = this.discoveredInfo;
        this.discoveredInfo = null;
        return oldInfo;
    }

    public boolean isPreferenceToolChain() {
        IToolChain tch = ManagedBuildManager.getRealToolChain(this);
        return tch != null && tch.getId().equals("org.eclipse.cdt.build.core.prefbase.toolchain");
    }

    public boolean hasCustomSettings(ToolChain tCh) {
        ITool[] otherTools;
        IToolChain otherRealTc;
        if (this.superClass == null) {
            return true;
        }
        IToolChain realTc = ManagedBuildManager.getRealToolChain(this);
        if (realTc != (otherRealTc = ManagedBuildManager.getRealToolChain(tCh))) {
            return true;
        }
        if (this.hasCustomSettings()) {
            return true;
        }
        ITool[] tools = this.getTools();
        if (tools.length != (otherTools = tCh.getTools()).length) {
            return true;
        }
        int i = 0;
        while (i < tools.length) {
            Tool tool = (Tool)tools[i];
            Tool otherTool = (Tool)otherTools[i];
            if (tool.hasCustomSettings(otherTool)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getSuperClassNum() {
        int num = 0;
        IToolChain superTool = this.getSuperClass();
        while (superTool != null) {
            ++num;
            superTool = superTool.getSuperClass();
        }
        return num;
    }

    @Override
    public int compareTo(ToolChain other) {
        if (other.isSystemObject() != this.isSystemObject()) {
            return this.isSystemObject() ? 1 : -1;
        }
        return this.getSuperClassNum() - other.getSuperClassNum();
    }

    private Set<String> getUnusedChilrenSet() {
        if (this.unusedChildrenSet == null) {
            String[] childIds = CDataUtil.stringToArray((String)this.unusedChildren, (String)";");
            if (childIds == null) {
                this.unusedChildrenSet = new HashSet<String>();
            } else {
                this.unusedChildrenSet = new HashSet<String>();
                this.unusedChildrenSet.addAll(Arrays.asList(childIds));
            }
        }
        return this.unusedChildrenSet;
    }

    void addUnusedChild(ITool tool) {
        Set<String> set = this.getUnusedChilrenSet();
        set.add(tool.getId());
        this.unusedChildrenSet = set;
        this.unusedChildren = this.translateUnusedIdSetToString(set);
    }

    void setUnusedChildren(String children) {
        if (Objects.equals(this.unusedChildren, children)) {
            return;
        }
        this.unusedChildrenSet = null;
        this.unusedChildren = children;
    }

    private String translateUnusedIdSetToString(Set<String> set) {
        return CDataUtil.arrayToString((Object[])set.toArray(), (String)";");
    }

    void addProjectVariables(StorableCdtVariables vars) {
        if (vars != null && !vars.isEmpty()) {
            StorableCdtVariables cfgVars = new StorableCdtVariables(vars, false);
            if (this.userDefinedMacros != null) {
                cfgVars.createMacros(this.userDefinedMacros.getMacros());
            }
            this.userDefinedMacros = cfgVars;
        }
    }

    public StorableCdtVariables getResetOldStyleProjectVariables() {
        StorableCdtVariables vars = this.userDefinedMacros;
        this.userDefinedMacros = null;
        return vars;
    }

    @Override
    public IRealBuildObjectAssociation getExtensionObject() {
        return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionToolChain(this));
    }

    @Override
    public IRealBuildObjectAssociation[] getIdenticBuildObjects() {
        return (IRealBuildObjectAssociation[])ManagedBuildManager.findIdenticalToolChains(this);
    }

    @Override
    public IRealBuildObjectAssociation getRealBuildObject() {
        return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getRealToolChain(this));
    }

    @Override
    public IRealBuildObjectAssociation getSuperClassObject() {
        return (IRealBuildObjectAssociation)((Object)this.getSuperClass());
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public boolean isRealBuildObject() {
        return this.getRealBuildObject() == this;
    }

    @Override
    public boolean isExtensionBuildObject() {
        return this.isExtensionElement();
    }
}

