/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import org.eclipse.cdt.core.envvar.IEnvironmentContributor;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildEnvironmentContributor;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BuildBuildData
extends CBuildData {
    private Builder fBuilder;
    private Configuration fCfg;

    public BuildBuildData(IBuilder builder) {
        this.fBuilder = (Builder)builder;
        this.fCfg = (Configuration)this.fBuilder.getParent().getParent();
    }

    public IPath getBuilderCWD() {
        return new Path(this.fBuilder.getBuildPath());
    }

    public String[] getErrorParserIDs() {
        return this.fCfg.getErrorParserList();
    }

    public ICOutputEntry[] getOutputDirectories() {
        return this.fBuilder.getOutputEntries();
    }

    public void setBuilderCWD(IPath path) {
        this.fBuilder.setBuildPath(path.toString());
    }

    public void setErrorParserIDs(String[] ids) {
        this.fCfg.setErrorParserList(ids);
    }

    public void setOutputDirectories(ICOutputEntry[] entries) {
        this.fBuilder.setOutputEntries(entries);
    }

    public String getId() {
        return this.fBuilder.getId();
    }

    public String getName() {
        return this.fBuilder.getName();
    }

    public boolean isValid() {
        return this.fBuilder != null;
    }

    public void setName(String name) {
    }

    public IEnvironmentContributor getBuildEnvironmentContributor() {
        return new BuildEnvironmentContributor(this);
    }

    public ICommand getBuildSpecCommand() {
        try {
            return BuilderFactory.createCommandFromBuilder(this.fBuilder);
        }
        catch (CoreException cx) {
            ManagedBuilderCorePlugin.log(cx);
            return null;
        }
    }

    public IBuilder getBuilder() {
        return this.fBuilder;
    }
}

