/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.envvar.IEnvironmentContributor;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildBuildData;
import org.eclipse.cdt.managedbuilder.internal.envvar.ExternalExtensionEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.MbsEnvironmentSupplier;
import org.eclipse.cdt.utils.envvar.EnvironmentCollector;

public class BuildEnvironmentContributor
implements IEnvironmentContributor {
    private BuildBuildData fBuildData;
    private IConfiguration fCfg;
    private ICConfigurationDescription fCfgDes;
    private MbsEnvironmentSupplier fMbsSupplier = new MbsEnvironmentSupplier();

    public BuildEnvironmentContributor(BuildBuildData buildData) {
        this.fBuildData = buildData;
        this.fCfg = this.fBuildData.getBuilder().getParent().getParent();
        this.fCfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.fCfg);
    }

    public IEnvironmentVariable getVariable(String name, IEnvironmentVariableManager provider) {
        EnvironmentCollector collector = new EnvironmentCollector();
        ExternalExtensionEnvironmentSupplier extSupplier = new ExternalExtensionEnvironmentSupplier(provider);
        boolean varFound = false;
        IEnvironmentVariable var = extSupplier.getVariable(name, this.fCfg.getManagedProject());
        varFound = this.processVariable(name, var, collector, provider, varFound);
        var = this.fMbsSupplier.getVariable(name, this.fCfg);
        varFound = this.processVariable(name, var, collector, provider, varFound);
        var = extSupplier.getVariable(name, this.fCfg);
        varFound = this.processVariable(name, var, collector, provider, varFound);
        return collector.getVariable(name);
    }

    public IEnvironmentVariable[] getVariables(IEnvironmentVariableManager provider) {
        EnvironmentCollector collector = new EnvironmentCollector();
        ExternalExtensionEnvironmentSupplier extSupplier = new ExternalExtensionEnvironmentSupplier(provider);
        Set<String> set = null;
        IEnvironmentVariable[] vars = extSupplier.getVariables(this.fCfg.getManagedProject());
        set = this.processVariables(vars, collector, provider, set);
        vars = this.fMbsSupplier.getVariables(this.fCfg);
        set = this.processVariables(vars, collector, provider, set);
        vars = extSupplier.getVariables(this.fCfg);
        set = this.processVariables(vars, collector, provider, set);
        return collector.getVariables();
    }

    private boolean processVariable(String name, IEnvironmentVariable var, EnvironmentCollector collector, IEnvironmentVariableManager provider, boolean varFound) {
        if (var != null) {
            if (!varFound) {
                varFound = true;
                IEnvironmentVariable base = provider.getVariable(name, this.fCfgDes, false);
                if (base != null) {
                    collector.addVariable(base);
                }
            }
            collector.addVariable(var);
        }
        return varFound;
    }

    private Set<String> processVariables(IEnvironmentVariable[] vars, EnvironmentCollector collector, IEnvironmentVariableManager provider, Set<String> set) {
        boolean checkSet = true;
        if (vars != null && vars.length != 0) {
            if (set == null) {
                set = new HashSet<String>();
                checkSet = false;
            }
            int i = 0;
            while (i < vars.length) {
                if (vars[i] != null) {
                    IEnvironmentVariable base;
                    if ((set.add(vars[i].getName()) || !checkSet) && (base = provider.getVariable(vars[i].getName(), this.fCfgDes, false)) != null) {
                        collector.addVariable(base);
                    }
                    collector.addVariable(vars[i]);
                }
                ++i;
            }
        }
        return set;
    }
}

