/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.terminal.view.core.activator.CoreBundleActivator;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalContextPropertiesProvider;
import org.eclipse.tm.terminal.view.core.nls.Messages;
import org.osgi.framework.Bundle;

public final class TerminalContextPropertiesProviderFactory {
    private static boolean contributionsLoaded = false;
    private static final List<Proxy> contributions = new ArrayList<Proxy>();

    private static Proxy getProxy(IConfigurationElement config) {
        Proxy proxy;
        block2: {
            Assert.isNotNull((Object)config);
            proxy = new Proxy();
            try {
                proxy.setInitializationData(config, null, null);
            }
            catch (CoreException e) {
                if (!Platform.inDebugMode()) break block2;
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log(e.getStatus());
            }
        }
        return proxy;
    }

    private static void loadContributions() {
        IExtension[] extensions;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tm.terminal.view.core.contextPropertiesProviders");
        if (ep != null && (extensions = ep.getExtensions()) != null) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                if (configElements != null) {
                    IConfigurationElement[] iConfigurationElementArray = configElements;
                    int n3 = configElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        if ("contextPropertiesProvider".equals(configElement.getName())) {
                            Proxy proxy = TerminalContextPropertiesProviderFactory.getProxy(configElement);
                            contributions.add(proxy);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITerminalContextPropertiesProvider getProvider(Object context) {
        Assert.isNotNull((Object)context);
        List<Proxy> list = contributions;
        synchronized (list) {
            if (!contributionsLoaded) {
                TerminalContextPropertiesProviderFactory.loadContributions();
                contributionsLoaded = true;
            }
        }
        for (Proxy proxy : contributions) {
            if (!proxy.isEnabled(context)) continue;
            return proxy.getProvider();
        }
        return null;
    }

    private static class Proxy
    implements IExecutableExtension {
        private IConfigurationElement configElement = null;
        public String clazz;
        private ITerminalContextPropertiesProvider provider = null;
        private Expression expression;

        protected Proxy() {
        }

        public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
            Assert.isNotNull((Object)config);
            this.configElement = config;
            this.clazz = config.getAttribute("class");
            if (this.clazz == null || "".equals(this.clazz.trim())) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"class", (Object)config.getContributor().getName())));
            }
            IConfigurationElement[] children = this.configElement.getChildren("enablement");
            if (children == null || children.length == 0) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"enablement", (Object)config.getContributor().getName())));
            }
            this.expression = ExpressionConverter.getDefault().perform(children[0]);
        }

        protected ITerminalContextPropertiesProvider getProvider() {
            if (this.provider == null && this.configElement != null) {
                try {
                    Object provider = this.configElement.createExecutableExtension("class");
                    if (provider instanceof ITerminalContextPropertiesProvider) {
                        this.provider = (ITerminalContextPropertiesProvider)provider;
                    } else {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Terminal context properties provider '" + provider.getClass().getName() + "' not of type ITerminalContextPropertiesProvider.");
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Cannot create terminal context properties provider '" + this.clazz + "'.", (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
            }
            return this.provider;
        }

        protected boolean isEnabled(Object context) {
            boolean enabled;
            if (context == null) {
                return this.getEnablement() == null;
            }
            Expression enablement = this.getEnablement();
            boolean bl = enabled = enablement == null;
            if (enablement != null) {
                EvaluationContext evalContext = new EvaluationContext(null, context);
                evalContext.setAllowPluginActivation(true);
                try {
                    enabled = enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
            }
            return enabled;
        }

        protected Expression getEnablement() {
            return this.expression;
        }
    }
}

