/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.net.URI;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;

public final class RefactoringPropertyPageTester
extends PropertyTester {
    public static final String PROPERTY_NAME = "refactoringPropertiesEnabled";

    private IFileStore getHistoryStore(IProject project) {
        block4: {
            IPath location = RefactoringCorePlugin.getDefault().getStateLocation();
            IFileStore store = EFS.getLocalFileSystem().getStore(location).getChild(".refactorings");
            try {
                if (!project.isAccessible()) break block4;
                if (RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project)) {
                    URI uri = project.getLocationURI();
                    if (uri != null) {
                        return EFS.getStore((URI)uri).getChild(".refactorings");
                    }
                    break block4;
                }
                return store.getChild(project.getName());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean test(Object receiver, String property, Object[] arguments, Object expected) {
        IProject project;
        IFileStore store;
        IAdaptable adaptable;
        IResource resource;
        if (PROPERTY_NAME.equals(property) && receiver instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)receiver).getAdapter(IResource.class)) instanceof IProject && (store = this.getHistoryStore(project = (IProject)resource)) != null) {
            return store.fetchInfo().exists();
        }
        return false;
    }
}

