/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class DelegatingCommandAction
extends Action
implements ISelectionListener,
ISelectionChangedListener {
    protected IActionDelegate actionDelegate;
    @Deprecated
    protected IEditorActionDelegate editorActionDelegate;
    protected IWorkbenchPart workbenchPart;
    @Deprecated
    protected IEditorPart editorPart;

    public DelegatingCommandAction(IActionDelegate actionDelegate) {
        this.actionDelegate = actionDelegate;
        if (actionDelegate instanceof IEditorActionDelegate) {
            this.editorActionDelegate = (IEditorActionDelegate)actionDelegate;
        }
    }

    public DelegatingCommandAction(IEditorActionDelegate editorActionDelegate) {
        this((IActionDelegate)editorActionDelegate);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.handleSelection(event.getSelection());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.handleSelection(selection);
    }

    protected void selectionChanged(ISelection selection) {
        if (this.actionDelegate != null) {
            this.editorActionDelegate.selectionChanged((IAction)this, selection);
        } else {
            this.actionDelegate.selectionChanged((IAction)this, selection);
        }
    }

    protected void handleSelection(ISelection selection) {
        this.selectionChanged(selection);
    }

    protected void registerSelectionListener(IWorkbenchPart workbenchPart) {
        ISelectionProvider selectionProvider = workbenchPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            this.handleSelection(selectionProvider.getSelection());
        }
    }

    @Deprecated
    protected void registerSelectionListener(IEditorPart editorPart) {
        this.registerSelectionListener((IWorkbenchPart)editorPart);
    }

    protected void unregisterSelectionListener(IWorkbenchPart workbenchPart) {
        ISelectionProvider selectionProvider = workbenchPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    @Deprecated
    protected void unregisterSelectionListener(IEditorPart editorPart) {
        this.unregisterSelectionListener((IWorkbenchPart)editorPart);
    }

    @Deprecated
    public void setActiveEditor(IEditorPart editorPart) {
        this.setActiveWorkbenchPart((IWorkbenchPart)editorPart);
        this.editorPart = editorPart;
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (this.workbenchPart != workbenchPart) {
            if (this.workbenchPart != null) {
                this.unregisterSelectionListener(this.workbenchPart);
            }
            this.workbenchPart = workbenchPart;
            if (this.actionDelegate == null) {
                this.editorActionDelegate.setActiveEditor((IAction)this, (IEditorPart)workbenchPart);
            } else if (this.actionDelegate instanceof IEditorActionDelegate) {
                ((IEditorActionDelegate)this.actionDelegate).setActiveEditor((IAction)this, (IEditorPart)workbenchPart);
            } else {
                ((IViewActionDelegate)this.actionDelegate).init((IViewPart)workbenchPart);
            }
            if (workbenchPart != null) {
                this.registerSelectionListener(workbenchPart);
            }
        }
    }

    public void run() {
        this.actionDelegate.run((IAction)this);
    }
}

