/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.oomph.internal.resources.ExternalContainer;
import org.eclipse.oomph.internal.resources.ExternalResource;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendException;

public final class ExternalProject
extends ExternalContainer
implements IProject {
    private final IProjectDescription description;

    public ExternalProject(BackendContainer backendContainer, IProjectDescription description) {
        super(null, backendContainer);
        this.description = description;
        if (description instanceof Description) {
            ((Description)description).setProject(this);
        }
    }

    @Override
    public IPath getFullPath() {
        return new Path(this.getName()).makeAbsolute();
    }

    @Override
    public IProject getProject() {
        return this;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String getName() {
        return this.description.getName();
    }

    public void build(int kind, String builderName, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void build(int kind, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void build(IBuildConfiguration config, int kind, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void close(IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void create(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void create(IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void create(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public IBuildConfiguration getActiveBuildConfig() throws CoreException {
        return this.getBuildConfig("");
    }

    public IBuildConfiguration getBuildConfig(String configName) throws CoreException {
        IBuildConfiguration[] buildConfigs = this.description.getBuildConfigReferences(configName);
        return buildConfigs.length == 0 ? null : buildConfigs[0];
    }

    public IBuildConfiguration[] getBuildConfigs() throws CoreException {
        return this.description.getBuildConfigReferences("");
    }

    public IBuildConfiguration[] getReferencedBuildConfigs(String configName, boolean includeMissing) throws CoreException {
        return this.getBuildConfigs();
    }

    public boolean hasBuildConfig(String configName) throws CoreException {
        return "".equals(configName);
    }

    public IContentTypeMatcher getContentTypeMatcher() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IProjectDescription getDescription() throws CoreException {
        return this.description;
    }

    public IFile getFile(String name) {
        return null;
    }

    public IFolder getFolder(String name) {
        return null;
    }

    public IProjectNature getNature(String natureId) throws CoreException {
        if (this.description.hasNature(natureId)) {
            return new IProjectNature(){

                public IProject getProject() {
                    return ExternalProject.this;
                }

                public void setProject(IProject project) {
                    throw new UnsupportedOperationException();
                }

                public void configure() throws CoreException {
                    throw new UnsupportedOperationException();
                }

                public void deconfigure() throws CoreException {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    public IPath getWorkingLocation(String id) {
        throw new UnsupportedOperationException();
    }

    public IProject[] getReferencedProjects() throws CoreException {
        return new IProject[0];
    }

    public IProject[] getReferencingProjects() {
        return new IProject[0];
    }

    public void clearCachedDynamicReferences() {
    }

    public boolean hasNature(String natureId) throws CoreException {
        return this.description.hasNature(natureId);
    }

    public boolean isNatureEnabled(String natureId) throws CoreException {
        return this.hasNature(natureId);
    }

    public boolean isOpen() {
        return true;
    }

    public void loadSnapshot(int options, URI snapshotLocation, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void saveSnapshot(int options, URI snapshotLocation, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void move(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void open(int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void open(IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void setDescription(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void setDescription(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public String getDefaultLineSeparator() throws CoreException {
        return System.lineSeparator();
    }

    public static final class Description
    implements IProjectDescription {
        private final BackendContainer backendContainer;
        private String name;
        private String comment;
        private IBuildConfiguration[] buildConfigurations;
        private final List<ICommand> commands = new ArrayList<ICommand>();
        private final List<String> natureIDs = new ArrayList<String>();

        public Description(BackendContainer backendContainer) {
            this.backendContainer = backendContainer;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public ICommand[] getBuildSpec() {
            return this.commands.toArray(new ICommand[this.commands.size()]);
        }

        public String[] getNatureIds() {
            return this.natureIDs.toArray(new String[this.natureIDs.size()]);
        }

        public boolean hasNature(String natureId) {
            return this.natureIDs.contains(natureId);
        }

        public IBuildConfiguration[] getBuildConfigReferences(String configName) {
            if ("".equals(configName)) {
                return this.buildConfigurations;
            }
            return new IBuildConfiguration[0];
        }

        public IProject[] getDynamicReferences() {
            return new IProject[0];
        }

        @Deprecated
        public IPath getLocation() {
            return this.backendContainer.getLocation();
        }

        public URI getLocationURI() {
            try {
                return new URI(this.backendContainer.getAbsoluteURI().toString());
            }
            catch (URISyntaxException ex) {
                throw new BackendException(ex);
            }
        }

        public IProject[] getReferencedProjects() {
            return new IProject[0];
        }

        public ICommand newCommand() {
            return new BuildCommand(null);
        }

        public void setActiveBuildConfig(String configName) {
        }

        public void setBuildConfigs(String[] configNames) {
        }

        public void setBuildConfigReferences(String configName, IBuildConfiguration[] references) {
        }

        public void setBuildSpec(ICommand[] buildSpec) {
        }

        public void setComment(String comment) {
        }

        @Deprecated
        public void setDynamicReferences(IProject[] projects) {
        }

        public void setLocation(IPath location) {
        }

        public void setLocationURI(URI location) {
        }

        public void setName(String projectName) {
        }

        public void setNatureIds(String[] natures) {
        }

        public void setReferencedProjects(IProject[] projects) {
        }

        public void internalSetName(String name) {
            this.name = name;
        }

        public void internalSetComment(String comment) {
            this.comment = comment;
        }

        public void internalAddCommand(String builderName) {
            this.commands.add(new BuildCommand(builderName));
        }

        public void internalAddNatureID(String natureID) {
            this.natureIDs.add(natureID);
        }

        void setProject(ExternalProject project) {
            this.buildConfigurations = new IBuildConfiguration[]{new BuildConfiguration(project)};
        }

        private static final class BuildCommand
        implements ICommand {
            private final String builderName;

            public BuildCommand(String builderName) {
                this.builderName = builderName;
            }

            public String getBuilderName() {
                return this.builderName;
            }

            public Map<String, String> getArguments() {
                return Collections.emptyMap();
            }

            public boolean isBuilding(int kind) {
                return false;
            }

            public boolean isConfigurable() {
                return false;
            }

            public void setArguments(Map<String, String> args) {
            }

            public void setBuilderName(String builderName) {
            }

            public void setBuilding(int kind, boolean value) {
            }
        }

        private static final class BuildConfiguration
        extends PlatformObject
        implements IBuildConfiguration {
            private final ExternalProject project;

            public BuildConfiguration(ExternalProject project) {
                this.project = project;
            }

            public IProject getProject() {
                return this.project;
            }

            public String getName() {
                return "";
            }
        }
    }
}

