/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.search.DocAndScoreAccBuffer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerUtil;
import org.apache.lucene.search.SimpleScorable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.MathUtil;

final class BlockMaxConjunctionBulkScorer
extends BulkScorer {
    private static final int MAX_WINDOW_SIZE = 65536;
    private final Scorer[] scorers;
    private final Scorable[] scorables;
    private final DocIdSetIterator[] iterators;
    private final DocIdSetIterator lead;
    private final SimpleScorable scorable = new SimpleScorable();
    private final double[] sumOfOtherClauses;
    private final int maxDoc;
    private final DocAndFloatFeatureBuffer docAndScoreBuffer = new DocAndFloatFeatureBuffer();
    private final DocAndScoreAccBuffer docAndScoreAccBuffer = new DocAndScoreAccBuffer();

    BlockMaxConjunctionBulkScorer(int maxDoc, List<Scorer> scorers) throws IOException {
        if (scorers.size() <= 1) {
            throw new IllegalArgumentException("Expected 2 or more scorers, got " + scorers.size());
        }
        this.scorers = (Scorer[])scorers.toArray(Scorer[]::new);
        Arrays.sort(this.scorers, Comparator.comparingLong(scorer -> scorer.iterator().cost()));
        this.scorables = (Scorable[])Arrays.stream(this.scorers).map(ScorerUtil::likelyTermScorer).toArray(Scorable[]::new);
        this.iterators = (DocIdSetIterator[])Arrays.stream(this.scorers).map(Scorer::iterator).map(ScorerUtil::likelyImpactsEnum).toArray(DocIdSetIterator[]::new);
        this.lead = this.iterators[0];
        this.sumOfOtherClauses = new double[this.scorers.length];
        Arrays.fill(this.sumOfOtherClauses, Double.POSITIVE_INFINITY);
        this.maxDoc = maxDoc;
    }

    private float computeMaxScore(int windowMin, int windowMax) throws IOException {
        int i;
        for (int i2 = 0; i2 < this.scorers.length; ++i2) {
            this.scorers[i2].advanceShallow(windowMin);
        }
        double maxWindowScore = 0.0;
        for (i = 0; i < this.scorers.length; ++i) {
            float maxClauseScore = this.scorers[i].getMaxScore(windowMax);
            this.sumOfOtherClauses[i] = maxClauseScore;
            maxWindowScore += (double)maxClauseScore;
        }
        for (i = this.sumOfOtherClauses.length - 2; i >= 0; --i) {
            int n = i;
            this.sumOfOtherClauses[n] = this.sumOfOtherClauses[n] + this.sumOfOtherClauses[i + 1];
        }
        return (float)maxWindowScore;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        collector.setScorer(this.scorable);
        int windowMin = Math.max(this.lead.docID(), min);
        if (this.scorable.minCompetitiveScore == 0.0f) {
            windowMin = this.scoreDocFirstUntilDynamicPruning(collector, acceptDocs, min, max);
        }
        while (windowMin < max) {
            int windowMax = Math.min(this.scorers[0].advanceShallow(windowMin), max - 1);
            windowMax = MathUtil.unsignedMin(windowMax, windowMin + 65536);
            float maxWindowScore = this.computeMaxScore(windowMin, windowMax);
            this.scoreWindowScoreFirst(collector, acceptDocs, windowMin, windowMax + 1, maxWindowScore);
            windowMin = Math.max(this.lead.docID(), windowMax + 1);
        }
        return windowMin >= this.maxDoc ? Integer.MAX_VALUE : windowMin;
    }

    private int scoreDocFirstUntilDynamicPruning(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int doc = this.lead.docID();
        if (doc < min) {
            doc = this.lead.advance(min);
        }
        block0: while (doc < max) {
            if (acceptDocs == null || acceptDocs.get(doc)) {
                for (int i = 1; i < this.iterators.length; ++i) {
                    DocIdSetIterator iterator = this.iterators[i];
                    int otherDoc = iterator.docID();
                    if (otherDoc < doc) {
                        otherDoc = iterator.advance(doc);
                    }
                    if (doc == otherDoc) continue;
                    doc = this.lead.advance(otherDoc);
                    continue block0;
                }
                double score = 0.0;
                for (Scorable scorable : this.scorables) {
                    score += (double)scorable.score();
                }
                this.scorable.score = (float)score;
                collector.collect(doc);
                if (this.scorable.minCompetitiveScore > 0.0f) {
                    return this.lead.nextDoc();
                }
            }
            doc = this.lead.nextDoc();
        }
        return doc;
    }

    private void scoreWindowScoreFirst(LeafCollector collector, Bits acceptDocs, int min, int max, float maxWindowScore) throws IOException {
        if (maxWindowScore < this.scorable.minCompetitiveScore) {
            return;
        }
        if (this.lead.docID() < min) {
            this.lead.advance(min);
        }
        if (this.lead.docID() >= max) {
            return;
        }
        this.scorers[0].nextDocsAndScores(max, acceptDocs, this.docAndScoreBuffer);
        while (this.docAndScoreBuffer.size > 0) {
            int i;
            this.docAndScoreAccBuffer.copyFrom(this.docAndScoreBuffer);
            for (i = 1; i < this.scorers.length; ++i) {
                double sumOfOtherClause = this.sumOfOtherClauses[i];
                if (sumOfOtherClause != this.sumOfOtherClauses[i - 1]) {
                    ScorerUtil.filterCompetitiveHits(this.docAndScoreAccBuffer, sumOfOtherClause, this.scorable.minCompetitiveScore, this.scorers.length);
                }
                ScorerUtil.applyRequiredClause(this.docAndScoreAccBuffer, this.iterators[i], this.scorables[i]);
            }
            for (i = 0; i < this.docAndScoreAccBuffer.size; ++i) {
                this.scorable.score = (float)this.docAndScoreAccBuffer.scores[i];
                collector.collect(this.docAndScoreAccBuffer.docs[i]);
            }
            this.scorers[0].nextDocsAndScores(max, acceptDocs, this.docAndScoreBuffer);
        }
        int maxOtherDoc = -1;
        for (int i = 1; i < this.iterators.length; ++i) {
            maxOtherDoc = Math.max(this.iterators[i].docID(), maxOtherDoc);
        }
        if (this.lead.docID() < maxOtherDoc) {
            this.lead.advance(maxOtherDoc);
        }
    }

    @Override
    public long cost() {
        return this.lead.cost();
    }
}

