/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IntsRef;

public final class DocAndFloatFeatureBuffer {
    private static final float[] EMPTY_FLOATS = new float[0];
    public int[] docs = IntsRef.EMPTY_INTS;
    public float[] features = EMPTY_FLOATS;
    public int size;

    public void growNoCopy(int minSize) {
        if (this.docs.length < minSize) {
            this.docs = ArrayUtil.growNoCopy(this.docs, minSize);
            this.features = new float[this.docs.length];
        }
    }

    public void apply(Bits liveDocs) {
        int newSize = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!liveDocs.get(this.docs[i])) continue;
            this.docs[newSize] = this.docs[i];
            this.features[newSize] = this.features[i];
            ++newSize;
        }
        this.size = newSize;
    }
}

