/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistProcessorExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CompositeContentAssistProcessor
implements IContentAssistProcessorExtension,
IContentAssistProcessor {
    private final List<IContentAssistProcessor> fContentAssistProcessors;

    public CompositeContentAssistProcessor(List<IContentAssistProcessor> contentAssistProcessors) {
        this.fContentAssistProcessors = contentAssistProcessors;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset);
            if (proposals == null) continue;
            res.addAll(Arrays.asList(proposals));
        }
        return res.toArray(new ICompletionProposal[res.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ArrayList<IContextInformation> res = new ArrayList<IContextInformation>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            IContextInformation[] contextInformation = processor.computeContextInformation(viewer, offset);
            if (contextInformation == null) continue;
            res.addAll(Arrays.asList(contextInformation));
        }
        return res.toArray(new IContextInformation[res.size()]);
    }

    public String getErrorMessage() {
        StringBuilder res = new StringBuilder();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            String errorMessage = processor.getErrorMessage();
            if (errorMessage == null) continue;
            res.append(errorMessage);
            res.append('\n');
        }
        if (res.length() == 0) {
            return null;
        }
        return res.toString();
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public boolean isCompletionProposalAutoActivation(char c, ITextViewer viewer, int offset) {
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            IContentAssistProcessorExtension adapt = IContentAssistProcessorExtension.adapt((IContentAssistProcessor)processor);
            if (!adapt.isCompletionProposalAutoActivation(c, viewer, offset)) continue;
            return true;
        }
        return false;
    }

    public boolean isContextInformationAutoActivation(char c, ITextViewer viewer, int offset) {
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            IContentAssistProcessorExtension adapt = IContentAssistProcessorExtension.adapt((IContentAssistProcessor)processor);
            if (!adapt.isContextInformationAutoActivation(c, viewer, offset)) continue;
            return true;
        }
        return false;
    }
}

