/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.Arrays;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class UpdateActiveExtensionsOperation
extends AbstractOperation {
    private final String[] contentExtensionsToActivate;
    private final CommonViewer commonViewer;
    private final INavigatorContentService contentService;

    public UpdateActiveExtensionsOperation(CommonViewer aCommonViewer, String[] theExtensionsToActivate) {
        super(CommonNavigatorMessages.UpdateFiltersOperation_Update_CommonViewer_Filter_);
        this.commonViewer = aCommonViewer;
        this.contentService = this.commonViewer.getNavigatorContentService();
        this.contentExtensionsToActivate = theExtensionsToActivate;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        boolean updateExtensionActivation = false;
        Arrays.sort(this.contentExtensionsToActivate);
        ITreeSelection selection = null;
        try {
            this.commonViewer.getControl().setRedraw(false);
            selection = this.commonViewer.getStructuredSelection();
            INavigatorContentDescriptor[] visibleContentDescriptors = this.contentService.getVisibleExtensions();
            int i = 0;
            while (i < visibleContentDescriptors.length && !updateExtensionActivation) {
                int indexofContentExtensionIdToBeActivated = Arrays.binarySearch(this.contentExtensionsToActivate, visibleContentDescriptors[i].getId());
                if (indexofContentExtensionIdToBeActivated >= 0 ^ this.contentService.isActive(visibleContentDescriptors[i].getId())) {
                    updateExtensionActivation = true;
                }
                ++i;
            }
            if (updateExtensionActivation) {
                this.contentService.getActivationService().activateExtensions(this.contentExtensionsToActivate, true);
                this.contentService.getActivationService().persistExtensionActivations();
                Object[] expandedElements = this.commonViewer.getExpandedElements();
                this.contentService.update();
                this.commonViewer.refresh();
                Object[] originalObjects = selection.toArray();
                this.commonViewer.setExpandedElements(expandedElements);
                StructuredSelection newSelection = new StructuredSelection(originalObjects);
                this.commonViewer.setSelection((ISelection)newSelection, true);
            }
        }
        finally {
            this.commonViewer.getControl().setRedraw(true);
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }
}

