/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.cmake.core.CMakeBuildConfiguration;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.core.build.CBuildConfigUtils;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;

public class CMakeBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.cmake.core.provider";

    public String getId() {
        return ID;
    }

    protected CMakeBuildConfiguration createCMakeBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        return new CMakeBuildConfiguration(config, name);
    }

    protected CMakeBuildConfiguration createCMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile, String launchMode, ILaunchTarget launchTarget) {
        return new CMakeBuildConfiguration(config, name, toolChain, toolChainFile, launchMode, launchTarget);
    }

    public synchronized ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        if (config.getName().equals("")) {
            return null;
        }
        CMakeBuildConfiguration cmakeConfig = this.createCMakeBuildConfiguration(config, name);
        ICMakeToolChainFile tcFile = cmakeConfig.getToolChainFile();
        IToolChain toolChain = cmakeConfig.getToolChain();
        if (toolChain == null) {
            return null;
        }
        if (tcFile != null && !toolChain.equals(tcFile.getToolChain())) {
            ILaunchTargetManager launchTargetManager = Activator.getService(ILaunchTargetManager.class);
            return this.createCMakeBuildConfiguration(config, name, tcFile.getToolChain(), tcFile, cmakeConfig.getLaunchMode(), launchTargetManager.getLocalLaunchTarget());
        }
        return cmakeConfig;
    }

    public ICBuildConfiguration createCBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, ILaunchTarget launchTarget, IProgressMonitor monitor) throws CoreException {
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        ICMakeToolChainFile file = manager.getToolChainFileFor(toolChain);
        if (file == null) {
            Collection<ICMakeToolChainFile> files;
            String arch;
            HashMap<String, String> properties = new HashMap<String, String>();
            String os = toolChain.getProperty("os");
            if (os != null && !os.isEmpty()) {
                properties.put("os", os);
            }
            if ((arch = toolChain.getProperty("arch")) != null && !arch.isEmpty()) {
                properties.put("arch", arch);
            }
            if (!(files = manager.getToolChainFilesMatching(properties)).isEmpty()) {
                file = files.iterator().next();
            }
        }
        String cBuildConfigName = this.getCBuildConfigName(project, "cmake", toolChain, launchMode, launchTarget);
        ICBuildConfigurationManager cBuildConfigManager = Activator.getService(ICBuildConfigurationManager.class);
        IBuildConfiguration buildConfig = CBuildConfigUtils.createBuildConfiguration((ICBuildConfigurationProvider)this, (IProject)project, (String)cBuildConfigName, (ICBuildConfigurationManager)cBuildConfigManager, (IProgressMonitor)monitor);
        CMakeBuildConfiguration cBuildConfig = this.createCMakeBuildConfiguration(buildConfig, cBuildConfigName, toolChain, file, launchMode, launchTarget);
        cBuildConfigManager.addBuildConfiguration(buildConfig, (ICBuildConfiguration)cBuildConfig);
        return cBuildConfig;
    }
}

