/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.BaseFormat;
import org.eclipse.jgit.archive.internal.ArchiveText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.revwalk.RevCommit;

public final class ZipFormat
extends BaseFormat
implements ArchiveCommand.Format<ArchiveOutputStream> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".zip"));

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) throws IOException {
        return this.createArchiveOutputStream(s, Collections.emptyMap());
    }

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s, Map<String, Object> o) throws IOException {
        ZipArchiveOutputStream out = new ZipArchiveOutputStream(s);
        int compressionLevel = this.getCompressionLevel(o);
        if (compressionLevel != -1) {
            out.setLevel(compressionLevel);
        }
        return this.applyFormatOptions((ArchiveOutputStream<? extends ArchiveEntry>)out, o);
    }

    public void putEntry(ArchiveOutputStream out, ObjectId tree, String path, FileMode mode, ObjectLoader loader) throws IOException {
        if (((String)path).endsWith("/") && mode != FileMode.TREE) {
            throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().pathDoesNotMatchMode, path, mode));
        }
        if (!((String)path).endsWith("/") && mode == FileMode.TREE) {
            path = (String)path + "/";
        }
        ZipArchiveEntry entry = new ZipArchiveEntry((String)path);
        if (tree instanceof RevCommit) {
            long t = (long)((RevCommit)tree).getCommitTime() * 1000L;
            entry.setTime(t);
        }
        if (mode == FileMode.TREE) {
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            return;
        }
        if (mode != FileMode.REGULAR_FILE) {
            if (mode == FileMode.EXECUTABLE_FILE || mode == FileMode.SYMLINK) {
                entry.setUnixMode(mode.getBits());
            } else {
                throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().unsupportedMode, mode));
            }
        }
        entry.setSize(loader.getSize());
        out.putArchiveEntry((ArchiveEntry)entry);
        loader.copyTo((OutputStream)out);
        out.closeArchiveEntry();
    }

    public Iterable<String> suffixes() {
        return SUFFIXES;
    }

    public boolean equals(Object other) {
        return other instanceof ZipFormat;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

