/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.debug.core.model.IMemoryBlockAddressInfoRetrieval;
import org.eclipse.cdt.debug.ui.memory.traditional.AbstractPane;
import org.eclipse.cdt.debug.ui.memory.traditional.AddressPane;
import org.eclipse.cdt.debug.ui.memory.traditional.DataPane;
import org.eclipse.cdt.debug.ui.memory.traditional.IMemorySelection;
import org.eclipse.cdt.debug.ui.memory.traditional.IViewportCache;
import org.eclipse.cdt.debug.ui.memory.traditional.TextPane;
import org.eclipse.cdt.debug.ui.memory.traditional.TraceOptions;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalMemoryByte;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

public class Rendering
extends Composite
implements IDebugEventSetListener {
    private TraditionalRendering fParent;
    protected AddressPane fAddressPane;
    protected DataPane fBinaryPane;
    protected TextPane fTextPane;
    private GoToAddressComposite fAddressBar;
    protected Control fAddressBarControl;
    private Selection fSelection = new Selection();
    BigInteger fViewportAddress = null;
    BigInteger fMemoryBlockStartAddress = null;
    BigInteger fMemoryBlockEndAddress = null;
    protected BigInteger fBaseAddress = null;
    protected int fColumnCount = 0;
    protected int fBytesPerRow = 0;
    private int fCurrentScrollSelection = 0;
    private BigInteger fCaretAddress;
    private int fTextMode = 1;
    private int fBytesPerColumn = 4;
    private int fRadix = 1;
    private int fColumnsSetting = 0;
    private boolean fIsTargetLittleEndian = false;
    private boolean fIsDisplayLittleEndian = false;
    public static final int RADIX_HEX = 1;
    public static final int RADIX_DECIMAL_SIGNED = 2;
    public static final int RADIX_DECIMAL_UNSIGNED = 3;
    public static final int RADIX_OCTAL = 4;
    public static final int RADIX_BINARY = 5;
    public static final int PANE_ADDRESS = 1;
    public static final int PANE_BINARY = 2;
    public static final int PANE_TEXT = 3;
    public static final int TEXT_ISO_8859_1 = 1;
    public static final int TEXT_USASCII = 2;
    public static final int TEXT_UTF8 = 3;
    protected static final int TEXT_UTF16 = 4;
    public static final int COLUMNS_AUTO_SIZE_TO_FIT = 0;
    private int fCellPadding = 2;
    private int fPaneSpacing = 16;
    private String fPaddingString = "?";
    private boolean fCacheDirty = false;
    public static final int UPDATE_ALWAYS = 1;
    public static final int UPDATE_ON_BREAKPOINT = 2;
    public static final int UPDATE_MANUAL = 3;
    public int fUpdateMode = 1;
    protected final Map<BigInteger, List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>> fMapStartAddrToInfoItems = Collections.synchronizedMap(new HashMap());
    protected final Map<BigInteger, List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>> fMapAddrToInfoItems = Collections.synchronizedMap(new HashMap());
    static int suspendCount = 0;
    ViewportCache fViewportCache = new ViewportCache();
    private BigInteger fScrollStartAddress = BigInteger.ZERO;
    static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Rendering(Composite parent, TraditionalRendering renderingParent) {
        super(parent, 537133824);
        this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
        this.fParent = renderingParent;
        if (this.fParent.getMemoryBlock() != null) {
            BigInteger base = this.fParent.getBigBaseAddress();
            this.fViewportAddress = this.fParent.getMemoryBlockStartAddress();
            if (this.fViewportAddress == null) {
                this.fViewportAddress = base;
            } else {
                BigInteger blockEndAddr = this.fParent.getMemoryBlockEndAddress();
                if (base.compareTo(this.fViewportAddress) > 0 && (blockEndAddr == null || base.compareTo(blockEndAddr) < 0)) {
                    this.fViewportAddress = base;
                }
            }
            this.fBaseAddress = this.fViewportAddress;
        }
        this.fAddressPane = this.createAddressPane();
        this.fBinaryPane = this.createDataPane();
        this.fTextPane = this.createTextPane();
        this.fAddressBar = new GoToAddressComposite();
        this.fAddressBarControl = this.fAddressBar.createControl(parent);
        Button button = this.fAddressBar.getButton(0);
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Rendering.this.doGoToAddress();
                }
            });
            button = this.fAddressBar.getButton(1);
            if (button != null) {
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Rendering.this.setVisibleAddressBar(false);
                    }
                });
            }
        }
        this.fAddressBar.getExpressionWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Rendering.this.doGoToAddress();
            }
        });
        this.fAddressBar.getExpressionWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    Rendering.this.setVisibleAddressBar(false);
                }
                super.keyPressed(e);
            }
        });
        this.fAddressBarControl.setVisible(false);
        this.getHorizontalBar().addSelectionListener(this.createHorizontalBarSelectionListener());
        this.getVerticalBar().addSelectionListener(this.createVerticalBarSelectinListener());
        this.addPaintListener(pe -> {
            pe.gc.setBackground(this.getTraditionalRendering().getColorBackground());
            pe.gc.fillRectangle(0, 0, this.getBounds().width, this.getBounds().height);
        });
        this.setLayout();
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent ce) {
            }

            public void controlResized(ControlEvent ce) {
                Rendering.this.packColumns();
            }
        });
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    protected void setLayout() {
        this.setLayout(new Layout(){

            public void layout(Composite composite, boolean changed) {
                int xOffset = 0;
                if (Rendering.this.getHorizontalBar().isVisible()) {
                    xOffset = Rendering.this.getHorizontalBar().getSelection();
                }
                int x = xOffset * -1;
                int y = 0;
                if (Rendering.this.fAddressBarControl.isVisible()) {
                    Rendering.this.fAddressBarControl.setBounds(0, 0, Rendering.this.getBounds().width, Rendering.this.fAddressBarControl.computeSize((int)100, (int)30).y);
                }
                if (Rendering.this.fAddressPane.isPaneVisible()) {
                    Rendering.this.fAddressPane.setBounds(x, y, Rendering.this.fAddressPane.computeSize((int)0, (int)0).x, Rendering.this.getBounds().height - y);
                    x = Rendering.this.fAddressPane.getBounds().x + Rendering.this.fAddressPane.getBounds().width;
                }
                if (Rendering.this.fBinaryPane.isPaneVisible()) {
                    Rendering.this.fBinaryPane.setBounds(x, y, Rendering.this.fBinaryPane.computeSize((int)0, (int)0).x, Rendering.this.getBounds().height - y);
                    x = Rendering.this.fBinaryPane.getBounds().x + Rendering.this.fBinaryPane.getBounds().width;
                }
                if (Rendering.this.fTextPane.isPaneVisible()) {
                    Rendering.this.fTextPane.setBounds(x, y, Math.max(Rendering.this.fTextPane.computeSize((int)0, (int)0).x, Rendering.this.getClientArea().width - x - xOffset), Rendering.this.getBounds().height - y);
                }
                if (Rendering.this.getClientArea().width >= Rendering.this.fTextPane.getBounds().x + Rendering.this.fTextPane.getBounds().width + xOffset) {
                    Rendering.this.getHorizontalBar().setVisible(false);
                } else {
                    ScrollBar horizontal = Rendering.this.getHorizontalBar();
                    horizontal.setVisible(true);
                    horizontal.setMinimum(0);
                    horizontal.setMaximum(Rendering.this.fTextPane.getBounds().x + Rendering.this.fTextPane.getBounds().width + xOffset);
                    horizontal.setThumb(Rendering.this.getClientArea().width);
                    horizontal.setPageIncrement(40);
                    horizontal.setIncrement(20);
                }
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(100, 100);
            }
        });
    }

    protected void handleDownArrow() {
        this.fViewportAddress = this.fViewportAddress.add(BigInteger.valueOf(this.getAddressableCellsPerRow()));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected void handleUpArrow() {
        this.fViewportAddress = this.fViewportAddress.subtract(BigInteger.valueOf(this.getAddressableCellsPerRow()));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected void handlePageDown() {
        this.fViewportAddress = this.fViewportAddress.add(BigInteger.valueOf(this.getAddressableCellsPerRow() * (this.getRowCount() - 1)));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected void handlePageUp() {
        this.fViewportAddress = this.fViewportAddress.subtract(BigInteger.valueOf(this.getAddressableCellsPerRow() * (this.getRowCount() - 1)));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected SelectionListener createHorizontalBarSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                Rendering.this.layout();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        };
    }

    protected SelectionListener createVerticalBarSelectinListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                switch (se.detail) {
                    case 0x1000002: {
                        Rendering.this.handleDownArrow();
                        break;
                    }
                    case 0x1000006: {
                        Rendering.this.handlePageDown();
                        break;
                    }
                    case 0x1000001: {
                        Rendering.this.handleUpArrow();
                        break;
                    }
                    case 0x1000005: {
                        Rendering.this.handlePageUp();
                        break;
                    }
                    default: {
                        int deltaScroll = Rendering.this.getVerticalBar().getSelection() - Rendering.this.fCurrentScrollSelection;
                        if (deltaScroll == 0) break;
                        Rendering.this.fViewportAddress = Rendering.this.fViewportAddress.add(BigInteger.valueOf(Rendering.this.getAddressableCellsPerRow()).multiply(BigInteger.valueOf(deltaScroll)));
                        Rendering.this.ensureViewportAddressDisplayable();
                        if (Rendering.this.fAddressPane.isPaneVisible()) {
                            Rendering.this.fAddressPane.redraw();
                        }
                        Rendering.this.redrawPanes();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        };
    }

    protected AddressPane createAddressPane() {
        return new AddressPane(this);
    }

    protected DataPane createDataPane() {
        return new DataPane(this);
    }

    protected TextPane createTextPane() {
        return new TextPane(this);
    }

    public TraditionalRendering getTraditionalRendering() {
        return this.fParent;
    }

    protected void setCaretAddress(BigInteger address) {
        this.fCaretAddress = address;
    }

    protected BigInteger getCaretAddress() {
        return this.fCaretAddress != null ? this.fCaretAddress : this.fViewportAddress;
    }

    private void doGoToAddress() {
        try {
            BigInteger address = this.fAddressBar.getGoToAddress(this.getMemoryBlockStartAddress(), this.getCaretAddress());
            this.getTraditionalRendering().gotoAddress(address);
            this.setVisibleAddressBar(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void ensureViewportAddressDisplayable() {
        if (this.fViewportAddress.compareTo(this.getMemoryBlockStartAddress()) < 0) {
            this.fViewportAddress = this.getMemoryBlockStartAddress();
        } else if (this.getViewportEndAddress().compareTo(this.getMemoryBlockEndAddress().add(BigInteger.ONE)) > 0) {
            this.fViewportAddress = this.getMemoryBlockEndAddress().subtract(BigInteger.valueOf(this.getAddressableCellsPerRow() * this.getRowCount() - 1));
        }
        this.setCurrentScrollSelection();
    }

    public IMemorySelection getSelection() {
        return this.fSelection;
    }

    protected int getHistoryDepth() {
        return this.fViewportCache.getHistoryDepth();
    }

    protected void setHistoryDepth(int depth) {
        this.fViewportCache.setHistoryDepth(depth);
    }

    public void logError(String message, Exception e) {
        Status status = new Status(4, this.fParent.getRenderingId(), 5013, message, (Throwable)e);
        TraditionalRenderingPlugin.getDefault().getLog().log((IStatus)status);
    }

    public void handleFontPreferenceChange(Font font) {
        this.setFont(font);
        AbstractPane[] controls = this.getRenderingPanes();
        int i = 0;
        while (i < controls.length) {
            controls[i].setFont(font);
            ++i;
        }
        this.packColumns();
        this.layout(true);
    }

    public void setPaddingString(String padding) {
        this.fPaddingString = padding;
        this.refresh();
    }

    public char getPaddingCharacter() {
        return this.fPaddingString.charAt(0);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        boolean isChangeOnly = false;
        boolean isSuspend = false;
        boolean isBreakpointHit = false;
        int i = 0;
        while (i < events.length) {
            if (events[0].getSource() instanceof IDebugElement) {
                int kind = events[i].getKind();
                int detail = events[i].getDetail();
                IDebugElement source = (IDebugElement)events[i].getSource();
                if (source.getDebugTarget() == this.getMemoryBlock().getDebugTarget() && (source.getDebugTarget() != null || source.equals(this.getMemoryBlock()))) {
                    if ((detail & 0x10) != 0) {
                        isBreakpointHit = true;
                    }
                    if (kind == 2) {
                        this.handleSuspendEvent(detail);
                        isSuspend = true;
                    } else if (kind == 16) {
                        this.handleChangeEvent();
                        isChangeOnly = true;
                    }
                }
            }
            ++i;
        }
        if (isSuspend) {
            this.handleSuspend(isBreakpointHit);
        } else if (isChangeOnly) {
            this.handleChange();
        }
    }

    protected void handleSuspend(boolean isBreakpointHit) {
        if (this.getUpdateMode() == 1 || this.getUpdateMode() == 2 && isBreakpointHit) {
            Display.getDefault().asyncExec(() -> {
                this.archiveDeltas();
                this.refresh();
            });
        }
    }

    protected void handleChange() {
        if (this.getUpdateMode() == 1) {
            Display.getDefault().asyncExec(() -> {
                this.archiveDeltas();
                this.refresh();
            });
        }
    }

    protected void handleSuspendEvent(int detail) {
    }

    protected void handleChangeEvent() {
    }

    public boolean isDebug() {
        return false;
    }

    protected IMemoryBlockExtension getMemoryBlock() {
        IMemoryBlock block = this.fParent.getMemoryBlock();
        if (block != null) {
            return (IMemoryBlockExtension)block.getAdapter(IMemoryBlockExtension.class);
        }
        return null;
    }

    public BigInteger getBigBaseAddress() {
        return this.fParent.getBigBaseAddress();
    }

    public int getAddressableSize() {
        return this.fParent.getAddressableSize();
    }

    protected IViewportCache getViewportCache() {
        return this.fViewportCache;
    }

    public TraditionalMemoryByte[] getBytes(BigInteger address, int bytes) throws DebugException {
        return this.getViewportCache().getBytes(address, bytes);
    }

    public void setVisibleAddressBar(boolean visible) {
        this.fAddressBarControl.setVisible(visible);
        if (visible) {
            String selectedStr = "0x" + this.getCaretAddress().toString(16);
            Text text = this.fAddressBar.getExpressionWidget();
            text.setText(selectedStr);
            text.setSelection(0, text.getCharCount());
            this.fAddressBar.getExpressionWidget().setFocus();
        }
        this.layout(true);
        this.layoutPanes();
    }

    public void setDirty(boolean needRefresh) {
        this.fCacheDirty = needRefresh;
    }

    public boolean isDirty() {
        return this.fCacheDirty;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.fViewportCache != null) {
            this.fViewportCache.dispose();
            this.fViewportCache = null;
        }
        this.fMapStartAddrToInfoItems.clear();
        this.fMapAddrToInfoItems.clear();
        super.dispose();
    }

    public void setPaneVisible(int pane, boolean visible) {
        switch (pane) {
            case 1: {
                this.fAddressPane.setPaneVisible(visible);
                break;
            }
            case 2: {
                this.fBinaryPane.setPaneVisible(visible);
                break;
            }
            case 3: {
                this.fTextPane.setPaneVisible(visible);
            }
        }
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public boolean getPaneVisible(int pane) {
        switch (pane) {
            case 1: {
                return this.fAddressPane.isPaneVisible();
            }
            case 2: {
                return this.fBinaryPane.isPaneVisible();
            }
            case 3: {
                return this.fTextPane.isPaneVisible();
            }
        }
        return false;
    }

    protected void packColumns() {
        int availableWidth = this.getSize().x;
        if (this.fAddressPane.isPaneVisible()) {
            availableWidth -= this.fAddressPane.computeSize((int)0, (int)0).x;
            availableWidth -= this.getRenderSpacing() * 2;
        }
        int combinedWidth = 0;
        if (this.fBinaryPane.isPaneVisible()) {
            combinedWidth += this.fBinaryPane.getCellWidth();
        }
        if (this.fTextPane.isPaneVisible()) {
            combinedWidth += this.fTextPane.getCellWidth();
        }
        if (this.getColumnsSetting() == 0) {
            if (combinedWidth == 0) {
                this.fColumnCount = 0;
            } else {
                this.fColumnCount = availableWidth / combinedWidth;
                if (this.fColumnCount == 0) {
                    this.fColumnCount = 1;
                }
            }
        } else {
            this.fColumnCount = this.getColumnsSetting();
        }
        try {
            this.fBytesPerRow = this.getBytesPerColumn() * this.getColumnCount();
            this.getVerticalBar().setMinimum(1);
            this.getVerticalBar().setMaximum(this.getMaxScrollLines());
            this.getVerticalBar().setIncrement(1);
            this.getVerticalBar().setPageIncrement(this.getRowCount() - 1);
            this.setCurrentScrollSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.redraw();
        this.redrawPanes();
    }

    public AbstractPane[] getRenderingPanes() {
        return new AbstractPane[]{this.fAddressPane, this.fBinaryPane, this.fTextPane};
    }

    public int getCellPadding() {
        return this.fCellPadding;
    }

    protected int getRenderSpacing() {
        return this.fPaneSpacing;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            if (this.isVisible() && this.getViewportCache() != null) {
                this.getViewportCache().refresh();
            } else {
                this.setDirty(true);
                this.fParent.updateRenderingLabels();
            }
        }
    }

    protected void archiveDeltas() {
        this.getViewportCache().archiveDeltas();
    }

    public void gotoAddress(BigInteger address) {
        if (address.compareTo(this.getMemoryBlockStartAddress()) < 0 || address.compareTo(this.getMemoryBlockEndAddress()) > 0) {
            return;
        }
        this.fViewportAddress = address;
        this.fCaretAddress = null;
        this.fSelection = new Selection();
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    public void setViewportStartAddress(BigInteger newAddress) {
        this.fViewportAddress = newAddress;
    }

    public BigInteger getViewportStartAddress() {
        return this.fViewportAddress;
    }

    public BigInteger getViewportEndAddress() {
        return this.fViewportAddress.add(BigInteger.valueOf(this.getBytesPerRow() * this.getRowCount() / this.getAddressableSize()));
    }

    private BigInteger getScrollStartAddress() {
        return this.fScrollStartAddress;
    }

    private void setScrollStartAddress(BigInteger newAddress) {
        this.fScrollStartAddress = newAddress;
    }

    private BigInteger getScrollEndAddress() {
        int scrollLines = this.getMaxScrollLines();
        BigInteger newAddress = this.getScrollStartAddress().add(BigInteger.valueOf(this.getAddressableCellsPerRow()).multiply(BigInteger.valueOf(scrollLines -= this.getVerticalBar().getThumb())));
        return newAddress.min(this.getMemoryBlockEndAddress());
    }

    public String getAddressString(BigInteger address) {
        StringBuilder addressString = new StringBuilder(address.toString(16).toUpperCase());
        int chars = this.getAddressBytes() * 2 - addressString.length();
        while (chars > 0) {
            addressString.insert(0, '0');
            --chars;
        }
        addressString.insert(0, "0x");
        return addressString.toString();
    }

    protected int getAddressBytes() {
        return this.fParent.getAddressSize();
    }

    public Control getAddressBarControl() {
        return this.fAddressBarControl;
    }

    public int getColumnCount() {
        return this.fColumnCount;
    }

    public int getColumnsSetting() {
        return this.fColumnsSetting;
    }

    protected void setBytesPerRow(int count) {
        this.fBytesPerRow = count;
    }

    protected void setColumnCount(int count) {
        this.fColumnCount = count;
    }

    public void setColumnsSetting(int columns) {
        if (this.fColumnsSetting != columns) {
            this.fColumnsSetting = columns;
            this.fireSettingsChanged();
            this.layoutPanes();
        }
    }

    protected void ensureVisible(BigInteger address) {
        boolean isAddressAfterViewportEnd;
        BigInteger viewportStart = this.getViewportStartAddress();
        BigInteger viewportEnd = this.getViewportEndAddress();
        boolean isAddressBeforeViewportStart = address.compareTo(viewportStart) < 0;
        boolean bl = isAddressAfterViewportEnd = address.compareTo(viewportEnd) > 0;
        if (isAddressBeforeViewportStart || isAddressAfterViewportEnd) {
            this.gotoAddress(address);
        }
    }

    protected int getRowCount() {
        int rowCount = 0;
        AbstractPane[] panes = this.getRenderingPanes();
        int i = 0;
        while (i < panes.length) {
            if (panes[i] instanceof AbstractPane) {
                rowCount = Math.max(rowCount, panes[i].getRowCount());
            }
            ++i;
        }
        int extra = 1;
        return rowCount + extra;
    }

    public int getBytesPerColumn() {
        return this.fBytesPerColumn;
    }

    protected int getBytesPerRow() {
        return this.fBytesPerRow;
    }

    protected int getAddressableCellsPerRow() {
        return this.getBytesPerRow() / this.getAddressableSize();
    }

    public int getAddressesPerColumn() {
        return this.getBytesPerColumn() / this.getAddressableSize();
    }

    protected void setCurrentScrollSelection() {
        BigInteger viewportStartAddress = this.getViewportStartAddress();
        if (TraceOptions.DEBUG) {
            TraceOptions.trace(MessageFormat.format("Update scroll for viewrange[0x{0} : 0x{1}]:\n", viewportStartAddress.toString(16), this.getViewportEndAddress().toString(16)));
            TraceOptions.trace(MessageFormat.format("  current ScrollRange=[0x{0} : 0x{1}]; selection = {2}\n", this.getScrollStartAddress().toString(16), this.getScrollEndAddress().toString(16), this.fCurrentScrollSelection));
        }
        BigInteger addressableRow = BigInteger.valueOf(this.getAddressableCellsPerRow());
        if (viewportStartAddress.compareTo(this.getScrollStartAddress()) <= 0) {
            int scrollLines = this.getMaxScrollLines() / 2;
            BigInteger newScrollStart = BigInteger.ZERO.max(viewportStartAddress.subtract(BigInteger.valueOf(scrollLines).multiply(addressableRow)));
            this.setScrollStartAddress(newScrollStart);
            if (TraceOptions.DEBUG) {
                TraceOptions.trace(MessageFormat.format("  new ScrollRange=[0x{0} : 0x{1}]\n", this.getScrollStartAddress().toString(16), this.getScrollEndAddress().toString(16)));
            }
        } else if (this.getViewportEndAddress().compareTo(this.getScrollEndAddress()) >= 0) {
            BigInteger eomScrollStart = this.getMemoryBlockEndAddress().add(BigInteger.ONE).subtract(BigInteger.valueOf(this.getMaxScrollLines() - this.getVerticalBar().getThumb()).multiply(addressableRow));
            int scrollLines = this.getMaxScrollLines() / 2;
            BigInteger newScrollStart = eomScrollStart.min(viewportStartAddress.subtract(BigInteger.valueOf(scrollLines).multiply(addressableRow)));
            this.setScrollStartAddress(newScrollStart);
            if (TraceOptions.DEBUG) {
                TraceOptions.trace(MessageFormat.format("  new ScrollRange=[0x{0} : 0x{1}]\n", this.getScrollStartAddress().toString(16), this.getScrollEndAddress().toString(16)));
            }
        }
        this.fCurrentScrollSelection = viewportStartAddress.subtract(this.getScrollStartAddress()).divide(addressableRow).intValue() + 1;
        if (TraceOptions.DEBUG) {
            TraceOptions.trace(MessageFormat.format("  new selection={0}\n", this.fCurrentScrollSelection));
        }
        this.getVerticalBar().setSelection(this.fCurrentScrollSelection);
    }

    private int getMaxScrollLines() {
        BigInteger difference = this.getMemoryBlockEndAddress().subtract(this.getMemoryBlockStartAddress()).add(BigInteger.ONE);
        BigInteger maxScrollRange = difference.divide(BigInteger.valueOf(this.getAddressableCellsPerRow()));
        if (maxScrollRange.multiply(BigInteger.valueOf(this.getAddressableCellsPerRow())).compareTo(difference) != 0) {
            maxScrollRange = maxScrollRange.add(BigInteger.ONE);
        }
        maxScrollRange = maxScrollRange.divide(BigInteger.valueOf(this.getAddressableSize()));
        return maxScrollRange.min(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
    }

    protected BigInteger getMemoryBlockStartAddress() {
        if (this.fMemoryBlockStartAddress == null) {
            this.fMemoryBlockStartAddress = this.fParent.getMemoryBlockStartAddress();
        }
        if (this.fMemoryBlockStartAddress == null) {
            this.fMemoryBlockStartAddress = BigInteger.ZERO;
        }
        return this.fMemoryBlockStartAddress;
    }

    protected BigInteger getMemoryBlockEndAddress() {
        if (this.fMemoryBlockEndAddress == null) {
            this.fMemoryBlockEndAddress = this.fParent.getMemoryBlockEndAddress();
        }
        return this.fMemoryBlockEndAddress;
    }

    public int getRadix() {
        return this.fRadix;
    }

    protected int getNumericRadix(int radix) {
        switch (radix) {
            case 5: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 2: 
            case 3: {
                return 10;
            }
            case 1: {
                return 16;
            }
        }
        return -1;
    }

    public void setRadix(int mode) {
        if (this.fRadix == mode) {
            return;
        }
        this.fRadix = mode;
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public void setTextMode(int mode) {
        this.fTextMode = mode;
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public int getTextMode() {
        return this.fTextMode;
    }

    public int getUpdateMode() {
        return this.fUpdateMode;
    }

    public void setUpdateMode(int fUpdateMode) {
        this.fUpdateMode = fUpdateMode;
    }

    protected String getCharacterSet(int mode) {
        switch (mode) {
            case 3: {
                return "UTF8";
            }
            case 4: {
                return "UTF16";
            }
            case 2: {
                return "US-ASCII";
            }
        }
        return "ISO-8859-1";
    }

    public int getBytesPerCharacter() {
        if (this.fTextMode == 4) {
            return 2;
        }
        return 1;
    }

    public boolean isTargetLittleEndian() {
        return this.fIsTargetLittleEndian;
    }

    public void setTargetLittleEndian(boolean littleEndian) {
        if (this.fIsTargetLittleEndian == littleEndian) {
            return;
        }
        this.fParent.setTargetMemoryLittleEndian(littleEndian);
        this.fIsTargetLittleEndian = littleEndian;
        Display.getDefault().asyncExec(() -> {
            this.fireSettingsChanged();
            this.layoutPanes();
        });
    }

    public boolean isDisplayLittleEndian() {
        return this.fIsDisplayLittleEndian;
    }

    public void setDisplayLittleEndian(boolean littleEndian) {
        if (this.fIsDisplayLittleEndian == littleEndian) {
            return;
        }
        this.fIsDisplayLittleEndian = littleEndian;
        this.fireSettingsChanged();
        Display.getDefault().asyncExec(() -> {
            if (this.isShowCrossReferenceInfo()) {
                this.resolveAddressInfoForCurrentSelection();
            }
            this.layoutPanes();
        });
    }

    public void setBytesPerColumn(int byteCount) {
        if (this.fBytesPerColumn != byteCount) {
            this.fBytesPerColumn = byteCount;
            this.fireSettingsChanged();
            this.layoutPanes();
        }
    }

    protected void redrawPane(int paneId) {
        if (!this.isDisposed() && this.isVisible()) {
            AbstractPane pane = null;
            if (paneId == 1) {
                pane = this.fAddressPane;
            } else if (paneId == 2) {
                pane = this.fBinaryPane;
            }
            if (paneId == 3) {
                pane = this.fTextPane;
            }
            if (pane != null && pane.isPaneVisible()) {
                pane.redraw();
                pane.setRowCount();
                if (pane.isFocusControl()) {
                    pane.updateCaret();
                }
            }
        }
        this.fParent.updateRenderingLabels();
    }

    protected void redrawPanes() {
        if (!this.isDisposed() && this.isVisible()) {
            if (this.fAddressPane.isPaneVisible()) {
                this.fAddressPane.redraw();
                this.fAddressPane.setRowCount();
                if (this.fAddressPane.isFocusControl()) {
                    this.fAddressPane.updateCaret();
                }
            }
            if (this.fBinaryPane.isPaneVisible()) {
                this.fBinaryPane.redraw();
                this.fBinaryPane.setRowCount();
                if (this.fBinaryPane.isFocusControl()) {
                    this.fBinaryPane.updateCaret();
                }
            }
            if (this.fTextPane.isPaneVisible()) {
                this.fTextPane.redraw();
                this.fTextPane.setRowCount();
                if (this.fTextPane.isFocusControl()) {
                    this.fTextPane.updateCaret();
                }
            }
        }
        this.fParent.updateRenderingLabels();
    }

    private void layoutPanes() {
        this.packColumns();
        this.layout(true);
        this.redraw();
        this.redrawPanes();
    }

    private void fireSettingsChanged() {
        this.fAddressPane.settingsChanged();
        this.fBinaryPane.settingsChanged();
        this.fTextPane.settingsChanged();
    }

    protected void copyAddressToClipboard() {
        Clipboard clip = null;
        try {
            clip = new Clipboard(this.getDisplay());
            String addressString = "0x" + this.getCaretAddress().toString(16);
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            clip.setContents(new Object[]{addressString}, new Transfer[]{plainTextTransfer});
        }
        finally {
            if (clip != null) {
                clip.dispose();
            }
        }
    }

    public String getRadixText(MemoryByte[] bytes, int radix, boolean isLittleEndian) {
        boolean readableByte = false;
        boolean allBytesReadable = true;
        int i = 0;
        while (i < bytes.length) {
            if (!bytes[i].isReadable()) {
                allBytesReadable = false;
            } else {
                readableByte = true;
            }
            ++i;
        }
        if (allBytesReadable || readableByte && (radix == 1 || radix == 5)) {
            boolean needsSwap = false;
            if (this.isDisplayLittleEndian()) {
                needsSwap = true;
            }
            switch (radix) {
                case 1: 
                case 4: 
                case 5: {
                    long value = 0L;
                    if (needsSwap) {
                        i = 0;
                        while (i < bytes.length) {
                            value <<= 8;
                            value |= (long)(bytes[bytes.length - 1 - i].getValue() & 0xFF);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < bytes.length) {
                            value <<= 8;
                            value |= (long)(bytes[i].getValue() & 0xFF);
                            ++i;
                        }
                    }
                    char[] buf = new char[this.getRadixCharacterCount(radix, bytes.length)];
                    switch (radix) {
                        case 5: {
                            int i2 = buf.length - 1;
                            while (i2 >= 0) {
                                int byteIndex = needsSwap ? bytes.length - 1 - i2 / 8 : i2 / 8;
                                buf[i2] = bytes[byteIndex].isReadable() ? hexdigits[(int)(value & 1L)] : this.getPaddingCharacter();
                                value >>>= 1;
                                --i2;
                            }
                            break;
                        }
                        case 4: {
                            int i3 = buf.length - 1;
                            while (i3 >= 0) {
                                buf[i3] = hexdigits[(int)(value & 7L)];
                                value >>>= 3;
                                --i3;
                            }
                            break;
                        }
                        case 1: {
                            int i4 = buf.length - 1;
                            while (i4 >= 0) {
                                int byteIndex = needsSwap ? bytes.length - 1 - i4 / 2 : i4 / 2;
                                buf[i4] = bytes[byteIndex].isReadable() ? hexdigits[(int)(value & 0xFL)] : this.getPaddingCharacter();
                                value >>>= 4;
                                --i4;
                            }
                            break;
                        }
                    }
                    return new String(buf);
                }
                case 2: 
                case 3: {
                    BigInteger bigValue;
                    boolean isSignedType = radix == 2;
                    int textWidth = this.getRadixCharacterCount(radix, bytes.length);
                    char[] buf = new char[textWidth];
                    byte[] value = new byte[bytes.length + 1];
                    if (needsSwap) {
                        i = 0;
                        while (i < bytes.length) {
                            value[bytes.length - i] = bytes[i].getValue();
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < bytes.length) {
                            value[i + 1] = bytes[i].getValue();
                            ++i;
                        }
                    }
                    boolean isNegative = false;
                    if (isSignedType && (value[1] & 0x80) != 0) {
                        value[0] = -1;
                        isNegative = true;
                        bigValue = new BigInteger(value).abs();
                    } else {
                        value[0] = 0;
                        bigValue = new BigInteger(value);
                    }
                    int i5 = 0;
                    while (i5 < textWidth) {
                        BigInteger[] divideRemainder = bigValue.divideAndRemainder(BigInteger.valueOf(10L));
                        int remainder = divideRemainder[1].intValue();
                        buf[textWidth - 1 - i5] = hexdigits[remainder % 10];
                        bigValue = divideRemainder[0];
                        ++i5;
                    }
                    if (isSignedType) {
                        buf[0] = isNegative ? 45 : 32;
                    }
                    return new String(buf);
                }
            }
        }
        StringBuilder errorText = new StringBuilder();
        int i6 = this.getRadixCharacterCount(radix, bytes.length);
        while (i6 > 0) {
            errorText.append(this.getPaddingCharacter());
            --i6;
        }
        return errorText.toString();
    }

    public int getRadixCharacterCount(int radix, int bytes) {
        switch (radix) {
            case 1: {
                return bytes * 2;
            }
            case 5: {
                return bytes * 8;
            }
            case 4: {
                switch (bytes) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 11;
                    }
                    case 8: {
                        return 22;
                    }
                }
            }
            case 3: {
                switch (bytes) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 10;
                    }
                    case 8: {
                        return 20;
                    }
                }
            }
            case 2: {
                switch (bytes) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 11;
                    }
                    case 8: {
                        return 21;
                    }
                }
            }
        }
        return 0;
    }

    protected static boolean isValidEditCharacter(char character) {
        return character >= '0' && character <= '9' || character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character == '-' || character == ' ';
    }

    /*
     * Unable to fully structure code
     */
    public String formatText(MemoryByte[] memoryBytes, boolean isLittleEndian, int textMode) {
        readable = true;
        i = 0;
        while (i < memoryBytes.length) {
            if (!memoryBytes[i].isReadable()) {
                readable = false;
            }
            ++i;
        }
        if (!readable) {
            errorText = new StringBuilder();
            i = memoryBytes.length;
            while (i > 0) {
                errorText.append(this.getPaddingCharacter());
                --i;
            }
            return errorText.toString();
        }
        bytes = new byte[memoryBytes.length];
        i = 0;
        while (i < bytes.length) {
            bytes[i] = memoryBytes[i].getValue();
            ++i;
        }
        if (textMode == 2) {
            i = 0;
            while (i < bytes.length) {
                byteValue = bytes[i];
                if (byteValue < 0) {
                    byteValue += 256;
                }
                if (byteValue < 32 || byteValue > 126) {
                    bytes[i] = 46;
                }
                ++i;
            }
        }
        if (textMode == 1) {
            i = 0;
            while (i < bytes.length) {
                byteValue = bytes[i];
                if (byteValue < 0) {
                    byteValue += 256;
                }
                if (byteValue < 32 || byteValue >= 127 && byteValue < 159) {
                    bytes[i] = 46;
                }
                ++i;
            }
        }
        try {
            buf = new StringBuilder(new String(bytes, this.getCharacterSet(textMode)));
            i = 0;
            while (i < memoryBytes.length - buf.length()) {
                buf.append(' ');
                ++i;
            }
            return buf.toString();
        }
        catch (Exception e) {
            buf = new StringBuilder();
            i = 0;
            ** while (i < memoryBytes.length - buf.length())
        }
lbl-1000:
        // 1 sources

        {
            buf.append(this.getPaddingCharacter());
            ++i;
            continue;
        }
lbl60:
        // 1 sources

        return buf.toString();
    }

    public AbstractPane incrPane(AbstractPane currentPane, int offset) {
        List<AbstractPane> panes = Arrays.asList(this.getRenderingPanes());
        return panes.get((panes.indexOf((Object)currentPane) + offset) % panes.size());
    }

    boolean hasVisibleRangeInfo() {
        return false;
    }

    boolean hasAddressInfo(BigInteger address) {
        return false;
    }

    Map<BigInteger, List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>> getVisibleValueToAddressInfoItems() {
        return this.fMapStartAddrToInfoItems;
    }

    protected boolean isShowCrossReferenceInfo() {
        IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        boolean prefShowInfo = store.getBoolean("memCrossReferenceInfo");
        return !this.isDisplayLittleEndian() && prefShowInfo;
    }

    String buildAddressInfoString(BigInteger address, String separator, boolean addTypeHeaders) {
        return "";
    }

    Action[] getDynamicActions() {
        return new Action[0];
    }

    void resolveAddressInfoForCurrentSelection() {
    }

    private static interface Request {
    }

    class Selection
    implements IMemorySelection {
        private BigInteger fStartHigh;
        private BigInteger fStartLow;
        private BigInteger fEndHigh;
        private BigInteger fEndLow;

        Selection() {
        }

        @Override
        public void clear() {
            this.fStartLow = null;
            this.fStartHigh = null;
            this.fEndLow = null;
            this.fEndHigh = null;
            Rendering.this.redrawPanes();
        }

        @Override
        public boolean hasSelection() {
            return this.fStartHigh != null && this.fStartLow != null && this.fEndHigh != null && this.fEndLow != null;
        }

        @Override
        public boolean isSelected(BigInteger address) {
            if (this.getEnd() == null || this.getStart() == null) {
                return false;
            }
            return this.getEnd().compareTo(this.getStart()) >= 0 ? address.compareTo(this.getStart()) >= 0 && address.compareTo(this.getEnd()) < 0 : this.getStart().compareTo(this.getEnd()) >= 0 && address.compareTo(this.getEnd()) >= 0 && address.compareTo(this.getStart()) < 0;
        }

        @Override
        public void setStart(BigInteger high, BigInteger low) {
            if (high == null && low == null) {
                if (this.fStartHigh != null && this.fStartLow != null) {
                    this.fStartHigh = null;
                    this.fStartLow = null;
                    Rendering.this.redrawPanes();
                }
                return;
            }
            boolean changed = false;
            if (this.fStartHigh == null || !this.fStartHigh.equals(high)) {
                this.fStartHigh = high;
                changed = true;
            }
            if (this.fStartLow == null || !low.equals(this.fStartLow)) {
                this.fStartLow = low;
                changed = true;
            }
            if (changed) {
                Rendering.this.redrawPanes();
            }
        }

        @Override
        public void setEnd(BigInteger high, BigInteger low) {
            if (high == null && low == null) {
                if (this.fEndHigh != null && this.fEndLow != null) {
                    this.fEndHigh = null;
                    this.fEndLow = null;
                    Rendering.this.redrawPanes();
                }
                return;
            }
            boolean changed = false;
            if (this.fEndHigh == null || !this.fEndHigh.equals(high)) {
                this.fEndHigh = high;
                changed = true;
            }
            if (this.fEndLow == null || !low.equals(this.fEndLow)) {
                this.fEndLow = low;
                changed = true;
            }
            if (changed) {
                Rendering.this.redrawPanes();
            }
        }

        @Override
        public BigInteger getHigh() {
            if (!this.hasSelection()) {
                return null;
            }
            return this.getStart().max(this.getEnd());
        }

        @Override
        public BigInteger getLow() {
            if (!this.hasSelection()) {
                return null;
            }
            return this.getStart().min(this.getEnd());
        }

        @Override
        public BigInteger getStart() {
            BigInteger differenceEndToStartLow;
            if (this.fStartHigh == null) {
                return null;
            }
            if (this.fEndHigh == null) {
                return this.fStartHigh;
            }
            if (this.fStartHigh.equals(this.fEndHigh) && this.fStartLow.equals(this.fEndLow)) {
                return this.fStartLow;
            }
            BigInteger differenceEndToStartHigh = this.fEndHigh.subtract(this.fStartHigh).abs();
            if (differenceEndToStartHigh.compareTo(differenceEndToStartLow = this.fEndHigh.subtract(this.fStartLow).abs()) > 0) {
                return this.fStartHigh;
            }
            return this.fStartLow;
        }

        @Override
        public BigInteger getStartLow() {
            return this.fStartLow;
        }

        @Override
        public BigInteger getEnd() {
            BigInteger differenceStartToEndLow;
            if (this.fEndHigh == null) {
                return null;
            }
            if (this.fStartHigh.equals(this.fEndHigh) && this.fStartLow.equals(this.fEndLow)) {
                return this.fStartHigh;
            }
            BigInteger differenceStartToEndHigh = this.fStartHigh.subtract(this.fEndHigh).abs();
            if (differenceStartToEndHigh.compareTo(differenceStartToEndLow = this.fStartHigh.subtract(this.fEndLow).abs()) >= 0) {
                return this.fEndHigh;
            }
            return this.fEndLow;
        }
    }

    class ViewportCache
    extends Thread
    implements IViewportCache {
        private HashMap<BigInteger, TraditionalMemoryByte[]> fEditBuffer = new HashMap();
        private boolean fDisposed = false;
        private Object fLastQueued = null;
        private Vector<Object> fQueue = new Vector();
        protected MemoryUnit fCache = null;
        protected MemoryUnit[] fHistoryCache = new MemoryUnit[0];
        protected int fHistoryDepth = 0;

        public ViewportCache() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            this.fDisposed = true;
            Vector<Object> vector = this.fQueue;
            synchronized (vector) {
                this.fQueue.notify();
            }
        }

        public int getHistoryDepth() {
            return this.fHistoryDepth;
        }

        public void setHistoryDepth(int depth) {
            this.fHistoryDepth = depth;
            this.fHistoryCache = new MemoryUnit[this.fHistoryDepth];
        }

        @Override
        public void refresh() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            if (this.fCache != null) {
                this.queueRequest(Rendering.this.fViewportAddress, Rendering.this.getViewportEndAddress());
            }
        }

        @Override
        public void archiveDeltas() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            if (this.fCache != null) {
                this.queueRequestArchiveDeltas();
            }
        }

        private void queueRequest(BigInteger startAddress, BigInteger endAddress) {
            AddressPair pair = new AddressPair(startAddress, endAddress);
            this.queue(pair);
        }

        private void queueRequestArchiveDeltas() {
            ArchiveDeltas archive = new ArchiveDeltas();
            this.queue(archive);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queue(Object element) {
            Vector<Object> vector = this.fQueue;
            synchronized (vector) {
                if (this.fQueue.size() <= 0 || !element.equals(this.fLastQueued)) {
                    this.fQueue.addElement(element);
                    this.fLastQueued = element;
                }
                this.fQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.fDisposed) {
                AddressPair pair = null;
                boolean archiveDeltas = false;
                Vector<Object> vector = this.fQueue;
                synchronized (vector) {
                    if (this.fQueue.size() > 0) {
                        Request request = (Request)this.fQueue.elementAt(0);
                        Class<?> type = request.getClass();
                        while (this.fQueue.size() > 0 && type.isInstance(this.fQueue.elementAt(0))) {
                            request = (Request)this.fQueue.elementAt(0);
                            this.fQueue.removeElementAt(0);
                        }
                        if (request instanceof ArchiveDeltas) {
                            archiveDeltas = true;
                        } else if (request instanceof AddressPair) {
                            pair = (AddressPair)request;
                        }
                    }
                }
                if (archiveDeltas) {
                    int i = Rendering.this.fViewportCache.getHistoryDepth() - 1;
                    while (i > 0) {
                        this.fHistoryCache[i] = this.fHistoryCache[i - 1];
                        --i;
                    }
                    this.fHistoryCache[0] = this.fCache.clone();
                    continue;
                }
                if (pair != null) {
                    this.populateCache(pair.startAddress, pair.endAddress);
                    continue;
                }
                vector = this.fQueue;
                synchronized (vector) {
                    try {
                        if (this.fQueue.isEmpty()) {
                            this.fQueue.wait();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void populateCache(BigInteger startAddress, BigInteger endAddress) {
            try {
                IMemoryBlockExtension memoryBlock = Rendering.this.getMemoryBlock();
                BigInteger addressableSize = BigInteger.valueOf(Rendering.this.getAddressableSize());
                BigInteger lengthInBytes = endAddress.subtract(startAddress).multiply(addressableSize);
                long units = lengthInBytes.divide(addressableSize).add(lengthInBytes.mod(addressableSize).compareTo(BigInteger.ZERO) > 0 ? BigInteger.ONE : BigInteger.ZERO).longValue();
                MemoryByte[] readBytes = memoryBlock.getBytesFromAddress(startAddress, units);
                TraditionalMemoryByte[] cachedBytes = new TraditionalMemoryByte[readBytes.length];
                int i = 0;
                while (i < readBytes.length) {
                    cachedBytes[i] = new TraditionalMemoryByte(readBytes[i].getValue(), readBytes[i].getFlags());
                    ++i;
                }
                if (cachedBytes.length > 0 && cachedBytes[0].isEndianessKnown()) {
                    Rendering.this.setTargetLittleEndian(!cachedBytes[0].isBigEndian());
                }
                if (Rendering.this.isTargetLittleEndian() && addressableSize.compareTo(BigInteger.ONE) != 0) {
                    int unitSize = addressableSize.intValue();
                    TraditionalMemoryByte[] cachedBytesAsByteSequence = new TraditionalMemoryByte[cachedBytes.length];
                    int unit = 0;
                    while ((long)unit < units) {
                        int unitbyte = 0;
                        while (unitbyte < unitSize) {
                            cachedBytesAsByteSequence[unit * unitSize + unitbyte] = cachedBytes[unit * unitSize + unitSize - unitbyte - 1];
                            ++unitbyte;
                        }
                        ++unit;
                    }
                    cachedBytes = cachedBytesAsByteSequence;
                }
                TraditionalMemoryByte[] cachedBytesFinal = cachedBytes;
                this.fCache = new MemoryUnit();
                this.fCache.start = startAddress;
                this.fCache.end = endAddress;
                this.fCache.bytes = cachedBytesFinal;
                Display.getDefault().asyncExec(() -> {
                    int historyIndex = 0;
                    while (historyIndex < this.getHistoryDepth()) {
                        if (this.fHistoryCache[historyIndex] != null && this.fHistoryCache[historyIndex].isValid()) {
                            BigInteger maxStart = startAddress.max(this.fHistoryCache[historyIndex].start);
                            BigInteger minEnd = endAddress.min(this.fHistoryCache[historyIndex].end).subtract(BigInteger.valueOf(1L));
                            BigInteger overlapLength = minEnd.subtract(maxStart).multiply(addressableSize);
                            if (overlapLength.compareTo(BigInteger.valueOf(0L)) > 0) {
                                int offsetIntoOld = maxStart.subtract(this.fHistoryCache[historyIndex].start).multiply(addressableSize).intValue();
                                int offsetIntoNew = maxStart.subtract(startAddress).multiply(addressableSize).intValue();
                                int i = overlapLength.intValue();
                                while (i >= 0) {
                                    cachedBytesFinal[offsetIntoNew + i].setChanged(historyIndex, cachedBytesFinal[offsetIntoNew + i].getValue() != this.fHistoryCache[historyIndex].bytes[offsetIntoOld + i].getValue());
                                    --i;
                                }
                            }
                        }
                        ++historyIndex;
                    }
                    if (this.fHistoryCache[0] == null) {
                        this.fHistoryCache[0] = this.fCache.clone();
                    }
                    Rendering.this.redrawPanes();
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public TraditionalMemoryByte[] getBytes(BigInteger address, int bytesRequested) throws DebugException {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            int rem = bytesRequested % Rendering.this.getAddressableSize() > 0 ? 1 : 0;
            int units = bytesRequested / Rendering.this.getAddressableSize() + rem;
            if (this.containsEditedCell(address)) {
                return this.getEditedMemory(address);
            }
            boolean contains = false;
            if (this.fCache != null && this.fCache.start != null) {
                BigInteger dataEnd = address.add(BigInteger.valueOf(units));
                if (this.fCache.start.compareTo(address) <= 0 && this.fCache.end.compareTo(dataEnd) >= 0 && this.fCache.bytes.length > 0) {
                    contains = true;
                }
            }
            if (contains) {
                int offset = address.subtract(this.fCache.start).multiply(BigInteger.valueOf(Rendering.this.getAddressableSize())).intValue();
                TraditionalMemoryByte[] bytes = new TraditionalMemoryByte[bytesRequested];
                int i = 0;
                while (i < bytes.length) {
                    bytes[i] = this.fCache.bytes[offset + i];
                    ++i;
                }
                return bytes;
            }
            TraditionalMemoryByte[] bytes = new TraditionalMemoryByte[bytesRequested];
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = new TraditionalMemoryByte();
                bytes[i].setReadable(false);
                ++i;
            }
            Rendering.this.fViewportCache.queueRequest(Rendering.this.fViewportAddress, Rendering.this.getViewportEndAddress());
            return bytes;
        }

        @Override
        public boolean containsEditedCell(BigInteger address) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            return this.fEditBuffer.containsKey(address);
        }

        private TraditionalMemoryByte[] getEditedMemory(BigInteger address) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            return this.fEditBuffer.get(address);
        }

        @Override
        public void clearEditBuffer() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            this.fEditBuffer.clear();
            Rendering.this.redrawPanes();
        }

        @Override
        public void writeEditBuffer() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            Set<BigInteger> keySet = this.fEditBuffer.keySet();
            for (BigInteger address : keySet) {
                TraditionalMemoryByte[] bytes = this.fEditBuffer.get(address);
                byte[] byteValue = new byte[bytes.length];
                int i = 0;
                while (i < bytes.length) {
                    byteValue[i] = bytes[i].getValue();
                    ++i;
                }
                try {
                    IMemoryBlockExtension block = Rendering.this.getMemoryBlock();
                    BigInteger offset = address.subtract(block.getBigBaseAddress());
                    block.setValue(offset, byteValue);
                }
                catch (Exception e) {
                    MemoryViewUtil.openError((String)TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_WRITE_MEMORY"), (String)"", (Exception)e);
                    Rendering.this.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_WRITE_MEMORY"), e);
                }
            }
            this.clearEditBuffer();
        }

        @Override
        public void setEditedValue(BigInteger address, TraditionalMemoryByte[] bytes) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            this.fEditBuffer.put(address, bytes);
            Rendering.this.redrawPanes();
        }

        class AddressPair
        implements Request {
            BigInteger startAddress;
            BigInteger endAddress;

            public AddressPair(BigInteger start, BigInteger end) {
                this.startAddress = start;
                this.endAddress = end;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof AddressPair) {
                    return ((AddressPair)obj).startAddress.equals(this.startAddress) && ((AddressPair)obj).endAddress.equals(this.endAddress);
                }
                return false;
            }
        }

        class ArchiveDeltas
        implements Request {
            ArchiveDeltas() {
            }
        }

        class MemoryUnit {
            BigInteger start;
            BigInteger end;
            TraditionalMemoryByte[] bytes;

            MemoryUnit() {
            }

            public MemoryUnit clone() {
                MemoryUnit b = new MemoryUnit();
                b.start = this.start;
                b.end = this.end;
                b.bytes = new TraditionalMemoryByte[this.bytes.length];
                int i = 0;
                while (i < this.bytes.length) {
                    b.bytes[i] = new TraditionalMemoryByte(this.bytes[i].getValue());
                    ++i;
                }
                return b;
            }

            public boolean isValid() {
                return this.start != null && this.end != null && this.bytes != null;
            }
        }
    }
}

