/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.util.Hashtable;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;

class TraceOptions
implements DebugOptionsListener {
    private static final String DEBUG_FLAG = "org.eclipse.cdt.debug.ui.memory.traditional/debug";
    public static boolean DEBUG = false;
    private static DebugTrace fgDebugTrace;
    private String pluginID;

    public TraceOptions(BundleContext context, String pluginID) {
        this.pluginID = pluginID;
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", pluginID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(DebugOptions options) {
        fgDebugTrace = options.newDebugTrace(this.pluginID);
        DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
    }

    public static void trace(String option, String message, Throwable throwable) {
        String systemPrintableMessage = message;
        while (systemPrintableMessage.length() > 100) {
            String partial = systemPrintableMessage.substring(0, 100);
            systemPrintableMessage = systemPrintableMessage.substring(100);
            System.out.println(partial + "\\");
        }
        System.out.print(systemPrintableMessage);
        if (fgDebugTrace != null) {
            fgDebugTrace.trace(option, message, throwable);
        }
    }

    public static void trace(String message) {
        TraceOptions.trace(null, message, null);
    }
}

