/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.util.HashMap;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.ConsoleMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.TracingConsole;
import org.eclipse.cdt.dsf.gdb.launching.ITracedLaunch;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class TracingConsoleManager
implements ILaunchesListener2,
IPropertyChangeListener {
    private static final int NUMBER_OF_CHARS_TO_DELETE = 100000;
    private static final int MIN_NUMBER_OF_CHARS_TO_KEEP = 5000;
    private boolean fTracingEnabled = false;
    private int fMaxNumCharacters = 500000;
    private int fMinNumCharacters = this.fMaxNumCharacters - 100000;
    private HashMap<ITracedLaunch, TracingConsole> fTracingConsoles = new HashMap();

    public void startup() {
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fTracingEnabled = store.getBoolean("tracesEnable");
        int maxChars = store.getInt("maxGdbTraces");
        this.setWaterMarks(maxChars);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.removeAllConsoles();
    }

    protected void toggleTracingVisibility(boolean visible) {
        if (visible) {
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(this.fTracingConsoles.values().toArray(new IConsole[this.fTracingConsoles.size()]));
        } else {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(this.fTracingConsoles.values().toArray(new IConsole[this.fTracingConsoles.size()]));
        }
    }

    protected void removeAllConsoles() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.removeConsole(launch);
            ++n2;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.addConsole(launch);
            ++n2;
        }
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.removeConsole(launch);
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.renameConsole(launch);
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("tracesEnable")) {
            this.fTracingEnabled = (Boolean)event.getNewValue();
            this.toggleTracingVisibility(this.fTracingEnabled);
        } else if (event.getProperty().equals("maxGdbTraces")) {
            int maxChars = (Integer)event.getNewValue();
            this.updateAllConsoleWaterMarks(maxChars);
        }
    }

    protected void addConsole(ILaunch launch) {
        if (launch instanceof ITracedLaunch && this.getConsole(launch) == null && !launch.isTerminated()) {
            TracingConsole console = new TracingConsole(launch, ConsoleMessages.ConsoleMessages_trace_console_name);
            console.initialize();
            console.setWaterMarks(this.fMinNumCharacters, this.fMaxNumCharacters);
            this.fTracingConsoles.put((ITracedLaunch)launch, console);
            if (this.fTracingEnabled) {
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
    }

    protected void removeConsole(ILaunch launch) {
        TracingConsole console = this.fTracingConsoles.remove(launch);
        if (console != null) {
            console.destroy();
            if (this.fTracingEnabled) {
                ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
            }
        }
    }

    protected void renameConsole(ILaunch launch) {
        TracingConsole console = this.getConsole(launch);
        if (console != null) {
            console.resetName();
        }
    }

    private TracingConsole getConsole(ILaunch launch) {
        return this.fTracingConsoles.get(launch);
    }

    protected void setWaterMarks(int maxChars) {
        if (maxChars < 10000) {
            maxChars = 10000;
        }
        this.fMaxNumCharacters = maxChars;
        this.fMinNumCharacters = maxChars < 105000 ? 5000 : maxChars - 100000;
    }

    protected void updateAllConsoleWaterMarks(int maxChars) {
        ILaunch[] launches;
        this.setWaterMarks(maxChars);
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.updateConsoleWaterMarks(launch);
            ++n2;
        }
    }

    protected void updateConsoleWaterMarks(ILaunch launch) {
        TracingConsole console = this.getConsole(launch);
        if (console != null) {
            console.setWaterMarks(this.fMinNumCharacters, this.fMaxNumCharacters);
        }
    }
}

