/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions;

import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.ITracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.TracepointActionManager;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions.MessagesForTracepointActions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TracepointActionsList
extends Composite {
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Table table;

    public TracepointActionsList(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        this.table = new Table((Composite)this, 67586);
        GridData gridData = new GridData(784);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracepointActionsList.this.updateButtons();
            }
        });
        TableColumn nameTableColumn = new TableColumn(this.table, 0);
        nameTableColumn.setWidth(120);
        nameTableColumn.setText(MessagesForTracepointActions.TracepointActions_Name);
        TableColumn typeTableColumn = new TableColumn(this.table, 0);
        typeTableColumn.setWidth(120);
        typeTableColumn.setText(MessagesForTracepointActions.TracepointActions_Type);
        TableColumn summaryTableColumn = new TableColumn(this.table, 0);
        summaryTableColumn.setWidth(120);
        summaryTableColumn.setText(MessagesForTracepointActions.TracepointActions_Summary);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText(MessagesForTracepointActions.TracepointActions_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracepointActionsList.this.HandleRemoveButton();
            }
        });
        this.upButton = new Button((Composite)this, 0);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracepointActionsList.this.HandleUpButton();
            }
        });
        this.upButton.setLayoutData((Object)new GridData(640));
        this.upButton.setText(MessagesForTracepointActions.TracepointActions_Up);
        this.downButton = new Button((Composite)this, 0);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracepointActionsList.this.HandleDownButton();
            }
        });
        this.downButton.setText(MessagesForTracepointActions.TracepointActions_Down);
        this.updateButtons();
    }

    public void addAction(ITracepointAction action) {
        TableItem[] currentItems = this.table.getItems();
        boolean alreadyInList = false;
        TableItem[] tableItemArray = currentItems;
        int n = currentItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem currentItem = tableItemArray[n2];
            if (((ITracepointAction)currentItem.getData()).equals(action)) {
                alreadyInList = true;
                break;
            }
            ++n2;
        }
        if (!alreadyInList) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, action.getName());
            tableItem.setText(1, action.getTypeName());
            tableItem.setText(2, action.getSummary());
            tableItem.setData((Object)action);
        }
        this.updateButtons();
    }

    public void removeAction(ITracepointAction action) {
        TableItem[] currentItems = this.table.getItems();
        int i = 0;
        while (i < currentItems.length) {
            if (((ITracepointAction)currentItems[i].getData()).equals(action)) {
                this.table.remove(i);
                break;
            }
            ++i;
        }
        this.updateButtons();
    }

    public String getActionNames() {
        StringBuilder result = new StringBuilder();
        TableItem[] currentItems = this.table.getItems();
        int i = 0;
        while (i < currentItems.length) {
            if (i > 0) {
                result.append("%_#");
            }
            result.append(((ITracepointAction)currentItems[i].getData()).getName());
            ++i;
        }
        return result.toString();
    }

    private void swapItems(TableItem item, TableItem item2) {
        String[] item2Text = new String[]{item2.getText(0), item2.getText(1), item2.getText(2)};
        Object item2Data = item2.getData();
        item2.setText(0, item.getText(0));
        item2.setText(1, item.getText(1));
        item2.setText(2, item.getText(2));
        item2.setData(item.getData());
        item.setText(0, item2Text[0]);
        item.setText(1, item2Text[1]);
        item.setText(2, item2Text[2]);
        item.setData(item2Data);
    }

    protected void HandleUpButton() {
        int[] selection = this.table.getSelectionIndices();
        if (selection.length == 1 && selection[0] > 0) {
            this.swapItems(this.table.getItem(selection[0]), this.table.getItem(selection[0] - 1));
        }
    }

    protected void HandleDownButton() {
        int[] selection = this.table.getSelectionIndices();
        if (selection.length == 1 && selection[0] < this.table.getItemCount() - 1) {
            this.swapItems(this.table.getItem(selection[0]), this.table.getItem(selection[0] + 1));
        }
    }

    protected void HandleRemoveButton() {
        this.table.remove(this.table.getSelectionIndices());
        if (this.table.getItemCount() > 0) {
            this.table.select(this.table.getItemCount() - 1);
        }
        this.updateButtons();
    }

    public void setNames(String actionNames) {
        String[] names;
        this.table.removeAll();
        String[] stringArray = names = actionNames.split("%_#");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String actionName = stringArray[n2];
            ITracepointAction action = TracepointActionManager.getInstance().findAction(actionName);
            if (action != null) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(0, action.getName());
                tableItem.setText(1, action.getTypeName());
                tableItem.setText(2, action.getSummary());
                tableItem.setData((Object)action);
            }
            ++n2;
        }
        this.updateButtons();
    }

    public void updateButtons() {
        int[] selectedItems = this.table.getSelectionIndices();
        this.removeButton.setEnabled(selectedItems.length > 0);
        this.downButton.setEnabled(selectedItems.length == 1 && selectedItems[0] < this.table.getItemCount() - 1);
        this.upButton.setEnabled(selectedItems.length == 1 && selectedItems[0] > 0);
    }

    void updateAction(ITracepointAction action) {
        TableItem[] currentItems = this.table.getItems();
        int i = 0;
        while (i < currentItems.length) {
            if (((ITracepointAction)currentItems[i].getData()).equals(action)) {
                TableItem tableItem = currentItems[i];
                tableItem.setText(0, action.getName());
                tableItem.setText(1, action.getTypeName());
                tableItem.setText(2, action.getSummary());
                break;
            }
            ++i;
        }
        this.updateButtons();
    }
}

