/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints;

import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.FlatButton;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class FlatRadioButton
extends FlatButton {
    protected static final String STATE_OFF_LABEL = "OFF";
    protected static final String STATE_ON_LABEL = "ON";
    protected boolean selection = false;

    public FlatRadioButton(Composite parent, int flags) {
        super(parent, flags);
    }

    @Override
    public Point computeSize(int wHint, int hHint) {
        GC gc = new GC((Drawable)this);
        if (this.fText == null || this.fText.isEmpty()) {
            Point e = gc.textExtent("A");
            return new Point(0, e.y + this.fMargin * 2);
        }
        Point e = gc.textExtent(this.fText);
        Point pOn = gc.textExtent(STATE_ON_LABEL);
        Point pOff = gc.textExtent(STATE_OFF_LABEL);
        int h = Math.max(pOn.y, pOff.y);
        return new Point(e.x + this.fMargin * 4 + Math.max(pOn.x, pOff.x), Math.max(e.y, h) + this.fMargin * 2);
    }

    @Override
    protected void onPaint(PaintEvent event) {
        GC gc = event.gc;
        Rectangle ca = this.getClientArea();
        Color mainColor = gc.getDevice().getSystemColor(26);
        gc.setBackground(mainColor);
        float[] mainHSB = mainColor.getRGB().getHSB();
        float h = mainHSB[0];
        float s = mainHSB[1];
        float b = mainHSB[2];
        Point e = gc.textExtent(this.fText);
        Color borderColor = new Color(gc.getDevice(), new RGB(h, s, (float)((double)b * 0.7)));
        Color shadowColor = new Color(gc.getDevice(), new RGB(h, s, (float)((double)b * 0.5)));
        gc.setForeground(borderColor);
        gc.drawRectangle(0, 0, ca.width - 1, ca.height - 1);
        gc.setForeground(shadowColor);
        gc.drawLine(0, ca.height - 1, ca.width - 1, ca.height - 1);
        gc.fillRectangle(e.x + this.fMargin * 2, 1, ca.width - 1 - e.x - this.fMargin * 2, ca.height - 2);
        gc.setForeground(gc.getDevice().getSystemColor(24));
        gc.drawText(this.fText, this.fMargin, this.fMargin, true);
        gc.setForeground(gc.getDevice().getSystemColor(27));
        Point pOn = gc.textExtent(STATE_ON_LABEL);
        Point pOff = gc.textExtent(STATE_OFF_LABEL);
        if (this.selection) {
            int offset = pOn.x < pOff.x ? (pOff.x - pOn.x) / 2 : 0;
            gc.drawText(STATE_ON_LABEL, e.x + this.fMargin * 3 + offset, this.fMargin);
        } else {
            int offset = pOn.x < pOff.x ? 0 : (pOn.x - pOff.x) / 2;
            gc.drawText(STATE_OFF_LABEL, e.x + this.fMargin * 3 + offset, this.fMargin);
        }
        borderColor.dispose();
        shadowColor.dispose();
    }

    @Override
    protected void onSelection(MouseEvent e) {
        if (this.isEnabled()) {
            this.selection = !this.selection;
            this.notifyListeners(13, null);
            this.redraw();
        }
    }

    public void setSelection(boolean selection) {
        this.selection = selection;
    }

    public boolean getSelection() {
        return this.selection;
    }
}

