/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreConfig {
    private static final Logger LOG = LoggerFactory.getLogger(CoreConfig.class);
    public static final Config.SectionParser<CoreConfig> KEY = CoreConfig::new;
    public static final boolean DEFAULT_COMMIT_GRAPH_ENABLE = false;
    public static final boolean DEFAULT_MULTIPACK_INDEX_ENABLE = false;
    private final int compression;
    private final int packIndexVersion;
    private final String excludesfile;
    private final String attributesfile;
    private final boolean commitGraph;
    private final boolean multiPackIndex;
    private final TrustStat trustStat;
    private final TrustStat trustPackedRefsStat;
    private final TrustStat trustLooseRefStat;
    private final TrustStat trustPackStat;
    private final TrustStat trustLooseObjectStat;
    private final TrustStat trustTablesListStat;

    CoreConfig(Config rc) {
        this.compression = rc.getInt("core", "compression", -1);
        this.packIndexVersion = rc.getInt("pack", "indexversion", 2);
        this.excludesfile = rc.getString("core", null, "excludesfile");
        this.attributesfile = rc.getString("core", null, "attributesfile");
        this.commitGraph = rc.getBoolean("core", "commitGraph", false);
        this.multiPackIndex = rc.getBoolean("core", "multiPackIndex", false);
        this.trustStat = CoreConfig.parseTrustStat(rc);
        this.trustPackedRefsStat = this.parseTrustPackedRefsStat(rc);
        this.trustLooseRefStat = this.parseTrustLooseRefStat(rc);
        this.trustPackStat = this.parseTrustPackFileStat(rc);
        this.trustLooseObjectStat = this.parseTrustLooseObjectFileStat(rc);
        this.trustTablesListStat = this.parseTablesListStat(rc);
    }

    private static TrustStat parseTrustStat(Config rc) {
        Boolean tfs = rc.getBoolean("core", "trustfolderstat");
        TrustStat ts = (TrustStat)rc.getEnum(TrustStat.values(), "core", null, "truststat");
        if (tfs != null) {
            if (ts == null) {
                LOG.warn(JGitText.get().deprecatedTrustFolderStat);
                return tfs != false ? TrustStat.ALWAYS : TrustStat.NEVER;
            }
            LOG.warn(JGitText.get().precedenceTrustConfig);
        }
        if (ts == null) {
            ts = TrustStat.ALWAYS;
        } else if (ts == TrustStat.INHERIT) {
            LOG.warn(JGitText.get().invalidTrustStat);
            ts = TrustStat.ALWAYS;
        }
        return ts;
    }

    private TrustStat parseTrustPackedRefsStat(Config rc) {
        return this.inheritParseTrustStat(rc, "trustPackedRefsStat");
    }

    private TrustStat parseTrustLooseRefStat(Config rc) {
        return this.inheritParseTrustStat(rc, "trustLooseRefStat");
    }

    private TrustStat parseTrustPackFileStat(Config rc) {
        return this.inheritParseTrustStat(rc, "trustPackStat");
    }

    private TrustStat parseTrustLooseObjectFileStat(Config rc) {
        return this.inheritParseTrustStat(rc, "trustLooseObjectStat");
    }

    private TrustStat inheritParseTrustStat(Config rc, String key) {
        TrustStat t = rc.getEnum("core", null, key, TrustStat.INHERIT);
        return t == TrustStat.INHERIT ? this.trustStat : t;
    }

    private TrustStat parseTablesListStat(Config rc) {
        TrustStat t = rc.getEnum("core", null, "trustTablesListStat", TrustStat.INHERIT);
        return t == TrustStat.INHERIT ? this.trustStat : t;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    public String getExcludesFile() {
        return this.excludesfile;
    }

    public String getAttributesFile() {
        return this.attributesfile;
    }

    public boolean enableCommitGraph() {
        return this.commitGraph;
    }

    public boolean useMultiPackIndex() {
        return this.multiPackIndex;
    }

    public TrustStat getTrustPackedRefsStat() {
        return this.trustPackedRefsStat;
    }

    public TrustStat getTrustLooseRefStat() {
        return this.trustLooseRefStat;
    }

    public TrustStat getTrustPackStat() {
        return this.trustPackStat;
    }

    public TrustStat getTrustLooseObjectStat() {
        return this.trustLooseObjectStat;
    }

    public TrustStat getTrustTablesListStat() {
        return this.trustTablesListStat;
    }

    public static enum AutoCRLF {
        FALSE,
        TRUE,
        INPUT;

    }

    public static enum CheckStat {
        MINIMAL,
        DEFAULT;

    }

    public static enum EOL {
        CRLF,
        LF,
        NATIVE;

    }

    public static enum EolStreamType {
        TEXT_CRLF,
        TEXT_LF,
        AUTO_CRLF,
        AUTO_LF,
        DIRECT;

    }

    public static enum HideDotFiles {
        FALSE,
        TRUE,
        DOTGITONLY;

    }

    public static enum LogRefUpdates {
        FALSE,
        TRUE,
        ALWAYS;

    }

    public static enum SymLinks {
        FALSE,
        TRUE;

    }

    @Deprecated(since="7.2", forRemoval=true)
    public static enum TrustLooseRefStat {
        ALWAYS,
        AFTER_OPEN;

    }

    @Deprecated(since="7.2", forRemoval=true)
    public static enum TrustPackedRefsStat {
        NEVER,
        ALWAYS,
        AFTER_OPEN,
        UNSET;

    }

    public static enum TrustStat {
        NEVER,
        ALWAYS,
        AFTER_OPEN,
        INHERIT;

    }
}

