/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class RetargetAction
implements IWorkbenchWindowActionDelegate,
IPartListener,
IActionDelegate2 {
    protected IWorkbenchWindow fWindow = null;
    private IWorkbenchPart fActivePart = null;
    private Object fTargetAdapter = null;
    private IAction fAction = null;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();

    protected ISelection getTargetSelection() {
        ISelectionProvider selectionProvider;
        if (this.fActivePart != null && (selectionProvider = this.fActivePart.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return EMPTY_SELECTION;
    }

    protected IWorkbenchPart getActivePart() {
        return this.fActivePart;
    }

    public void dispose() {
        this.fWindow.getPartService().removePartListener((IPartListener)this);
        this.fActivePart = null;
        this.fTargetAdapter = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        IPartService partService = window.getPartService();
        partService.addPartListener((IPartListener)this);
        IWorkbenchPart part = partService.getActivePart();
        if (part != null) {
            this.partActivated(part);
        }
    }

    public void run(IAction action) {
        if (this.fTargetAdapter != null) {
            try {
                if (this.isTargetEnabled()) {
                    this.performAction(this.fTargetAdapter, this.getTargetSelection(), this.fActivePart);
                } else {
                    String message = this.getOperationUnavailableMessage();
                    Status status = new Status(1, DebugUIPlugin.getUniqueIdentifier(), message);
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIPlugin.removeAccelerators(action.getText()), message, (IStatus)status);
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.fWindow.getShell(), ActionMessages.RetargetAction_2, ActionMessages.RetargetAction_3, e.getStatus());
            }
        }
    }

    protected abstract String getOperationUnavailableMessage();

    protected abstract void performAction(Object var1, ISelection var2, IWorkbenchPart var3) throws CoreException;

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fTargetAdapter == null && selection instanceof IStructuredSelection) {
            Object object;
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (!ss.isEmpty() && (object = ss.getFirstElement()) instanceof IAdaptable) {
                this.fTargetAdapter = this.getAdapter((IAdaptable)object);
            }
            action.setEnabled(this.fTargetAdapter != null && this.isTargetEnabled());
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.fActivePart = part;
        IResource resource = (IResource)part.getAdapter(IResource.class);
        if (resource == null && part instanceof IEditorPart) {
            resource = (IResource)((IEditorPart)part).getEditorInput().getAdapter(IResource.class);
        }
        if (resource != null) {
            this.fTargetAdapter = this.getAdapter((IAdaptable)resource);
        }
        if (this.fTargetAdapter == null) {
            this.fTargetAdapter = this.getAdapter((IAdaptable)part);
        }
        if (this.fAction != null) {
            this.fAction.setEnabled(this.fTargetAdapter != null && this.isTargetEnabled());
        }
    }

    protected Object getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        Object adapter = adaptable.getAdapter(this.getAdapterClass());
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, this.getAdapterClass().getName())) {
            adapter = adapterManager.loadAdapter((Object)adaptable, this.getAdapterClass().getName());
        }
        return adapter;
    }

    protected abstract Class<?> getAdapterClass();

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.clearPart(part);
    }

    protected void clearPart(IWorkbenchPart part) {
        if (part.equals(this.fActivePart)) {
            this.fActivePart = null;
            this.fTargetAdapter = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.clearPart(part);
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected boolean isTargetEnabled() {
        if (this.fTargetAdapter != null && this.fActivePart != null) {
            return this.canPerformAction(this.fTargetAdapter, this.getTargetSelection(), this.fActivePart);
        }
        return false;
    }

    protected abstract boolean canPerformAction(Object var1, ISelection var2, IWorkbenchPart var3);

    public void init(IAction action) {
        this.fAction = action;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected boolean hasTargetAdapter() {
        return this.fTargetAdapter != null;
    }

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

