/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.breakpoints.EnableBreakpointsAction;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class DisableAllOtherBreakpointsAction
extends EnableBreakpointsAction {
    @Override
    protected boolean isEnableAction() {
        return false;
    }

    @Override
    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List selectedBreakpoints = selection.toList();
        MultiStatus ms = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.EnableBreakpointAction_Enable_breakpoint_s__failed_2, null);
        IWorkspaceRunnable runnable = monitor -> {
            try {
                HashSet<IBreakpoint> excludedBreakpoints = new HashSet<IBreakpoint>();
                for (Object selectedObj : selectedBreakpoints) {
                    IBreakpoint breakPoint;
                    if (selectedObj instanceof IBreakpoint && (breakPoint = (IBreakpoint)selectedObj).isEnabled()) {
                        excludedBreakpoints.add(breakPoint);
                    }
                    if (!(selectedObj instanceof IBreakpointContainer)) continue;
                    IBreakpointContainer breakPointContainer = (IBreakpointContainer)selectedObj;
                    IBreakpoint[] iBreakpointArray = breakPointContainer.getBreakpoints();
                    int n = iBreakpointArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint bp = iBreakpointArray[n2];
                        if (bp.isEnabled()) {
                            excludedBreakpoints.add(bp);
                        }
                        ++n2;
                    }
                }
                IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                int n = iBreakpointArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IBreakpoint brk = iBreakpointArray[n3];
                    if (!excludedBreakpoints.contains(brk)) {
                        brk.setEnabled(false);
                    }
                    ++n3;
                }
            }
            catch (CoreException e) {
                ms.merge(e.getStatus());
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        if (!ms.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.EnableBreakpointAction_Enabling_breakpoints_3, ActionMessages.EnableBreakpointAction_Exceptions_occurred_enabling_the_breakpoint_s___4, (IStatus)ms);
            } else {
                DebugUIPlugin.log((IStatus)ms);
            }
        }
    }
}

