/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.modules;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.variables.ToggleDetailPaneAction;
import org.eclipse.debug.internal.ui.views.modules.IHelpContextIdProvider;
import org.eclipse.debug.internal.ui.views.modules.ModulesViewMessages;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ModulesView
extends VariablesView {
    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.modules_view_context";
    }

    @Override
    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("CollapseAll"));
        tbm.add((IContributionItem)new Separator("modulesGroup"));
    }

    @Override
    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyModulesGroup"));
        menu.add((IContributionItem)new Separator("modulesGroup"));
        menu.add(this.getAction(FIND_ACTION));
        menu.add((IContributionItem)new Separator());
        AvailableDetailPanesAction action = new AvailableDetailPanesAction(this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    @Override
    protected String getDetailPanePreferenceKey() {
        return "Modules.detail.orientation";
    }

    @Override
    protected String getToggleActionLabel() {
        String name;
        Object viewerInput;
        if (this.getViewer() != null && (viewerInput = this.getViewer().getInput()) != null && (name = this.getViewName(viewerInput)) != null) {
            String label = NLS.bind((String)ModulesViewMessages.ModulesView_1, (Object)name);
            return label;
        }
        return ModulesViewMessages.ModulesView_0;
    }

    @Override
    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.ModuleView";
    }

    @Override
    protected void setViewerInput(Object context) {
        super.setViewerInput(context);
        this.updateViewLabels(context);
        this.updateOrientationAction(context);
        this.updateContextHelp(context);
    }

    private void updateContextHelp(Object context) {
        IHelpContextIdProvider provider;
        String helpId;
        IAdaptable adaptable;
        if (context instanceof IAdaptable && (adaptable = (IAdaptable)context).getAdapter(IHelpContextIdProvider.class) != null && (helpId = (provider = (IHelpContextIdProvider)adaptable.getAdapter(IHelpContextIdProvider.class)).getHelpContextId("org.eclipse.debug.ui.modules_view_context")) != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getControl().getParent(), helpId);
            return;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getControl().getParent(), "org.eclipse.debug.ui.modules_view_context");
    }

    private void updateViewLabels(Object context) {
        String viewName = this.getViewName(context);
        if (!this.getPartName().equals(viewName)) {
            this.setPartName(viewName);
        }
        Image image = this.getViewImage(context);
        if (!this.getTitleImage().equals((Object)image)) {
            this.setTitleImage(image);
        }
    }

    private String getViewName(Object context) {
        ILabelProvider provider;
        String label;
        IAdaptable adaptable;
        if (context instanceof IAdaptable && (adaptable = (IAdaptable)context).getAdapter(ILabelProvider.class) != null && (label = (provider = (ILabelProvider)adaptable.getAdapter(ILabelProvider.class)).getText((Object)this)) != null) {
            return label;
        }
        return ModulesViewMessages.ModulesView_2;
    }

    private Image getViewImage(Object context) {
        ILabelProvider provider;
        Image image;
        IAdaptable adaptable;
        if (context instanceof IAdaptable && (adaptable = (IAdaptable)context).getAdapter(ILabelProvider.class) != null && (image = (provider = (ILabelProvider)adaptable.getAdapter(ILabelProvider.class)).getImage((Object)this)) != null) {
            return image;
        }
        return DebugPluginImages.getImage("IMG_CVIEW_MODULES_VIEW");
    }

    private void updateOrientationAction(Object context) {
        ToggleDetailPaneAction action = this.getToggleDetailPaneAction("Variables.detail.orientation.hidden");
        if (action != null) {
            String label = NLS.bind((String)ModulesViewMessages.ModulesView_1, (Object)this.getViewName(context));
            action.setText(label);
        }
    }
}

