/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.ssh.connector;

import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ssh.connector.ISshSettings;

public class SshSettings
implements ISshSettings {
    protected String fHost;
    protected String fUser;
    protected String fPassword;
    protected String fPort;
    protected String fTimeout;
    protected String fKeepalive;

    @Override
    public String getHost() {
        return this.fHost;
    }

    public void setHost(String strHost) {
        this.fHost = strHost;
    }

    @Override
    public String getSummary() {
        String settings = this.getUser() + "@" + this.getHost();
        if (this.getPort() != 22) {
            settings = settings + ":" + this.getPort();
        }
        return settings;
    }

    @Override
    public void load(ISettingsStore store) {
        this.fHost = store.get("Host", "");
        this.fUser = store.get("User", "");
        this.fPassword = store.get("Password", "");
        this.fPort = store.get("Port", String.valueOf(22));
        this.fTimeout = store.get("Timeout", "0");
        this.fKeepalive = store.get("Keepalive", "300");
    }

    @Override
    public void save(ISettingsStore store) {
        store.put("Host", this.fHost);
        store.put("User", this.fUser);
        store.put("Port", this.fPort);
        store.put("Timeout", this.fTimeout);
        store.put("Keepalive", this.fKeepalive);
    }

    @Override
    public int getTimeout() {
        try {
            return Integer.parseInt(this.fTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public String getTimeoutString() {
        return this.fTimeout;
    }

    public void setTimeout(String timeout) {
        this.fTimeout = timeout;
    }

    @Override
    public int getKeepalive() {
        try {
            return Integer.parseInt(this.fKeepalive);
        }
        catch (NumberFormatException numberFormatException) {
            return 300;
        }
    }

    public String getKeepaliveString() {
        return this.fKeepalive;
    }

    public void setKeepalive(String keepalive) {
        this.fKeepalive = keepalive;
    }

    @Override
    public String getUser() {
        return this.fUser;
    }

    public void setUser(String user) {
        this.fUser = user;
    }

    @Override
    public int getPort() {
        try {
            return Integer.parseInt(this.fPort);
        }
        catch (NumberFormatException numberFormatException) {
            return 22;
        }
    }

    public String getPortString() {
        return this.fPort;
    }

    public void setPort(String port) {
        this.fPort = port;
    }

    @Override
    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }
}

