/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.BlobDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;

public class BlobDeclaration
extends Declaration {
    private final int fLength;
    private final String fMediaType;

    public BlobDeclaration(int len, String mediaType) {
        this(len, mediaType, null);
    }

    public BlobDeclaration(int len, String mediaType, String role) {
        this.fLength = len;
        this.fMediaType = mediaType;
        this.setRole(role);
    }

    @Override
    public @NonNull BlobDefinition createDefinition(IDefinitionScope definitionScope, @NonNull String fieldName, @NonNull BitBuffer input) throws CTFException {
        if (this.fLength > this.getMaximumSize()) {
            throw new CTFException("Length asked: " + this.fLength + " is larger than the maximum blob size " + this.getMaximumSize());
        }
        byte[] array = new byte[this.fLength];
        if (input.getByteBuffer().remaining() < this.fLength) {
            throw new CTFException("There is not enough data provided. Length asked: " + this.fLength + " Remaining buffer size: " + input.getByteBuffer().remaining());
        }
        input.get(array);
        return new BlobDefinition(this, definitionScope, fieldName, array, this.fMediaType);
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return 1000000;
    }

    @Override
    public boolean isBinaryEquivalent(IDeclaration other) {
        return false;
    }
}

