/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public class CTFAntlrMetadataNode
implements ICTFMetadataNode {
    private ICTFMetadataNode fParent;
    private final Map<String, ICTFMetadataNode> fChildren;
    private final String fValue;
    private final String fType;
    private final ArrayList<ICTFMetadataNode> fChildrenList;

    public CTFAntlrMetadataNode(ICTFMetadataNode parent, String type, String value) {
        this.fParent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.fType = Objects.requireNonNull(type);
        this.fValue = value;
        this.fChildren = new HashMap<String, ICTFMetadataNode>();
        this.fChildrenList = new ArrayList();
    }

    @Override
    public void addChild(ICTFMetadataNode child) {
        this.fChildren.put(child.getType(), child);
        this.fChildrenList.add(child);
    }

    @Override
    public ICTFMetadataNode getParent() {
        return this.fParent;
    }

    @Override
    public ICTFMetadataNode getChild(String id) {
        return this.fChildren.get(id);
    }

    @Override
    public String getText() {
        return this.fValue;
    }

    @Override
    public ICTFMetadataNode getChild(int index) {
        return this.fChildrenList.get(index);
    }

    @Override
    public String getType() {
        return this.fType;
    }

    @Override
    public void setParent(ICTFMetadataNode node) {
        this.fParent = node;
    }

    @Override
    public List<ICTFMetadataNode> getChildren() {
        return this.fChildrenList;
    }

    @Override
    public int getChildCount() {
        return this.fChildrenList.size();
    }

    @Override
    public ICTFMetadataNode getFirstChildWithType(String type) {
        if (type != null) {
            for (ICTFMetadataNode child : this.getChildren()) {
                if (!type.equals(child.getType())) continue;
                return child;
            }
        }
        return null;
    }
}

