/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.spans;

import java.io.IOException;
import org.apache.lucene.queries.spans.SpanDisiPriorityQueue;
import org.apache.lucene.queries.spans.SpanDisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;

class SpanDisjunctionDISIApproximation
extends DocIdSetIterator {
    final SpanDisiPriorityQueue subIterators;
    final long cost;

    public SpanDisjunctionDISIApproximation(SpanDisiPriorityQueue subIterators) {
        this.subIterators = subIterators;
        long cost = 0L;
        for (SpanDisiWrapper w : subIterators) {
            cost += w.cost;
        }
        this.cost = cost;
    }

    public long cost() {
        return this.cost;
    }

    public int docID() {
        return this.subIterators.top().doc;
    }

    public int nextDoc() throws IOException {
        SpanDisiWrapper top = this.subIterators.top();
        int doc = top.doc;
        do {
            top.doc = top.approximation.nextDoc();
            top = this.subIterators.updateTop();
        } while (top.doc == doc);
        return top.doc;
    }

    public int advance(int target) throws IOException {
        SpanDisiWrapper top = this.subIterators.top();
        do {
            top.doc = top.approximation.advance(target);
            top = this.subIterators.updateTop();
        } while (top.doc < target);
        return top.doc;
    }
}

