/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.dataviewers.piechart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.dataviewers.piechart.IColorsConstants;
import org.eclipse.linuxtools.internal.dataviewers.piechart.PieChartPaintListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;

public class PieChart
extends InteractiveChart {
    protected List<RGB> colorList = new ArrayList<RGB>();
    private Color[] customColors = null;
    private PieChartPaintListener pieChartPaintListener;

    public PieChart(Composite parent, int style) {
        super(parent, style);
        for (IAxis axis : this.getAxisSet().getAxes()) {
            axis.getTitle().setVisible(false);
        }
        this.getPlotArea().getControl().setVisible(false);
        ITitle title = this.getTitle();
        if (title instanceof Control) {
            this.pieChartPaintListener = new PieChartPaintListener(this);
            this.addPaintListener(this.pieChartPaintListener);
        } else {
            this.removePaintListener((PaintListener)title);
            this.pieChartPaintListener = new PieChartPaintListener(this);
            this.addPaintListener(this.pieChartPaintListener);
            this.addPaintListener((PaintListener)title);
        }
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        xAxis.enableCategory(true);
        xAxis.setCategorySeries(new String[]{""});
    }

    public void addPaintListener(PaintListener listener) {
        if (!listener.getClass().getName().startsWith("org.eclipse.swtchart.internal.axis")) {
            super.addPaintListener(listener);
        }
    }

    public void setCustomColors(Color[] customColors) {
        this.customColors = (Color[])customColors.clone();
    }

    public void addPieChartSeries(String[] labels, double[][] val) {
        this.setSeriesNames(val[0].length);
        for (ISeries s : this.getSeriesSet().getSeries()) {
            this.getSeriesSet().deleteSeries(s.getId());
        }
        int size = Math.min(labels.length, val.length);
        for (int i = 0; i < size; ++i) {
            IBarSeries s = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, labels[i]);
            double[] d = new double[val[i].length];
            for (int j = 0; j < val[i].length; ++j) {
                d[j] = val[i][j];
            }
            s.setXSeries(d);
            if (this.customColors != null) {
                s.setBarColor(this.customColors[i % this.customColors.length]);
                continue;
            }
            s.setBarColor(new Color((Device)this.getDisplay(), this.sliceColor(i)));
        }
    }

    private void setSeriesNames(int numExpected) {
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        if (xAxis.getCategorySeries().length != numExpected) {
            int i;
            String[] seriesNames = new String[numExpected];
            int n = Math.min(xAxis.getCategorySeries().length, numExpected);
            for (i = 0; i < n; ++i) {
                seriesNames[i] = xAxis.getCategorySeries()[i];
            }
            for (i = xAxis.getCategorySeries().length; i < numExpected; ++i) {
                seriesNames[i] = "";
            }
            xAxis.setCategorySeries(seriesNames);
        }
    }

    protected RGB sliceColor(int i) {
        if (this.colorList.size() > i) {
            return this.colorList.get(i);
        }
        RGB next = IColorsConstants.COLORS[i % IColorsConstants.COLORS.length];
        this.colorList.add(next);
        return next;
    }

    public int getSliceIndexFromPosition(int pieIndex, int x, int y) {
        return this.pieChartPaintListener.getSliceIndexFromPosition(pieIndex, x, y);
    }

    public double getSlicePercent(int pieIndex, int sliceIndex) {
        double max = 0.0;
        ISeries[] series = this.getSeriesSet().getSeries();
        for (int i = 0; i < series.length; ++i) {
            max += series[i].getXSeries()[pieIndex];
        }
        return series[sliceIndex].getXSeries()[pieIndex] / max * 100.0;
    }
}

