/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.wizards;

import org.eclipse.cdt.autotools.core.AutotoolsNewProjectNature;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.autotools.core.AutotoolsNewMakeGenerator;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.wizards.AutotoolsProjectImportWizard;
import org.eclipse.cdt.internal.autotools.ui.wizards.AutotoolsWizardMessages;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewMakeProjFromExistingPage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AutotoolsProjectImportWizardPage
extends NewMakeProjFromExistingPage {
    private Button langc;
    private Button langcpp;

    protected AutotoolsProjectImportWizardPage() {
        this.setTitle(AutotoolsWizardMessages.getResourceString("ImportWizardPage.title"));
        this.setDescription(AutotoolsWizardMessages.getResourceString("ImportWizardPage.description"));
    }

    protected IProjectType getProjectType() {
        return ((AutotoolsProjectImportWizard)this.getWizard()).getProjectType();
    }

    protected IConfiguration[] getSelectedConfigurations() {
        return ((AutotoolsProjectImportWizard)this.getWizard()).getSelectedConfigurations();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addProjectNameSelector(comp);
        this.addSourceSelector(comp);
        this.addLanguageSelector(comp);
        this.setControl((Control)comp);
    }

    public void addLanguageSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText("Select project language");
        SelectionAdapter cListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AutotoolsProjectImportWizardPage.this.validatePage();
            }
        };
        this.langc = ControlFactory.createRadioButton((Composite)group, (String)CUIMessages.ConvertProjectWizardPage_CProject, (String)"C ", (SelectionListener)cListener);
        this.langc.setSelection(true);
        this.langcpp = ControlFactory.createRadioButton((Composite)group, (String)CUIMessages.ConvertProjectWizardPage_CppProject, (String)"C++ ", (SelectionListener)cListener);
        this.langcpp.setSelection(false);
    }

    public IToolChain getToolChain() {
        return this.getSelectedConfigurations()[0].getToolChain();
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        monitor.beginTask(AutotoolsUIPlugin.getResourceString("WizardMakeProjectConversion.monitor.convertingToMakeProject"), 7);
        IConfiguration defaultCfg = null;
        try {
            monitor.subTask(AutotoolsUIPlugin.getResourceString("adding project nature"));
            ManagedCProjectNature.addManagedNature((IProject)project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            AutotoolsNewProjectNature.addAutotoolsNature((IProject)project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            monitor.subTask(AutotoolsUIPlugin.getResourceString("adding builder"));
            AutotoolsNewProjectNature.addAutotoolsBuilder((IProject)project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            project.setPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W, "true");
            CCorePlugin.getDefault().mapCProjectOwner(project, projectID, false);
            IManagedProject newManagedProject = null;
            ManagedBuildInfo info = null;
            try {
                info = ManagedBuildManager.createBuildInfo((IResource)project);
                newManagedProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)this.getProjectType());
                if (newManagedProject != null) {
                    int i = 0;
                    while (i < this.getSelectedConfigurations().length) {
                        IConfiguration config = this.getSelectedConfigurations()[i];
                        int id = ManagedBuildManager.getRandomNumber();
                        IConfiguration newConfig = newManagedProject.createConfiguration(config, config.getId() + "." + id);
                        newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
                        ++i;
                    }
                    IConfiguration[] newConfigs = newManagedProject.getConfigurations();
                    int i2 = 0;
                    while (i2 < newConfigs.length) {
                        if (newConfigs[i2].isSupported()) {
                            defaultCfg = newConfigs[i2];
                            break;
                        }
                        ++i2;
                    }
                    if (defaultCfg == null && newConfigs.length > 0) {
                        defaultCfg = newConfigs[0];
                    }
                    if (defaultCfg != null) {
                        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultCfg);
                        ManagedBuildManager.setSelectedConfiguration((IProject)project, (IConfiguration)defaultCfg);
                    }
                    ManagedBuildManager.setNewProjectVersion((IProject)project);
                    AutotoolsNewMakeGenerator m = new AutotoolsNewMakeGenerator();
                    CUIPlugin.getDefault().startGlobalConsole();
                    m.initialize(project, (IManagedBuildInfo)info, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    try {
                        m.reconfigure();
                    }
                    catch (CoreException coreException) {}
                }
            }
            catch (BuildException e) {
                AutotoolsUIPlugin.log(e);
            }
            monitor.subTask(AutotoolsUIPlugin.getResourceString("saving project"));
            if (info != null) {
                info.setValid(true);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isC() {
        return this.langc.getSelection();
    }

    public boolean isCPP() {
        return this.langcpp.getSelection();
    }
}

