/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.ScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GCCScannerInfoConsoleParser
extends AbstractGCCBOPConsoleParser {
    protected ScannerInfoConsoleParserUtility fUtil = null;
    private String fDefaultMacroDefinitionValue = "1";

    @Override
    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fUtil = project != null && workingDirectory != null && markerGenerator != null ? new ScannerInfoConsoleParserUtility(project, workingDirectory, markerGenerator) : null;
        super.startup(project, collector);
    }

    @Override
    protected AbstractGCCBOPConsoleParserUtility getUtility() {
        return this.fUtil;
    }

    @Override
    protected boolean processCommand(String[] tokens) {
        CopyOnWriteArrayList<String> translatedIncludesToPut;
        int compilerInvocationIdx = this.findCompilerInvocation(tokens);
        if (compilerInvocationIdx < 0) {
            return false;
        }
        if (compilerInvocationIdx + 1 >= tokens.length) {
            return false;
        }
        CopyOnWriteArrayList<String> includes = new CopyOnWriteArrayList<String>();
        CopyOnWriteArrayList<String> symbols = new CopyOnWriteArrayList<String>();
        CopyOnWriteArrayList<String> targetSpecificOptions = new CopyOnWriteArrayList<String>();
        String fileName = null;
        int j = compilerInvocationIdx + 1;
        while (j < tokens.length) {
            String token = tokens[j];
            if (!token.equals("-I-")) {
                String possibleFileName;
                if (token.startsWith("-I")) {
                    candidate = null;
                    if (token.length() > 2) {
                        candidate = token.substring(2).trim();
                    } else if (j + 1 < tokens.length) {
                        candidate = tokens[j + 1];
                        if (((String)candidate).startsWith("-")) {
                            candidate = null;
                        } else {
                            ++j;
                        }
                    }
                    if (candidate != null && ((String)candidate).length() > 0) {
                        if (this.fUtil != null) {
                            candidate = this.fUtil.normalizePath((String)candidate);
                        }
                        if (!includes.contains(candidate)) {
                            includes.add((String)candidate);
                        }
                    }
                } else if (token.startsWith("-D")) {
                    candidate = null;
                    if (token.length() > 2) {
                        candidate = token.substring(2).trim();
                    } else if (j + 1 < tokens.length) {
                        candidate = tokens[j + 1];
                        if (((String)candidate).startsWith("-")) {
                            candidate = null;
                        } else {
                            ++j;
                        }
                    }
                    if (candidate != null && ((String)candidate).length() > 0) {
                        if (((String)candidate).indexOf(61) == -1) {
                            candidate = (String)candidate + "=" + this.fDefaultMacroDefinitionValue;
                        }
                        if (!symbols.contains(candidate)) {
                            symbols.add((String)candidate);
                        }
                    }
                } else if (token.startsWith("-m") || token.startsWith("--sysroot") || token.equals("-ansi") || token.equals("-nostdinc") || token.equals("-posix") || token.equals("-pthread") || token.startsWith("-O") || token.equals("-fno-inline") || token.startsWith("-finline") || token.equals("-fno-exceptions") || token.equals("-fexceptions") || token.equals("-fshort-wchar") || token.equals("-fshort-double") || token.equals("-fno-signed-char") || token.equals("-fsigned-char") || token.startsWith("-fabi-version=")) {
                    if (!targetSpecificOptions.contains(token)) {
                        targetSpecificOptions.add(token);
                    }
                } else if (fileName == null && ((possibleFileName = token.toLowerCase()).endsWith(".c") || possibleFileName.endsWith(".cpp") || possibleFileName.endsWith(".cc") || possibleFileName.endsWith(".cxx") || possibleFileName.endsWith(".C") || possibleFileName.endsWith(".CPP") || possibleFileName.endsWith(".CC") || possibleFileName.endsWith(".CXX") || possibleFileName.endsWith(".c++"))) {
                    fileName = token;
                }
            }
            ++j;
        }
        if (fileName != null && fileName.startsWith("/cygdrive/")) {
            fileName = AbstractGCCBOPConsoleParserUtility.convertCygpath((IPath)new Path(fileName)).toOSString();
        }
        if (fileName == null || fileName.trim().length() == 0) {
            return false;
        }
        IProject project = this.getProject();
        IFile file = null;
        List<String> translatedIncludes = new LinkedList<String>();
        translatedIncludes.addAll(includes);
        if (includes.size() > 0) {
            if (this.fUtil != null && (file = this.fUtil.findFile(fileName)) != null) {
                project = file.getProject();
                translatedIncludes = this.fUtil.translateRelativePaths(file, fileName, includes);
            }
            if (file == null && this.fUtil != null) {
                Iterator iterator = translatedIncludes.iterator();
                while (iterator.hasNext()) {
                    String include = (String)iterator.next();
                    Path includePath = new Path(include);
                    if (includePath.isAbsolute() || includePath.isUNC()) continue;
                    iterator.remove();
                }
            }
        }
        if ((translatedIncludesToPut = new CopyOnWriteArrayList<String>(translatedIncludes)).size() > 0 || symbols.size() > 0) {
            HashMap<ScannerInfoTypes, CopyOnWriteArrayList<String>> scannerInfo = new HashMap<ScannerInfoTypes, CopyOnWriteArrayList<String>>();
            scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, translatedIncludesToPut);
            scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, symbols);
            scannerInfo.put(ScannerInfoTypes.TARGET_SPECIFIC_OPTION, targetSpecificOptions);
            this.getCollector().contributeToScannerConfig(project, scannerInfo);
            TraceUtil.outputTrace("Discovered scanner info for file '" + fileName + "'", "Include paths", includes, translatedIncludesToPut, "Defined symbols", symbols);
        }
        return true;
    }

    public void setDefaultMacroDefinitionValue(String val) {
        if (val != null) {
            this.fDefaultMacroDefinitionValue = val;
        }
    }
}

