/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui.views;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;

public class RemoteConnectionsContentProvider
implements ITreeContentProvider,
IRemoteConnectionChangeListener {
    private IRemoteServicesManager remoteServicesManager;
    private Viewer viewer;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (newInput instanceof IRemoteServicesManager) {
            if (this.remoteServicesManager != null) {
                this.remoteServicesManager.removeRemoteConnectionChangeListener((IRemoteConnectionChangeListener)this);
            }
            this.remoteServicesManager = (IRemoteServicesManager)newInput;
            this.remoteServicesManager.addRemoteConnectionChangeListener((IRemoteConnectionChangeListener)this);
        }
    }

    public void connectionChanged(RemoteConnectionChangeEvent event) {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RemoteConnectionsContentProvider.this.viewer.refresh();
            }
        });
    }

    public void dispose() {
        if (this.remoteServicesManager != null) {
            this.remoteServicesManager.removeRemoteConnectionChangeListener((IRemoteConnectionChangeListener)this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.remoteServicesManager.getAllRemoteConnections().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IRemoteConnection) {
            return this.remoteServicesManager;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IRemoteServicesManager;
    }
}

