/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyImageNode;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerLabelProvider;
import org.eclipse.swt.graphics.Image;

public class DockerImageHierarchyLabelProvider
extends DockerExplorerLabelProvider {
    @Override
    public Image getImage(Object element) {
        if (element instanceof IDockerImageHierarchyNode) {
            return super.getImage(((IDockerImageHierarchyNode)element).getElement());
        }
        return super.getImage(element);
    }

    @Override
    public StyledString getStyledText(Object element) {
        if (element instanceof IDockerImageHierarchyImageNode) {
            IDockerImage image = ((IDockerImageHierarchyImageNode)element).getElement();
            return DockerImageHierarchyLabelProvider.getStyledText(image);
        }
        if (element instanceof IDockerImageHierarchyNode) {
            return super.getStyledText(((IDockerImageHierarchyNode)element).getElement());
        }
        return super.getStyledText(element);
    }

    public static StyledString getStyledText(IDockerImage image) {
        Map imageTagsByRepo = DockerImage.extractTagsByRepo((List)image.repoTags());
        ArrayList imageRepos = new ArrayList(imageTagsByRepo.keySet());
        Collections.sort(imageRepos);
        StyledString result = new StyledString();
        imageRepos.forEach(repo -> {
            result.append(repo);
            List tags = (List)imageTagsByRepo.get(repo);
            String joinedTags = tags.stream().collect(Collectors.joining(", "));
            result.append(':');
            result.append(joinedTags, StyledString.COUNTER_STYLER);
            result.append(' ');
        });
        result.append('(', StyledString.QUALIFIER_STYLER).append(((DockerImage)image).shortId(), StyledString.QUALIFIER_STYLER).append(')', StyledString.QUALIFIER_STYLER);
        return result;
    }
}

