/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DockerImageTagSearchResult;

public class ImageSearchModel
extends BaseDatabindingModel {
    public static final String TERM = "term";
    public static final String IMAGE_SEARCH_RESULT = "imageSearchResult";
    public static final String SELECTED_IMAGE = "selectedImage";
    public static final String IMAGE_TAG_SEARCH_RESULT = "imageTagSearchResult";
    public static final String SELECTED_IMAGE_TAG = "selectedImageTag";
    private final IDockerConnection selectedConnection;
    private String term = null;
    private List<IDockerImageSearchResult> imageSearchResult;
    private IDockerImageSearchResult selectedImage;
    private List<DockerImageTagSearchResult> imageTagSearchResult;
    private DockerImageTagSearchResult selectedImageTag;

    public ImageSearchModel(IDockerConnection selectedConnection, String term) {
        this.selectedConnection = selectedConnection;
        this.term = term == null ? null : (term.indexOf(58) != -1 ? term.substring(0, term.lastIndexOf(58)) : term);
    }

    public IDockerConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
        this.firePropertyChange(TERM, this.term, this.term);
    }

    public List<IDockerImageSearchResult> getImageSearchResult() {
        return this.imageSearchResult;
    }

    public void setImageSearchResult(List<IDockerImageSearchResult> searchResult) {
        this.imageSearchResult = searchResult;
        this.firePropertyChange(IMAGE_SEARCH_RESULT, this.imageSearchResult, this.imageSearchResult);
        if (!this.imageSearchResult.isEmpty()) {
            this.setSelectedImage(this.imageSearchResult.get(0));
        }
    }

    public IDockerImageSearchResult getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(IDockerImageSearchResult selectedImage) {
        this.selectedImage = selectedImage;
        this.firePropertyChange(SELECTED_IMAGE, this.selectedImage, this.selectedImage);
    }

    public List<DockerImageTagSearchResult> getImageTagSearchResult() {
        return this.imageTagSearchResult;
    }

    public void setImageTagSearchResult(List<DockerImageTagSearchResult> searchTagResult) {
        this.imageTagSearchResult = searchTagResult;
        this.firePropertyChange(IMAGE_TAG_SEARCH_RESULT, this.imageTagSearchResult, this.imageTagSearchResult);
        if (!this.imageTagSearchResult.isEmpty()) {
            this.setSelectedImageTag(this.imageTagSearchResult.get(0));
        }
    }

    public DockerImageTagSearchResult getSelectedImageTag() {
        return this.selectedImageTag;
    }

    public void setSelectedImageTag(DockerImageTagSearchResult selectedImageTag) {
        this.selectedImageTag = selectedImageTag;
        this.firePropertyChange(SELECTED_IMAGE_TAG, this.selectedImageTag, this.selectedImageTag);
    }
}

